/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.NetAddress;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NetInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_MAC_ADDRESS = "mac_address";
    @SerializedName(value="mac_address")
    private String macAddress;
    public static final String SERIALIZED_NAME_SUBNETS = "subnets";
    @SerializedName(value="subnets")
    private List<@Valid NetAddress> subnets = new ArrayList<NetAddress>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NetInterface macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Nullable
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public NetInterface subnets(List<@Valid NetAddress> subnets) {
        this.subnets = subnets;
        return this;
    }

    public NetInterface addSubnetsItem(NetAddress subnetsItem) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<NetAddress>();
        }
        this.subnets.add(subnetsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid NetAddress> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(List<@Valid NetAddress> subnets) {
        this.subnets = subnets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetInterface netInterface = (NetInterface)o;
        return Objects.equals(this.macAddress, netInterface.macAddress) && Objects.equals(this.subnets, netInterface.subnets);
    }

    public int hashCode() {
        return Objects.hash(this.macAddress, this.subnets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetInterface {\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    subnets: ").append(this.toIndentedString(this.subnets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysubnets;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NetInterface is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NetInterface` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mac_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBNETS) != null && !jsonObj.get(SERIALIZED_NAME_SUBNETS).isJsonNull() && (jsonArraysubnets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBNETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBNETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subnets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBNETS).toString()));
            }
            for (int i = 0; i < jsonArraysubnets.size(); ++i) {
                NetAddress.validateJsonElement(jsonArraysubnets.get(i));
            }
        }
    }

    public static NetInterface fromJson(String jsonString) throws IOException {
        return (NetInterface)JSON.getGson().fromJson(jsonString, NetInterface.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MAC_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_SUBNETS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NetInterface.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NetInterface.class));
            return new TypeAdapter<NetInterface>(this){

                public void write(JsonWriter out, NetInterface value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NetInterface read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NetInterface.validateJsonElement(jsonElement);
                    return (NetInterface)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

