/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.PluginConfigArgs;
import io.github.pod4dev.libpodj.model.PluginConfigInterface;
import io.github.pod4dev.libpodj.model.PluginConfigLinux;
import io.github.pod4dev.libpodj.model.PluginConfigNetwork;
import io.github.pod4dev.libpodj.model.PluginConfigRootfs;
import io.github.pod4dev.libpodj.model.PluginConfigUser;
import io.github.pod4dev.libpodj.model.PluginEnv;
import io.github.pod4dev.libpodj.model.PluginMount;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PluginConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ARGS = "Args";
    @SerializedName(value="Args")
    private PluginConfigArgs args;
    public static final String SERIALIZED_NAME_DESCRIPTION = "Description";
    @SerializedName(value="Description")
    private String description;
    public static final String SERIALIZED_NAME_DOCUMENTATION = "Documentation";
    @SerializedName(value="Documentation")
    private String documentation;
    public static final String SERIALIZED_NAME_ENTRYPOINT = "Entrypoint";
    @SerializedName(value="Entrypoint")
    private List<String> entrypoint = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ENV = "Env";
    @SerializedName(value="Env")
    private List<@Valid PluginEnv> env = new ArrayList<PluginEnv>();
    public static final String SERIALIZED_NAME_INTERFACE = "Interface";
    @SerializedName(value="Interface")
    private PluginConfigInterface _interface;
    public static final String SERIALIZED_NAME_IPC_HOST = "IpcHost";
    @SerializedName(value="IpcHost")
    private Boolean ipcHost;
    public static final String SERIALIZED_NAME_LINUX = "Linux";
    @SerializedName(value="Linux")
    private PluginConfigLinux linux;
    public static final String SERIALIZED_NAME_MOUNTS = "Mounts";
    @SerializedName(value="Mounts")
    private List<@Valid PluginMount> mounts = new ArrayList<PluginMount>();
    public static final String SERIALIZED_NAME_NETWORK = "Network";
    @SerializedName(value="Network")
    private PluginConfigNetwork network;
    public static final String SERIALIZED_NAME_PID_HOST = "PidHost";
    @SerializedName(value="PidHost")
    private Boolean pidHost;
    public static final String SERIALIZED_NAME_PROPAGATED_MOUNT = "PropagatedMount";
    @SerializedName(value="PropagatedMount")
    private String propagatedMount;
    public static final String SERIALIZED_NAME_WORK_DIR = "WorkDir";
    @SerializedName(value="WorkDir")
    private String workDir;
    public static final String SERIALIZED_NAME_DOCKER_VERSION = "DockerVersion";
    @SerializedName(value="DockerVersion")
    private String dockerVersion;
    public static final String SERIALIZED_NAME_USER = "User";
    @SerializedName(value="User")
    private PluginConfigUser user;
    public static final String SERIALIZED_NAME_ROOTFS = "rootfs";
    @SerializedName(value="rootfs")
    private PluginConfigRootfs rootfs;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PluginConfig args(PluginConfigArgs args) {
        this.args = args;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginConfigArgs getArgs() {
        return this.args;
    }

    public void setArgs(PluginConfigArgs args) {
        this.args = args;
    }

    public PluginConfig description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PluginConfig documentation(String documentation) {
        this.documentation = documentation;
        return this;
    }

    @Nonnull
    @NotNull
    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public PluginConfig entrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public PluginConfig addEntrypointItem(String entrypointItem) {
        if (this.entrypoint == null) {
            this.entrypoint = new ArrayList<String>();
        }
        this.entrypoint.add(entrypointItem);
        return this;
    }

    @Nonnull
    @NotNull
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public PluginConfig env(List<@Valid PluginEnv> env) {
        this.env = env;
        return this;
    }

    public PluginConfig addEnvItem(PluginEnv envItem) {
        if (this.env == null) {
            this.env = new ArrayList<PluginEnv>();
        }
        this.env.add(envItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public @NotNull @Valid List<@Valid PluginEnv> getEnv() {
        return this.env;
    }

    public void setEnv(List<@Valid PluginEnv> env) {
        this.env = env;
    }

    public PluginConfig _interface(PluginConfigInterface _interface) {
        this._interface = _interface;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginConfigInterface getInterface() {
        return this._interface;
    }

    public void setInterface(PluginConfigInterface _interface) {
        this._interface = _interface;
    }

    public PluginConfig ipcHost(Boolean ipcHost) {
        this.ipcHost = ipcHost;
        return this;
    }

    @Nonnull
    @NotNull
    public Boolean getIpcHost() {
        return this.ipcHost;
    }

    public void setIpcHost(Boolean ipcHost) {
        this.ipcHost = ipcHost;
    }

    public PluginConfig linux(PluginConfigLinux linux) {
        this.linux = linux;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginConfigLinux getLinux() {
        return this.linux;
    }

    public void setLinux(PluginConfigLinux linux) {
        this.linux = linux;
    }

    public PluginConfig mounts(List<@Valid PluginMount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public PluginConfig addMountsItem(PluginMount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<PluginMount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public @NotNull @Valid List<@Valid PluginMount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid PluginMount> mounts) {
        this.mounts = mounts;
    }

    public PluginConfig network(PluginConfigNetwork network) {
        this.network = network;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginConfigNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(PluginConfigNetwork network) {
        this.network = network;
    }

    public PluginConfig pidHost(Boolean pidHost) {
        this.pidHost = pidHost;
        return this;
    }

    @Nonnull
    @NotNull
    public Boolean getPidHost() {
        return this.pidHost;
    }

    public void setPidHost(Boolean pidHost) {
        this.pidHost = pidHost;
    }

    public PluginConfig propagatedMount(String propagatedMount) {
        this.propagatedMount = propagatedMount;
        return this;
    }

    @Nonnull
    @NotNull
    public String getPropagatedMount() {
        return this.propagatedMount;
    }

    public void setPropagatedMount(String propagatedMount) {
        this.propagatedMount = propagatedMount;
    }

    public PluginConfig workDir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    @Nonnull
    @NotNull
    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public PluginConfig dockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
        return this;
    }

    @Nullable
    public String getDockerVersion() {
        return this.dockerVersion;
    }

    public void setDockerVersion(String dockerVersion) {
        this.dockerVersion = dockerVersion;
    }

    public PluginConfig user(PluginConfigUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    public PluginConfigUser getUser() {
        return this.user;
    }

    public void setUser(PluginConfigUser user) {
        this.user = user;
    }

    public PluginConfig rootfs(PluginConfigRootfs rootfs) {
        this.rootfs = rootfs;
        return this;
    }

    @Nullable
    @Valid
    public PluginConfigRootfs getRootfs() {
        return this.rootfs;
    }

    public void setRootfs(PluginConfigRootfs rootfs) {
        this.rootfs = rootfs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginConfig pluginConfig = (PluginConfig)o;
        return Objects.equals(this.args, pluginConfig.args) && Objects.equals(this.description, pluginConfig.description) && Objects.equals(this.documentation, pluginConfig.documentation) && Objects.equals(this.entrypoint, pluginConfig.entrypoint) && Objects.equals(this.env, pluginConfig.env) && Objects.equals(this._interface, pluginConfig._interface) && Objects.equals(this.ipcHost, pluginConfig.ipcHost) && Objects.equals(this.linux, pluginConfig.linux) && Objects.equals(this.mounts, pluginConfig.mounts) && Objects.equals(this.network, pluginConfig.network) && Objects.equals(this.pidHost, pluginConfig.pidHost) && Objects.equals(this.propagatedMount, pluginConfig.propagatedMount) && Objects.equals(this.workDir, pluginConfig.workDir) && Objects.equals(this.dockerVersion, pluginConfig.dockerVersion) && Objects.equals(this.user, pluginConfig.user) && Objects.equals(this.rootfs, pluginConfig.rootfs);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.description, this.documentation, this.entrypoint, this.env, this._interface, this.ipcHost, this.linux, this.mounts, this.network, this.pidHost, this.propagatedMount, this.workDir, this.dockerVersion, this.user, this.rootfs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PluginConfig {\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentation: ").append(this.toIndentedString(this.documentation)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    _interface: ").append(this.toIndentedString(this._interface)).append("\n");
        sb.append("    ipcHost: ").append(this.toIndentedString(this.ipcHost)).append("\n");
        sb.append("    linux: ").append(this.toIndentedString(this.linux)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    pidHost: ").append(this.toIndentedString(this.pidHost)).append("\n");
        sb.append("    propagatedMount: ").append(this.toIndentedString(this.propagatedMount)).append("\n");
        sb.append("    workDir: ").append(this.toIndentedString(this.workDir)).append("\n");
        sb.append("    dockerVersion: ").append(this.toIndentedString(this.dockerVersion)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    rootfs: ").append(this.toIndentedString(this.rootfs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PluginConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PluginConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        PluginConfigArgs.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ARGS));
        if (!jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Documentation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENV).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Env` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENV).toString()));
        }
        JsonArray jsonArrayenv = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENV);
        for (int i = 0; i < jsonArrayenv.size(); ++i) {
            PluginEnv.validateJsonElement(jsonArrayenv.get(i));
        }
        PluginConfigInterface.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTERFACE));
        PluginConfigLinux.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LINUX));
        if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
        }
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS);
        for (int i = 0; i < jsonArraymounts.size(); ++i) {
            PluginMount.validateJsonElement(jsonArraymounts.get(i));
        }
        PluginConfigNetwork.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETWORK));
        if (!jsonObj.get(SERIALIZED_NAME_PROPAGATED_MOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PropagatedMount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROPAGATED_MOUNT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_WORK_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `WorkDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORK_DIR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `DockerVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCKER_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull()) {
            PluginConfigUser.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USER));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS).isJsonNull()) {
            PluginConfigRootfs.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROOTFS));
        }
    }

    public static PluginConfig fromJson(String jsonString) throws IOException {
        return (PluginConfig)JSON.getGson().fromJson(jsonString, PluginConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARGS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTATION);
        openapiFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiFields.add(SERIALIZED_NAME_ENV);
        openapiFields.add(SERIALIZED_NAME_INTERFACE);
        openapiFields.add(SERIALIZED_NAME_IPC_HOST);
        openapiFields.add(SERIALIZED_NAME_LINUX);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_PID_HOST);
        openapiFields.add(SERIALIZED_NAME_PROPAGATED_MOUNT);
        openapiFields.add(SERIALIZED_NAME_WORK_DIR);
        openapiFields.add(SERIALIZED_NAME_DOCKER_VERSION);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_ROOTFS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ARGS);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENTATION);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiRequiredFields.add(SERIALIZED_NAME_ENV);
        openapiRequiredFields.add(SERIALIZED_NAME_INTERFACE);
        openapiRequiredFields.add(SERIALIZED_NAME_IPC_HOST);
        openapiRequiredFields.add(SERIALIZED_NAME_LINUX);
        openapiRequiredFields.add(SERIALIZED_NAME_MOUNTS);
        openapiRequiredFields.add(SERIALIZED_NAME_NETWORK);
        openapiRequiredFields.add(SERIALIZED_NAME_PID_HOST);
        openapiRequiredFields.add(SERIALIZED_NAME_PROPAGATED_MOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_WORK_DIR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PluginConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PluginConfig.class));
            return new TypeAdapter<PluginConfig>(this){

                public void write(JsonWriter out, PluginConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PluginConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PluginConfig.validateJsonElement(jsonElement);
                    return (PluginConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

