/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IDMappingOptions;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxResources;
import io.github.pod4dev.libpodj.model.LinuxThrottleDevice;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PodSpecGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private Map<String, PerNetworkOptions> networks = new HashMap<String, PerNetworkOptions>();
    public static final String SERIALIZED_NAME_CGROUP_PARENT = "cgroup_parent";
    @SerializedName(value="cgroup_parent")
    private String cgroupParent;
    public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
    @SerializedName(value="cni_networks")
    private List<String> cniNetworks = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CPU_PERIOD = "cpu_period";
    @SerializedName(value="cpu_period")
    private Integer cpuPeriod;
    public static final String SERIALIZED_NAME_CPU_QUOTA = "cpu_quota";
    @SerializedName(value="cpu_quota")
    private Long cpuQuota;
    public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
    @SerializedName(value="dns_option")
    private List<String> dnsOption = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
    @SerializedName(value="dns_search")
    private List<String> dnsSearch = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
    @SerializedName(value="dns_server")
    private List<String> dnsServer = new ArrayList<String>();
    public static final String SERIALIZED_NAME_EXIT_POLICY = "exit_policy";
    @SerializedName(value="exit_policy")
    private String exitPolicy;
    public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
    @SerializedName(value="hostadd")
    private List<String> hostadd = new ArrayList<String>();
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_HOSTS_FILE = "hostsFile";
    @SerializedName(value="hostsFile")
    private String hostsFile;
    public static final String SERIALIZED_NAME_IDMAPPINGS = "idmappings";
    @SerializedName(value="idmappings")
    private IDMappingOptions idmappings;
    public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
    @SerializedName(value="image_volumes")
    private List<@Valid ImageVolume> imageVolumes = new ArrayList<ImageVolume>();
    public static final String SERIALIZED_NAME_INFRA_COMMAND = "infra_command";
    @SerializedName(value="infra_command")
    private List<String> infraCommand = new ArrayList<String>();
    public static final String SERIALIZED_NAME_INFRA_CONMON_PID_FILE = "infra_conmon_pid_file";
    @SerializedName(value="infra_conmon_pid_file")
    private String infraConmonPidFile;
    public static final String SERIALIZED_NAME_INFRA_IMAGE = "infra_image";
    @SerializedName(value="infra_image")
    private String infraImage;
    public static final String SERIALIZED_NAME_INFRA_NAME = "infra_name";
    @SerializedName(value="infra_name")
    private String infraName;
    public static final String SERIALIZED_NAME_IPCNS = "ipcns";
    @SerializedName(value="ipcns")
    private Namespace ipcns;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_MOUNTS = "mounts";
    @SerializedName(value="mounts")
    private List<@Valid Mount> mounts = new ArrayList<Mount>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NETNS = "netns";
    @SerializedName(value="netns")
    private Namespace netns;
    public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
    @SerializedName(value="network_options")
    private Map<String, List<String>> networkOptions = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_NO_INFRA = "no_infra";
    @SerializedName(value="no_infra")
    private Boolean noInfra;
    public static final String SERIALIZED_NAME_NO_MANAGE_HOSTNAME = "no_manage_hostname";
    @SerializedName(value="no_manage_hostname")
    private Boolean noManageHostname;
    public static final String SERIALIZED_NAME_NO_MANAGE_HOSTS = "no_manage_hosts";
    @SerializedName(value="no_manage_hosts")
    private Boolean noManageHosts;
    public static final String SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF = "no_manage_resolv_conf";
    @SerializedName(value="no_manage_resolv_conf")
    private Boolean noManageResolvConf;
    public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
    @SerializedName(value="overlay_volumes")
    private List<@Valid OverlayVolume> overlayVolumes = new ArrayList<OverlayVolume>();
    public static final String SERIALIZED_NAME_PIDNS = "pidns";
    @SerializedName(value="pidns")
    private Namespace pidns;
    public static final String SERIALIZED_NAME_POD_CREATE_COMMAND = "pod_create_command";
    @SerializedName(value="pod_create_command")
    private List<String> podCreateCommand = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POD_DEVICES = "pod_devices";
    @SerializedName(value="pod_devices")
    private List<String> podDevices = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
    @SerializedName(value="portmappings")
    private List<@Valid PortMapping> portmappings = new ArrayList<PortMapping>();
    public static final String SERIALIZED_NAME_RESOURCE_LIMITS = "resource_limits";
    @SerializedName(value="resource_limits")
    private LinuxResources resourceLimits;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
    @SerializedName(value="restart_policy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
    @SerializedName(value="restart_tries")
    private Integer restartTries;
    public static final String SERIALIZED_NAME_SECURITY_OPT = "security_opt";
    @SerializedName(value="security_opt")
    private List<String> securityOpt = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SERVICE_CONTAINER_I_D = "serviceContainerID";
    @SerializedName(value="serviceContainerID")
    private String serviceContainerID;
    public static final String SERIALIZED_NAME_SHARE_PARENT = "share_parent";
    @SerializedName(value="share_parent")
    private Boolean shareParent;
    public static final String SERIALIZED_NAME_SHARED_NAMESPACES = "shared_namespaces";
    @SerializedName(value="shared_namespaces")
    private List<String> sharedNamespaces = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
    @SerializedName(value="shm_size")
    private Long shmSize;
    public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
    @SerializedName(value="shm_size_systemd")
    private Long shmSizeSystemd;
    public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
    @SerializedName(value="sysctl")
    private Map<String, String> sysctl = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE = "throttleReadBpsDevice";
    @SerializedName(value="throttleReadBpsDevice")
    private Map<String, LinuxThrottleDevice> throttleReadBpsDevice = new HashMap<String, LinuxThrottleDevice>();
    public static final String SERIALIZED_NAME_USERNS = "userns";
    @SerializedName(value="userns")
    private Namespace userns;
    public static final String SERIALIZED_NAME_UTSNS = "utsns";
    @SerializedName(value="utsns")
    private Namespace utsns;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    private List<@Valid NamedVolume> volumes = new ArrayList<NamedVolume>();
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
    @SerializedName(value="volumes_from")
    private List<String> volumesFrom = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodSpecGenerator networks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
        return this;
    }

    public PodSpecGenerator putNetworksItem(String key, PerNetworkOptions networksItem) {
        if (this.networks == null) {
            this.networks = new HashMap<String, PerNetworkOptions>();
        }
        this.networks.put(key, networksItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, PerNetworkOptions> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
    }

    public PodSpecGenerator cgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    @Nullable
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    public void setCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
    }

    public PodSpecGenerator cniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
        return this;
    }

    public PodSpecGenerator addCniNetworksItem(String cniNetworksItem) {
        if (this.cniNetworks == null) {
            this.cniNetworks = new ArrayList<String>();
        }
        this.cniNetworks.add(cniNetworksItem);
        return this;
    }

    @Nullable
    public List<String> getCniNetworks() {
        return this.cniNetworks;
    }

    public void setCniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
    }

    public PodSpecGenerator cpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Nullable
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public void setCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    public PodSpecGenerator cpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    @Nullable
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public PodSpecGenerator dnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
        return this;
    }

    public PodSpecGenerator addDnsOptionItem(String dnsOptionItem) {
        if (this.dnsOption == null) {
            this.dnsOption = new ArrayList<String>();
        }
        this.dnsOption.add(dnsOptionItem);
        return this;
    }

    @Nullable
    public List<String> getDnsOption() {
        return this.dnsOption;
    }

    public void setDnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
    }

    public PodSpecGenerator dnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public PodSpecGenerator addDnsSearchItem(String dnsSearchItem) {
        if (this.dnsSearch == null) {
            this.dnsSearch = new ArrayList<String>();
        }
        this.dnsSearch.add(dnsSearchItem);
        return this;
    }

    @Nullable
    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public PodSpecGenerator dnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    public PodSpecGenerator addDnsServerItem(String dnsServerItem) {
        if (this.dnsServer == null) {
            this.dnsServer = new ArrayList<String>();
        }
        this.dnsServer.add(dnsServerItem);
        return this;
    }

    @Nullable
    public List<String> getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
    }

    public PodSpecGenerator exitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
        return this;
    }

    @Nullable
    public String getExitPolicy() {
        return this.exitPolicy;
    }

    public void setExitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
    }

    public PodSpecGenerator hostadd(List<String> hostadd) {
        this.hostadd = hostadd;
        return this;
    }

    public PodSpecGenerator addHostaddItem(String hostaddItem) {
        if (this.hostadd == null) {
            this.hostadd = new ArrayList<String>();
        }
        this.hostadd.add(hostaddItem);
        return this;
    }

    @Nullable
    public List<String> getHostadd() {
        return this.hostadd;
    }

    public void setHostadd(List<String> hostadd) {
        this.hostadd = hostadd;
    }

    public PodSpecGenerator hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public PodSpecGenerator hostsFile(String hostsFile) {
        this.hostsFile = hostsFile;
        return this;
    }

    @Nullable
    public String getHostsFile() {
        return this.hostsFile;
    }

    public void setHostsFile(String hostsFile) {
        this.hostsFile = hostsFile;
    }

    public PodSpecGenerator idmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
        return this;
    }

    @Nullable
    @Valid
    public IDMappingOptions getIdmappings() {
        return this.idmappings;
    }

    public void setIdmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
    }

    public PodSpecGenerator imageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
        return this;
    }

    public PodSpecGenerator addImageVolumesItem(ImageVolume imageVolumesItem) {
        if (this.imageVolumes == null) {
            this.imageVolumes = new ArrayList<ImageVolume>();
        }
        this.imageVolumes.add(imageVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ImageVolume> getImageVolumes() {
        return this.imageVolumes;
    }

    public void setImageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
    }

    public PodSpecGenerator infraCommand(List<String> infraCommand) {
        this.infraCommand = infraCommand;
        return this;
    }

    public PodSpecGenerator addInfraCommandItem(String infraCommandItem) {
        if (this.infraCommand == null) {
            this.infraCommand = new ArrayList<String>();
        }
        this.infraCommand.add(infraCommandItem);
        return this;
    }

    @Nullable
    public List<String> getInfraCommand() {
        return this.infraCommand;
    }

    public void setInfraCommand(List<String> infraCommand) {
        this.infraCommand = infraCommand;
    }

    public PodSpecGenerator infraConmonPidFile(String infraConmonPidFile) {
        this.infraConmonPidFile = infraConmonPidFile;
        return this;
    }

    @Nullable
    public String getInfraConmonPidFile() {
        return this.infraConmonPidFile;
    }

    public void setInfraConmonPidFile(String infraConmonPidFile) {
        this.infraConmonPidFile = infraConmonPidFile;
    }

    public PodSpecGenerator infraImage(String infraImage) {
        this.infraImage = infraImage;
        return this;
    }

    @Nullable
    public String getInfraImage() {
        return this.infraImage;
    }

    public void setInfraImage(String infraImage) {
        this.infraImage = infraImage;
    }

    public PodSpecGenerator infraName(String infraName) {
        this.infraName = infraName;
        return this;
    }

    @Nullable
    public String getInfraName() {
        return this.infraName;
    }

    public void setInfraName(String infraName) {
        this.infraName = infraName;
    }

    public PodSpecGenerator ipcns(Namespace ipcns) {
        this.ipcns = ipcns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getIpcns() {
        return this.ipcns;
    }

    public void setIpcns(Namespace ipcns) {
        this.ipcns = ipcns;
    }

    public PodSpecGenerator labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public PodSpecGenerator putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public PodSpecGenerator mounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public PodSpecGenerator addMountsItem(Mount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Mount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
    }

    public PodSpecGenerator name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PodSpecGenerator netns(Namespace netns) {
        this.netns = netns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getNetns() {
        return this.netns;
    }

    public void setNetns(Namespace netns) {
        this.netns = netns;
    }

    public PodSpecGenerator networkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
        return this;
    }

    public PodSpecGenerator putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
        if (this.networkOptions == null) {
            this.networkOptions = new HashMap<String, List<String>>();
        }
        this.networkOptions.put(key, networkOptionsItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, List<String>> getNetworkOptions() {
        return this.networkOptions;
    }

    public void setNetworkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
    }

    public PodSpecGenerator noInfra(Boolean noInfra) {
        this.noInfra = noInfra;
        return this;
    }

    @Nullable
    public Boolean getNoInfra() {
        return this.noInfra;
    }

    public void setNoInfra(Boolean noInfra) {
        this.noInfra = noInfra;
    }

    public PodSpecGenerator noManageHostname(Boolean noManageHostname) {
        this.noManageHostname = noManageHostname;
        return this;
    }

    @Nullable
    public Boolean getNoManageHostname() {
        return this.noManageHostname;
    }

    public void setNoManageHostname(Boolean noManageHostname) {
        this.noManageHostname = noManageHostname;
    }

    public PodSpecGenerator noManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
        return this;
    }

    @Nullable
    public Boolean getNoManageHosts() {
        return this.noManageHosts;
    }

    public void setNoManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
    }

    public PodSpecGenerator noManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
        return this;
    }

    @Nullable
    public Boolean getNoManageResolvConf() {
        return this.noManageResolvConf;
    }

    public void setNoManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
    }

    public PodSpecGenerator overlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
        return this;
    }

    public PodSpecGenerator addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
        if (this.overlayVolumes == null) {
            this.overlayVolumes = new ArrayList<OverlayVolume>();
        }
        this.overlayVolumes.add(overlayVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid OverlayVolume> getOverlayVolumes() {
        return this.overlayVolumes;
    }

    public void setOverlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
    }

    public PodSpecGenerator pidns(Namespace pidns) {
        this.pidns = pidns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getPidns() {
        return this.pidns;
    }

    public void setPidns(Namespace pidns) {
        this.pidns = pidns;
    }

    public PodSpecGenerator podCreateCommand(List<String> podCreateCommand) {
        this.podCreateCommand = podCreateCommand;
        return this;
    }

    public PodSpecGenerator addPodCreateCommandItem(String podCreateCommandItem) {
        if (this.podCreateCommand == null) {
            this.podCreateCommand = new ArrayList<String>();
        }
        this.podCreateCommand.add(podCreateCommandItem);
        return this;
    }

    @Nullable
    public List<String> getPodCreateCommand() {
        return this.podCreateCommand;
    }

    public void setPodCreateCommand(List<String> podCreateCommand) {
        this.podCreateCommand = podCreateCommand;
    }

    public PodSpecGenerator podDevices(List<String> podDevices) {
        this.podDevices = podDevices;
        return this;
    }

    public PodSpecGenerator addPodDevicesItem(String podDevicesItem) {
        if (this.podDevices == null) {
            this.podDevices = new ArrayList<String>();
        }
        this.podDevices.add(podDevicesItem);
        return this;
    }

    @Nullable
    public List<String> getPodDevices() {
        return this.podDevices;
    }

    public void setPodDevices(List<String> podDevices) {
        this.podDevices = podDevices;
    }

    public PodSpecGenerator portmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
        return this;
    }

    public PodSpecGenerator addPortmappingsItem(PortMapping portmappingsItem) {
        if (this.portmappings == null) {
            this.portmappings = new ArrayList<PortMapping>();
        }
        this.portmappings.add(portmappingsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid PortMapping> getPortmappings() {
        return this.portmappings;
    }

    public void setPortmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
    }

    public PodSpecGenerator resourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
        return this;
    }

    @Nullable
    @Valid
    public LinuxResources getResourceLimits() {
        return this.resourceLimits;
    }

    public void setResourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public PodSpecGenerator restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public PodSpecGenerator restartTries(Integer restartTries) {
        this.restartTries = restartTries;
        return this;
    }

    @Nullable
    public Integer getRestartTries() {
        return this.restartTries;
    }

    public void setRestartTries(Integer restartTries) {
        this.restartTries = restartTries;
    }

    public PodSpecGenerator securityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
        return this;
    }

    public PodSpecGenerator addSecurityOptItem(String securityOptItem) {
        if (this.securityOpt == null) {
            this.securityOpt = new ArrayList<String>();
        }
        this.securityOpt.add(securityOptItem);
        return this;
    }

    @Nullable
    public List<String> getSecurityOpt() {
        return this.securityOpt;
    }

    public void setSecurityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
    }

    public PodSpecGenerator serviceContainerID(String serviceContainerID) {
        this.serviceContainerID = serviceContainerID;
        return this;
    }

    @Nullable
    public String getServiceContainerID() {
        return this.serviceContainerID;
    }

    public void setServiceContainerID(String serviceContainerID) {
        this.serviceContainerID = serviceContainerID;
    }

    public PodSpecGenerator shareParent(Boolean shareParent) {
        this.shareParent = shareParent;
        return this;
    }

    @Nullable
    public Boolean getShareParent() {
        return this.shareParent;
    }

    public void setShareParent(Boolean shareParent) {
        this.shareParent = shareParent;
    }

    public PodSpecGenerator sharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
        return this;
    }

    public PodSpecGenerator addSharedNamespacesItem(String sharedNamespacesItem) {
        if (this.sharedNamespaces == null) {
            this.sharedNamespaces = new ArrayList<String>();
        }
        this.sharedNamespaces.add(sharedNamespacesItem);
        return this;
    }

    @Nullable
    public List<String> getSharedNamespaces() {
        return this.sharedNamespaces;
    }

    public void setSharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
    }

    public PodSpecGenerator shmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    @Nullable
    public Long getShmSize() {
        return this.shmSize;
    }

    public void setShmSize(Long shmSize) {
        this.shmSize = shmSize;
    }

    public PodSpecGenerator shmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
        return this;
    }

    @Nullable
    public Long getShmSizeSystemd() {
        return this.shmSizeSystemd;
    }

    public void setShmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
    }

    public PodSpecGenerator sysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
        return this;
    }

    public PodSpecGenerator putSysctlItem(String key, String sysctlItem) {
        if (this.sysctl == null) {
            this.sysctl = new HashMap<String, String>();
        }
        this.sysctl.put(key, sysctlItem);
        return this;
    }

    @Nullable
    public Map<String, String> getSysctl() {
        return this.sysctl;
    }

    public void setSysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
    }

    public PodSpecGenerator throttleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
        return this;
    }

    public PodSpecGenerator putThrottleReadBpsDeviceItem(String key, LinuxThrottleDevice throttleReadBpsDeviceItem) {
        if (this.throttleReadBpsDevice == null) {
            this.throttleReadBpsDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleReadBpsDevice.put(key, throttleReadBpsDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, LinuxThrottleDevice> getThrottleReadBpsDevice() {
        return this.throttleReadBpsDevice;
    }

    public void setThrottleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
    }

    public PodSpecGenerator userns(Namespace userns) {
        this.userns = userns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getUserns() {
        return this.userns;
    }

    public void setUserns(Namespace userns) {
        this.userns = userns;
    }

    public PodSpecGenerator utsns(Namespace utsns) {
        this.utsns = utsns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getUtsns() {
        return this.utsns;
    }

    public void setUtsns(Namespace utsns) {
        this.utsns = utsns;
    }

    public PodSpecGenerator volumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public PodSpecGenerator addVolumesItem(NamedVolume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<NamedVolume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid NamedVolume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
    }

    public PodSpecGenerator volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public PodSpecGenerator addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSpecGenerator podSpecGenerator = (PodSpecGenerator)o;
        return Objects.equals(this.networks, podSpecGenerator.networks) && Objects.equals(this.cgroupParent, podSpecGenerator.cgroupParent) && Objects.equals(this.cniNetworks, podSpecGenerator.cniNetworks) && Objects.equals(this.cpuPeriod, podSpecGenerator.cpuPeriod) && Objects.equals(this.cpuQuota, podSpecGenerator.cpuQuota) && Objects.equals(this.dnsOption, podSpecGenerator.dnsOption) && Objects.equals(this.dnsSearch, podSpecGenerator.dnsSearch) && Objects.equals(this.dnsServer, podSpecGenerator.dnsServer) && Objects.equals(this.exitPolicy, podSpecGenerator.exitPolicy) && Objects.equals(this.hostadd, podSpecGenerator.hostadd) && Objects.equals(this.hostname, podSpecGenerator.hostname) && Objects.equals(this.hostsFile, podSpecGenerator.hostsFile) && Objects.equals(this.idmappings, podSpecGenerator.idmappings) && Objects.equals(this.imageVolumes, podSpecGenerator.imageVolumes) && Objects.equals(this.infraCommand, podSpecGenerator.infraCommand) && Objects.equals(this.infraConmonPidFile, podSpecGenerator.infraConmonPidFile) && Objects.equals(this.infraImage, podSpecGenerator.infraImage) && Objects.equals(this.infraName, podSpecGenerator.infraName) && Objects.equals(this.ipcns, podSpecGenerator.ipcns) && Objects.equals(this.labels, podSpecGenerator.labels) && Objects.equals(this.mounts, podSpecGenerator.mounts) && Objects.equals(this.name, podSpecGenerator.name) && Objects.equals(this.netns, podSpecGenerator.netns) && Objects.equals(this.networkOptions, podSpecGenerator.networkOptions) && Objects.equals(this.noInfra, podSpecGenerator.noInfra) && Objects.equals(this.noManageHostname, podSpecGenerator.noManageHostname) && Objects.equals(this.noManageHosts, podSpecGenerator.noManageHosts) && Objects.equals(this.noManageResolvConf, podSpecGenerator.noManageResolvConf) && Objects.equals(this.overlayVolumes, podSpecGenerator.overlayVolumes) && Objects.equals(this.pidns, podSpecGenerator.pidns) && Objects.equals(this.podCreateCommand, podSpecGenerator.podCreateCommand) && Objects.equals(this.podDevices, podSpecGenerator.podDevices) && Objects.equals(this.portmappings, podSpecGenerator.portmappings) && Objects.equals(this.resourceLimits, podSpecGenerator.resourceLimits) && Objects.equals(this.restartPolicy, podSpecGenerator.restartPolicy) && Objects.equals(this.restartTries, podSpecGenerator.restartTries) && Objects.equals(this.securityOpt, podSpecGenerator.securityOpt) && Objects.equals(this.serviceContainerID, podSpecGenerator.serviceContainerID) && Objects.equals(this.shareParent, podSpecGenerator.shareParent) && Objects.equals(this.sharedNamespaces, podSpecGenerator.sharedNamespaces) && Objects.equals(this.shmSize, podSpecGenerator.shmSize) && Objects.equals(this.shmSizeSystemd, podSpecGenerator.shmSizeSystemd) && Objects.equals(this.sysctl, podSpecGenerator.sysctl) && Objects.equals(this.throttleReadBpsDevice, podSpecGenerator.throttleReadBpsDevice) && Objects.equals(this.userns, podSpecGenerator.userns) && Objects.equals(this.utsns, podSpecGenerator.utsns) && Objects.equals(this.volumes, podSpecGenerator.volumes) && Objects.equals(this.volumesFrom, podSpecGenerator.volumesFrom);
    }

    public int hashCode() {
        return Objects.hash(this.networks, this.cgroupParent, this.cniNetworks, this.cpuPeriod, this.cpuQuota, this.dnsOption, this.dnsSearch, this.dnsServer, this.exitPolicy, this.hostadd, this.hostname, this.hostsFile, this.idmappings, this.imageVolumes, this.infraCommand, this.infraConmonPidFile, this.infraImage, this.infraName, this.ipcns, this.labels, this.mounts, this.name, this.netns, this.networkOptions, this.noInfra, this.noManageHostname, this.noManageHosts, this.noManageResolvConf, this.overlayVolumes, this.pidns, this.podCreateCommand, this.podDevices, this.portmappings, this.resourceLimits, this.restartPolicy, this.restartTries, this.securityOpt, this.serviceContainerID, this.shareParent, this.sharedNamespaces, this.shmSize, this.shmSizeSystemd, this.sysctl, this.throttleReadBpsDevice, this.userns, this.utsns, this.volumes, this.volumesFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodSpecGenerator {\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    cgroupParent: ").append(this.toIndentedString(this.cgroupParent)).append("\n");
        sb.append("    cniNetworks: ").append(this.toIndentedString(this.cniNetworks)).append("\n");
        sb.append("    cpuPeriod: ").append(this.toIndentedString(this.cpuPeriod)).append("\n");
        sb.append("    cpuQuota: ").append(this.toIndentedString(this.cpuQuota)).append("\n");
        sb.append("    dnsOption: ").append(this.toIndentedString(this.dnsOption)).append("\n");
        sb.append("    dnsSearch: ").append(this.toIndentedString(this.dnsSearch)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    exitPolicy: ").append(this.toIndentedString(this.exitPolicy)).append("\n");
        sb.append("    hostadd: ").append(this.toIndentedString(this.hostadd)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    hostsFile: ").append(this.toIndentedString(this.hostsFile)).append("\n");
        sb.append("    idmappings: ").append(this.toIndentedString(this.idmappings)).append("\n");
        sb.append("    imageVolumes: ").append(this.toIndentedString(this.imageVolumes)).append("\n");
        sb.append("    infraCommand: ").append(this.toIndentedString(this.infraCommand)).append("\n");
        sb.append("    infraConmonPidFile: ").append(this.toIndentedString(this.infraConmonPidFile)).append("\n");
        sb.append("    infraImage: ").append(this.toIndentedString(this.infraImage)).append("\n");
        sb.append("    infraName: ").append(this.toIndentedString(this.infraName)).append("\n");
        sb.append("    ipcns: ").append(this.toIndentedString(this.ipcns)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    netns: ").append(this.toIndentedString(this.netns)).append("\n");
        sb.append("    networkOptions: ").append(this.toIndentedString(this.networkOptions)).append("\n");
        sb.append("    noInfra: ").append(this.toIndentedString(this.noInfra)).append("\n");
        sb.append("    noManageHostname: ").append(this.toIndentedString(this.noManageHostname)).append("\n");
        sb.append("    noManageHosts: ").append(this.toIndentedString(this.noManageHosts)).append("\n");
        sb.append("    noManageResolvConf: ").append(this.toIndentedString(this.noManageResolvConf)).append("\n");
        sb.append("    overlayVolumes: ").append(this.toIndentedString(this.overlayVolumes)).append("\n");
        sb.append("    pidns: ").append(this.toIndentedString(this.pidns)).append("\n");
        sb.append("    podCreateCommand: ").append(this.toIndentedString(this.podCreateCommand)).append("\n");
        sb.append("    podDevices: ").append(this.toIndentedString(this.podDevices)).append("\n");
        sb.append("    portmappings: ").append(this.toIndentedString(this.portmappings)).append("\n");
        sb.append("    resourceLimits: ").append(this.toIndentedString(this.resourceLimits)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartTries: ").append(this.toIndentedString(this.restartTries)).append("\n");
        sb.append("    securityOpt: ").append(this.toIndentedString(this.securityOpt)).append("\n");
        sb.append("    serviceContainerID: ").append(this.toIndentedString(this.serviceContainerID)).append("\n");
        sb.append("    shareParent: ").append(this.toIndentedString(this.shareParent)).append("\n");
        sb.append("    sharedNamespaces: ").append(this.toIndentedString(this.sharedNamespaces)).append("\n");
        sb.append("    shmSize: ").append(this.toIndentedString(this.shmSize)).append("\n");
        sb.append("    shmSizeSystemd: ").append(this.toIndentedString(this.shmSizeSystemd)).append("\n");
        sb.append("    sysctl: ").append(this.toIndentedString(this.sysctl)).append("\n");
        sb.append("    throttleReadBpsDevice: ").append(this.toIndentedString(this.throttleReadBpsDevice)).append("\n");
        sb.append("    userns: ").append(this.toIndentedString(this.userns)).append("\n");
        sb.append("    utsns: ").append(this.toIndentedString(this.utsns)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArrayportmappings;
        JsonArray jsonArrayoverlayVolumes;
        JsonArray jsonArraymounts;
        int i;
        JsonArray jsonArrayimageVolumes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodSpecGenerator is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodSpecGenerator` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cgroup_parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_OPTION) != null && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_OPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXIT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exit_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTADD) != null && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTS_FILE) != null && !jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostsFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_IDMAPPINGS).isJsonNull()) {
            IDMappingOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDMAPPINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonNull() && (jsonArrayimageVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGE_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayimageVolumes.size(); ++i) {
                ImageVolume.validateJsonElement(jsonArrayimageVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPCNS) != null && !jsonObj.get(SERIALIZED_NAME_IPCNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IPCNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArraymounts.size(); ++i) {
                Mount.validateJsonElement(jsonArraymounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETNS) != null && !jsonObj.get(SERIALIZED_NAME_NETNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonNull() && (jsonArrayoverlayVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_OVERLAY_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayoverlayVolumes.size(); ++i) {
                OverlayVolume.validateJsonElement(jsonArrayoverlayVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PIDNS) != null && !jsonObj.get(SERIALIZED_NAME_PIDNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PIDNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod_create_command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_POD_DEVICES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_DEVICES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod_devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_DEVICES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonNull() && (jsonArrayportmappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTMAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).toString()));
            }
            for (i = 0; i < jsonArrayportmappings.size(); ++i) {
                PortMapping.validateJsonElement(jsonArrayportmappings.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS).isJsonNull()) {
            LinuxResources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_OPT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `security_opt` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_CONTAINER_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_CONTAINER_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVICE_CONTAINER_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_CONTAINER_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES) != null && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `shared_namespaces` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS) != null && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USERNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_UTSNS) != null && !jsonObj.get(SERIALIZED_NAME_UTSNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_UTSNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayvolumes.size(); ++i) {
                NamedVolume.validateJsonElement(jsonArrayvolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
    }

    public static PodSpecGenerator fromJson(String jsonString) throws IOException {
        return (PodSpecGenerator)JSON.getGson().fromJson(jsonString, PodSpecGenerator.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_CGROUP_PARENT);
        openapiFields.add(SERIALIZED_NAME_CNI_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_CPU_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_QUOTA);
        openapiFields.add(SERIALIZED_NAME_DNS_OPTION);
        openapiFields.add(SERIALIZED_NAME_DNS_SEARCH);
        openapiFields.add(SERIALIZED_NAME_DNS_SERVER);
        openapiFields.add(SERIALIZED_NAME_EXIT_POLICY);
        openapiFields.add(SERIALIZED_NAME_HOSTADD);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_HOSTS_FILE);
        openapiFields.add(SERIALIZED_NAME_IDMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_INFRA_COMMAND);
        openapiFields.add(SERIALIZED_NAME_INFRA_CONMON_PID_FILE);
        openapiFields.add(SERIALIZED_NAME_INFRA_IMAGE);
        openapiFields.add(SERIALIZED_NAME_INFRA_NAME);
        openapiFields.add(SERIALIZED_NAME_IPCNS);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NETNS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_NO_INFRA);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_HOSTS);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF);
        openapiFields.add(SERIALIZED_NAME_OVERLAY_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_PIDNS);
        openapiFields.add(SERIALIZED_NAME_POD_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_POD_DEVICES);
        openapiFields.add(SERIALIZED_NAME_PORTMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESTART_TRIES);
        openapiFields.add(SERIALIZED_NAME_SECURITY_OPT);
        openapiFields.add(SERIALIZED_NAME_SERVICE_CONTAINER_I_D);
        openapiFields.add(SERIALIZED_NAME_SHARE_PARENT);
        openapiFields.add(SERIALIZED_NAME_SHARED_NAMESPACES);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_SYSCTL);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE);
        openapiFields.add(SERIALIZED_NAME_USERNS);
        openapiFields.add(SERIALIZED_NAME_UTSNS);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodSpecGenerator.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodSpecGenerator.class));
            return new TypeAdapter<PodSpecGenerator>(this){

                public void write(JsonWriter out, PodSpecGenerator value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodSpecGenerator read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PodSpecGenerator.validateJsonElement(jsonElement);
                    return (PodSpecGenerator)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

