/*
 * Decompiled with CFR 0.152.
 */
package de.cem.tensorflow;

import de.cem.tensorflow.models.BoundingBoxOptions;
import de.cem.tensorflow.models.DetectedObject;
import de.cem.tensorflow.models.GraphInputModel;
import de.cem.tensorflow.utility.ImageUtils;
import de.cem.tensorflow.utility.TensorUtils;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Collectors;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.proto.framework.MetaGraphDef;

public class JavaTF {
    public static List<DetectedObject> javaTFInference(BufferedImage bufferedImage, GraphInputModel graphInputModel, SavedModelBundle savedModelBundle) {
        TensorUtils tensorUtils = new TensorUtils(savedModelBundle, graphInputModel, bufferedImage, Float.valueOf(0.5f));
        return tensorUtils.detectFromBufferedImage();
    }

    public static List<BufferedImage> cutOutDetections(BufferedImage bufferedImage, List<DetectedObject> detectedObjects) {
        return detectedObjects.stream().map(detection -> ImageUtils.cutOutDetection(bufferedImage, detection)).collect(Collectors.toList());
    }

    public static BufferedImage getDetectionImage(BufferedImage bufferedImage, List<DetectedObject> detectedObjects, BoundingBoxOptions boundingBoxOptions) {
        return ImageUtils.boundingBox(bufferedImage, detectedObjects, boundingBoxOptions.classNames(), boundingBoxOptions.classColors(), boundingBoxOptions.hideScore());
    }

    public static void getGraphTensorNames(SavedModelBundle savedModelBundle) {
        MetaGraphDef metaGraphDef = savedModelBundle.metaGraphDef();
        System.out.println(metaGraphDef.getSignatureDefMap());
    }
}

