/*
 * Decompiled with CFR 0.152.
 */
package de.cem.tensorflow.utility;

import de.cem.tensorflow.models.DetectedObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static BufferedImage boundingBox(BufferedImage bufferedImage, List<DetectedObject> detectedObjects, String[] classes, Color[] colors, boolean hideScores) {
        AtomicReference<BufferedImage> image = new AtomicReference<BufferedImage>(bufferedImage);
        detectedObjects.forEach(detectedObject -> image.set(ImageUtils.drawBoundingBox((BufferedImage)image.get(), detectedObject, classes[detectedObject.dClass() - 1], colors[detectedObject.dClass() - 1], hideScores)));
        return image.get();
    }

    public static BufferedImage drawBoundingBox(BufferedImage image, DetectedObject detectedObject, String class_name, Color color, boolean hideScores) {
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke(3.0f));
        String text = class_name + (String)(hideScores ? "" : ": " + detectedObject.dScore() + "%");
        g2d.drawString(text, detectedObject.minX(), detectedObject.minY() - 5);
        g2d.drawRect(detectedObject.minX(), detectedObject.minY(), detectedObject.getWidth(), detectedObject.getHeight());
        g2d.dispose();
        return image;
    }

    public static BufferedImage cutOutDetection(BufferedImage image, DetectedObject detectedObject) {
        BufferedImage cutImage = new BufferedImage(detectedObject.getWidth(), detectedObject.getHeight(), 1);
        Graphics2D g2d = cutImage.createGraphics();
        g2d.drawImage((Image)image, -detectedObject.minX(), -detectedObject.minY(), null);
        g2d.dispose();
        return cutImage;
    }

    public static List<DetectedObject> sortList(List<DetectedObject> detectedObjects) {
        return detectedObjects.stream().sorted(Comparator.comparingInt(DetectedObject::minX)).collect(Collectors.toList());
    }

    public static void saveFile(BufferedImage image, String outputPath, String format) {
        try {
            ImageIO.write((RenderedImage)image, format, new File(outputPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("[ERROR] Could not save image.");
        }
    }
}

