/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.postgres;

import io.queryanalyzer.example.postgres.entity.Order;
import io.queryanalyzer.example.postgres.entity.User;
import io.queryanalyzer.example.postgres.repository.OrderRepository;
import io.queryanalyzer.example.postgres.repository.UserRepository;
import java.math.BigDecimal;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class DataInitializer
implements CommandLineRunner {
    private final UserRepository userRepository;
    private final OrderRepository orderRepository;

    public DataInitializer(UserRepository userRepository, OrderRepository orderRepository) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
    }

    public void run(String ... args) {
        System.out.println("Initializing database with sample data...");
        for (int i = 1; i <= 10; ++i) {
            User user = new User("User " + i, "user" + i + "@example.com");
            this.userRepository.save((Object)user);
            int orderCount = 3 + i % 3;
            for (int j = 1; j <= orderCount; ++j) {
                Order order = new Order("Product " + (i * 10 + j), BigDecimal.valueOf(10.0 + (double)(i * j)), user);
                this.orderRepository.save((Object)order);
            }
        }
        System.out.println("Database initialized with 10 users and their orders");
    }
}

