/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db;

import com.gugusong.sqlmapper.Session;
import com.gugusong.sqlmapper.SessionFactory;
import com.gugusong.sqlmapper.config.GlobalConfig;
import com.gugusong.sqlmapper.db.ConnectionHolper;
import com.gugusong.sqlmapper.db.ISqlHelp;
import com.gugusong.sqlmapper.db.SessionImpl;
import com.gugusong.sqlmapper.db.mysql.MysqlSqlHelp;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.NonNull;

public class SessionFactoryImpl
implements SessionFactory {
    private DataSource dataSource;
    private ISqlHelp sqlHelp;
    private GlobalConfig config;

    public SessionFactoryImpl(@NonNull GlobalConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.dataSource = config.getDataSource();
        this.sqlHelp = new MysqlSqlHelp();
        this.config = config;
    }

    @Override
    public Session openSession() throws SQLException {
        return new SessionImpl(new ConnectionHolper(){
            private Connection targetConn;

            @Override
            public Connection getTargetConnection() {
                try {
                    this.targetConn = SessionFactoryImpl.this.dataSource.getConnection();
                    return this.targetConn;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void releaseConnection() {
                try {
                    this.targetConn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this.sqlHelp, this.config);
    }
}

