/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db;

import com.gugusong.sqlmapper.Example;
import com.gugusong.sqlmapper.Page;
import com.gugusong.sqlmapper.common.beans.BeanWrapper;
import com.gugusong.sqlmapper.db.ConditionFragment;
import com.gugusong.sqlmapper.db.PageHolder;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;

public class ExampleImpl
implements Example {
    private final ConditionFragment sqlFragment;
    private ConditionFragment orderFragment;
    private ConditionFragment currentOrderFragment;
    private ConditionFragment currentFragment;
    private final Example parent;
    private boolean hasPage = false;
    private boolean forUpdate = false;
    private Page page;

    private ExampleImpl() {
        this(new ConditionFragment("where"), null);
    }

    private ExampleImpl(ConditionFragment sqlFragment, Example parent) {
        this.sqlFragment = sqlFragment;
        this.currentFragment = sqlFragment;
        this.parent = parent;
    }

    public static Example newInstance() {
        return new ExampleImpl();
    }

    public static Example newInstanceAnd() {
        return new ExampleImpl(new ConditionFragment("and"), null);
    }

    @Override
    public Example or() {
        this.currentFragment = this.currentFragment.createNextToken("or");
        return this;
    }

    @Override
    public Example and() {
        this.currentFragment = this.currentFragment.createNextToken("and");
        return this;
    }

    @Override
    public Example equals(String property, Object value) {
        return this.equals(property, value, false);
    }

    @Override
    public Example equals(String property, Object value, boolean ignone) {
        if (ignone) {
            this.currentFragment = this.currentFragment.removeCondition();
            return this;
        }
        if (value == null) {
            return this.isNull(property);
        }
        this.currentFragment = this.currentFragment.createNextExp("=", property, value);
        return this;
    }

    @Override
    public Example isNull(String property) {
        this.currentFragment = this.currentFragment.createNextCondition("{" + property + "} is null", new Object[0]);
        return this;
    }

    @Override
    public Example startWith(String property, String value) {
        this.like(property, value == null ? "%" : value + "%");
        return this;
    }

    @Override
    public Example contains(String property, String value) {
        this.like(property, value == null ? "%" : "%" + value + "%");
        return this;
    }

    @Override
    public Example endsWith(String property, String value) {
        this.like(property, value == null ? "%" : "%" + value);
        return this;
    }

    @Override
    public Example in(String property, @NonNull List<Object> value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.currentFragment = this.currentFragment.createNextExp("in", property, value);
        return this;
    }

    @Override
    public Example like(String property, @NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.currentFragment = this.currentFragment.createNextExp("like", property, value);
        return this;
    }

    @Override
    public Example gt(String property, Object value) {
        this.currentFragment = this.currentFragment.createNextExp(">", property, value);
        return this;
    }

    @Override
    public Example gt(String property, Object value, boolean ignone) {
        if (ignone) {
            this.currentFragment = this.currentFragment.removeCondition();
            return this;
        }
        return this.gt(property, value);
    }

    @Override
    public Example gtEquals(String property, Object value) {
        this.currentFragment = this.currentFragment.createNextExp(">=", property, value);
        return this;
    }

    @Override
    public Example gtEquals(String property, Object value, boolean ignone) {
        if (ignone) {
            this.currentFragment = this.currentFragment.removeCondition();
            return this;
        }
        return this.gtEquals(property, value);
    }

    @Override
    public Example lt(String property, Object value) {
        this.currentFragment = this.currentFragment.createNextExp("<", property, value);
        return this;
    }

    @Override
    public Example lt(String property, Object value, boolean ignone) {
        if (ignone) {
            this.currentFragment = this.currentFragment.removeCondition();
            return this;
        }
        return this.lt(property, value);
    }

    @Override
    public Example ltEquals(String property, Object value) {
        this.currentFragment = this.currentFragment.createNextExp("<=", property, value);
        return this;
    }

    @Override
    public Example ltEquals(String property, Object value, boolean ignone) {
        if (ignone) {
            this.currentFragment = this.currentFragment.removeCondition();
            return this;
        }
        return this.ltEquals(property, value);
    }

    @Override
    public Example condition(String expression, Object ... value) {
        this.currentFragment = this.currentFragment.createNextCondition(expression, value);
        return this;
    }

    @Override
    public Example subCondition() {
        ConditionFragment beginFragment = this.currentFragment = this.currentFragment.createNextToken("(");
        this.currentFragment = this.currentFragment.createNextToken(")");
        return new ExampleImpl(beginFragment, this);
    }

    @Override
    public Example upCondition() {
        if (this.parent == null) {
            throw new RuntimeException("\u9876\u7ea7Example\u65e0\u6cd5\u83b7\u53d6\u4e0a\u7ea7!");
        }
        return this.parent;
    }

    @Override
    public Example orderByAsc(String property) {
        this.currentOrderFragment = this.orderFragment == null ? (this.orderFragment = new ConditionFragment(3, "asc", property, null)) : this.currentOrderFragment.createNextOrder("asc", property);
        return this;
    }

    @Override
    public Example orderByDesc(String property) {
        this.currentOrderFragment = this.orderFragment == null ? (this.orderFragment = new ConditionFragment(3, "desc", property, null)) : this.currentOrderFragment.createNextOrder("desc", property);
        return this;
    }

    @Override
    public String toSql(BeanWrapper entityWrapper, boolean hasOrder) {
        StringBuilder sb = new StringBuilder();
        ConditionFragment sqlString = this.sqlFragment;
        if (sqlString.getNextFragment() != null) {
            sb.append(sqlString.toSql(entityWrapper));
            while (sqlString.getNextFragment() != null) {
                sqlString = sqlString.getNextFragment();
                sb.append(sqlString.toSql(entityWrapper));
            }
        }
        if (this.orderFragment == null || !hasOrder) {
            return sb.toString();
        }
        sb.append(" order by ");
        ConditionFragment orderString = this.orderFragment;
        sb.append(orderString.toSql(entityWrapper));
        while (orderString.getNextFragment() != null) {
            orderString = orderString.getNextFragment();
            sb.append(",");
            sb.append(orderString.toSql(entityWrapper));
        }
        return sb.toString();
    }

    @Override
    public String toSql(BeanWrapper entityWrapper) {
        return this.toSql(entityWrapper, true);
    }

    @Override
    public String toOrderSql(BeanWrapper entityWrapper) {
        if (this.orderFragment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" order by ");
        ConditionFragment orderString = this.orderFragment;
        sb.append(orderString.toSql(entityWrapper));
        while (orderString.getNextFragment() != null) {
            orderString = orderString.getNextFragment();
            sb.append(",");
            sb.append(orderString.toSql(entityWrapper));
        }
        return sb.toString();
    }

    @Override
    public List<Object> getValues() {
        LinkedList<Object> values = new LinkedList<Object>();
        ConditionFragment sqlString = this.sqlFragment;
        while (sqlString.getNextFragment() != null) {
            if ((sqlString = sqlString.getNextFragment()).getType() == 1) {
                if ("in".equalsIgnoreCase(sqlString.getExpression())) {
                    values.addAll((List)sqlString.getValue());
                    continue;
                }
                values.add(sqlString.getValue());
                continue;
            }
            if (sqlString.getType() != 2) continue;
            values.addAll((List)sqlString.getValue());
        }
        return values;
    }

    @Override
    public Example page() {
        this.hasPage = true;
        this.page = PageHolder.getPage();
        return this;
    }

    @Override
    public Example page(Page page) {
        this.hasPage = true;
        this.page = page;
        return this;
    }

    @Override
    public boolean isPage() {
        return this.hasPage;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Example forUpdate() {
        this.forUpdate = true;
        return this;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

