/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db;

import com.google.common.base.Joiner;
import com.gugusong.sqlmapper.Example;
import com.gugusong.sqlmapper.Session;
import com.gugusong.sqlmapper.common.beans.BeanColumn;
import com.gugusong.sqlmapper.common.beans.BeanWrapper;
import com.gugusong.sqlmapper.common.collection.ConverMapToList;
import com.gugusong.sqlmapper.common.collection.ConverMapToSet;
import com.gugusong.sqlmapper.common.exception.SqlException;
import com.gugusong.sqlmapper.common.exception.StructureException;
import com.gugusong.sqlmapper.common.util.TextUtil;
import com.gugusong.sqlmapper.common.util.UUIDUtil;
import com.gugusong.sqlmapper.config.GlobalConfig;
import com.gugusong.sqlmapper.db.ConnectionHolper;
import com.gugusong.sqlmapper.db.ExampleImpl;
import com.gugusong.sqlmapper.db.ISqlHelp;
import com.gugusong.sqlmapper.strategy.GenerationType;
import com.gugusong.sqlmapper.strategy.VersionGenerationType;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
implements Session {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private ConnectionHolper connHolper;
    private ISqlHelp sqlHelp;
    private GlobalConfig config;

    public SessionImpl(@NonNull ConnectionHolper connHolper, @NonNull ISqlHelp sqlHelp, @NonNull GlobalConfig config) {
        if (connHolper == null) {
            throw new NullPointerException("connHolper is marked non-null but is null");
        }
        if (sqlHelp == null) {
            throw new NullPointerException("sqlHelp is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.connHolper = connHolper;
        this.sqlHelp = sqlHelp;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T save(T entity) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(entity.getClass(), this.config);
        this.config.getExecuteHandle().insertHandle(entityWrapper, entity);
        String sqlToInsert = this.sqlHelp.getSqlToInsert(entityWrapper, false);
        if (log.isDebugEnabled()) {
            log.debug("Preparing: {}", (Object)sqlToInsert);
            log.debug("parameters: {}", entity);
        }
        if (entityWrapper.getIdColumn() != null) {
            if (entityWrapper.getIdColumn().getIdstrategy() == GenerationType.UUID) {
                entityWrapper.getIdColumn().setVal(entity, UUIDUtil.getUUID());
            } else if (entityWrapper.getIdColumn().getIdstrategy() == GenerationType.SNOWFLAKE) {
                if ("BIGINT".equals(entityWrapper.getIdColumn().getDateType())) {
                    entityWrapper.getIdColumn().setVal(entity, this.config.getSnowFlake().nextId());
                } else {
                    if (!"VARCHAR".equals(entityWrapper.getIdColumn().getDateType())) throw new StructureException("\u5b9e\u4f53\u7c7bid\u5c5e\u6027\u4e0d\u5339\u914d\uff0c\u96ea\u82b1\u968f\u673a\u6570\u53ea\u80fd\u5339\u914dlong/string\u7c7b\u578b\u5b57\u6bb5!");
                    entityWrapper.getIdColumn().setVal(entity, this.config.getSnowFlake().nextId() + "");
                }
            }
        }
        Statement preSta = null;
        try {
            block33: {
                try {
                    preSta = entityWrapper.getIdColumn() != null && entityWrapper.getIdColumn().getIdstrategy() == GenerationType.IDENTITY ? this.connHolper.getTargetConnection().prepareStatement(sqlToInsert, 1) : this.connHolper.getTargetConnection().prepareStatement(sqlToInsert);
                    List<BeanColumn> columns = entityWrapper.getColumns();
                    int i = 1;
                    for (BeanColumn beanColumn : columns) {
                        block32: {
                            block34: {
                                block35: {
                                    if (beanColumn.isIdFlag() && GenerationType.IDENTITY == beanColumn.getIdstrategy()) continue;
                                    if (!beanColumn.isVersion()) break block34;
                                    if (beanColumn.getVersionStrategy() != VersionGenerationType.DEFAULT) break block35;
                                    if ("INT".equals(beanColumn.getDateType())) {
                                        preSta.setObject(i, 0);
                                        break block32;
                                    } else {
                                        if (!"BIGINT".equals(beanColumn.getDateType())) throw new SqlException("\u9ed8\u8ba4\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3aint/long\u7c7b\u578b!");
                                        preSta.setObject(i, 0L);
                                    }
                                    break block32;
                                }
                                if (beanColumn.getVersionStrategy() == VersionGenerationType.SNOWFLAKE) {
                                    if ("VARCHAR".equals(beanColumn.getDateType())) {
                                        preSta.setObject(i, this.config.getSnowFlake().nextId() + "");
                                        break block32;
                                    } else {
                                        if (!"BIGINT".equals(beanColumn.getDateType())) throw new SqlException("\u96ea\u82b1\u968f\u673a\u6570\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring/long\u7c7b\u578b!");
                                        preSta.setObject(i, this.config.getSnowFlake().nextId());
                                    }
                                    break block32;
                                } else {
                                    if (beanColumn.getVersionStrategy() != VersionGenerationType.UUID) throw new SqlException("\u4e50\u89c2\u9501\u7c7b\u578b\u4e0d\u652f\u6301!");
                                    if (!"VARCHAR".equals(beanColumn.getDateType())) throw new SqlException("UUID\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring\u7c7b\u578b!");
                                    preSta.setObject(i, UUIDUtil.getUUID());
                                }
                                break block32;
                            }
                            preSta.setObject(i, beanColumn.getVal(entity));
                        }
                        ++i;
                    }
                    int result = preSta.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug("result: {}", (Object)result);
                    }
                    if (entityWrapper.getIdColumn() == null || entityWrapper.getIdColumn().getIdstrategy() != GenerationType.IDENTITY) break block33;
                    ResultSet resultSet = preSta.getGeneratedKeys();
                    try {
                        if (!resultSet.next()) break block33;
                        if ("INT".equals(entityWrapper.getIdColumn().getDateType())) {
                            entityWrapper.getIdColumn().setVal(entity, resultSet.getInt(1));
                        } else {
                            if (!"BIGINT".equals(entityWrapper.getIdColumn().getDateType())) throw new StructureException("\u6570\u636e\u5e93\u81ea\u589e\u957fid\u7c7b\u578b\u4e0d\u4e3aint/long\uff01");
                            entityWrapper.getIdColumn().setVal(entity, resultSet.getLong(1));
                        }
                    }
                    finally {
                        if (Collections.singletonList(resultSet).get(0) != null) {
                            resultSet.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    this.close();
                }
            }
            T t = entity;
            return t;
        }
        finally {
            if (Collections.singletonList(preSta).get(0) != null) {
                preSta.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> List<T> save(@NonNull List<T> entitys, Class<T> clazz) {
        List<T> list;
        if (entitys == null) {
            throw new NullPointerException("entitys is marked non-null but is null");
        }
        BeanWrapper entityWrapper = BeanWrapper.instrance(clazz, this.config);
        String sqlToInsert = this.sqlHelp.getSqlToInsert(entityWrapper, false);
        if (log.isDebugEnabled()) {
            log.debug("Preparing: {}", (Object)sqlToInsert);
            log.debug("parameters: list");
        }
        PreparedStatement preSta = null;
        try {
            block39: {
                try {
                    preSta = entityWrapper.getIdColumn() != null && entityWrapper.getIdColumn().getIdstrategy() == GenerationType.IDENTITY ? this.connHolper.getTargetConnection().prepareStatement(sqlToInsert, 1) : this.connHolper.getTargetConnection().prepareStatement(sqlToInsert);
                    List<BeanColumn> columns = entityWrapper.getColumns();
                    for (T entity : entitys) {
                        this.config.getExecuteHandle().insertHandle(entityWrapper, entity);
                        if (entityWrapper.getIdColumn() != null) {
                            if (entityWrapper.getIdColumn().getIdstrategy() == GenerationType.UUID) {
                                entityWrapper.getIdColumn().setVal(entity, UUIDUtil.getUUID());
                            } else if (entityWrapper.getIdColumn().getIdstrategy() == GenerationType.SNOWFLAKE) {
                                if ("BIGINT".equals(entityWrapper.getIdColumn().getDateType())) {
                                    entityWrapper.getIdColumn().setVal(entity, this.config.getSnowFlake().nextId());
                                } else {
                                    if (!"VARCHAR".equals(entityWrapper.getIdColumn().getDateType())) throw new StructureException("\u5b9e\u4f53\u7c7bid\u5c5e\u6027\u4e0d\u5339\u914d\uff0c\u96ea\u82b1\u968f\u673a\u6570\u53ea\u80fd\u5339\u914dlong/string\u7c7b\u578b\u5b57\u6bb5!");
                                    entityWrapper.getIdColumn().setVal(entity, this.config.getSnowFlake().nextId() + "");
                                }
                            }
                        }
                        int i = 1;
                        for (BeanColumn beanColumn : columns) {
                            if (beanColumn.isIdFlag() && GenerationType.IDENTITY == beanColumn.getIdstrategy()) continue;
                            if (beanColumn.isVersion()) {
                                if (beanColumn.getVersionStrategy() == VersionGenerationType.DEFAULT) {
                                    if ("INT".equals(beanColumn.getDateType())) {
                                        preSta.setObject(i, 0);
                                    } else {
                                        if (!"BIGINT".equals(beanColumn.getDateType())) throw new SqlException("\u9ed8\u8ba4\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3aint/long\u7c7b\u578b!");
                                        preSta.setObject(i, 0L);
                                    }
                                } else if (beanColumn.getVersionStrategy() == VersionGenerationType.SNOWFLAKE) {
                                    if ("VARCHAR".equals(beanColumn.getDateType())) {
                                        preSta.setObject(i, this.config.getSnowFlake().nextId() + "");
                                    } else {
                                        if (!"BIGINT".equals(beanColumn.getDateType())) throw new SqlException("\u96ea\u82b1\u968f\u673a\u6570\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring/long\u7c7b\u578b!");
                                        preSta.setObject(i, this.config.getSnowFlake().nextId());
                                    }
                                } else {
                                    if (beanColumn.getVersionStrategy() != VersionGenerationType.UUID) throw new SqlException("\u4e50\u89c2\u9501\u7c7b\u578b\u4e0d\u652f\u6301!");
                                    if (!"VARCHAR".equals(beanColumn.getDateType())) throw new SqlException("UUID\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring\u7c7b\u578b!");
                                    preSta.setObject(i, UUIDUtil.getUUID());
                                }
                            } else {
                                preSta.setObject(i, beanColumn.getVal(entity));
                            }
                            ++i;
                        }
                        preSta.addBatch();
                    }
                    int[] resultArray = preSta.executeBatch();
                    int resultRow = 0;
                    if (resultArray != null && resultArray.length > 0) {
                        for (int oneResult : resultArray) {
                            resultRow += oneResult;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("result: {}", (Object)resultRow);
                    }
                    if (entityWrapper.getIdColumn() == null || entityWrapper.getIdColumn().getIdstrategy() != GenerationType.IDENTITY) break block39;
                    ResultSet resultSet = preSta.getGeneratedKeys();
                    try {
                        Iterator<T> entityIt = entitys.iterator();
                        while (resultSet.next()) {
                            T entity = entityIt.next();
                            if ("INT".equals(entityWrapper.getIdColumn().getDateType())) {
                                entityWrapper.getIdColumn().setVal(entity, resultSet.getInt(1));
                                continue;
                            }
                            if (!"BIGINT".equals(entityWrapper.getIdColumn().getDateType())) throw new StructureException("\u6570\u636e\u5e93\u81ea\u589e\u957fid\u7c7b\u578b\u4e0d\u4e3aint/long\uff01");
                            entityWrapper.getIdColumn().setVal(entity, resultSet.getLong(1));
                        }
                    }
                    finally {
                        if (Collections.singletonList(resultSet).get(0) != null) {
                            resultSet.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    this.close();
                }
            }
            list = entitys;
            if (Collections.singletonList(preSta).get(0) == null) return list;
        }
        catch (Throwable throwable) {
            if (Collections.singletonList(preSta).get(0) == null) throw throwable;
            preSta.close();
            throw throwable;
        }
        preSta.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> int update(T entity) {
        entityWrapper = BeanWrapper.instrance(entity.getClass(), this.config);
        example = ExampleImpl.newInstanceAnd();
        sqlToUpdate = this.sqlHelp.getSqlToUpdate(entityWrapper, false);
        this.config.getExecuteHandle().updateHandle(example, entityWrapper, entity);
        sqlToUpdate = sqlToUpdate + example.toSql(entityWrapper, false);
        if (SessionImpl.log.isDebugEnabled()) {
            SessionImpl.log.debug("Preparing: {}", (Object)sqlToUpdate);
            SessionImpl.log.debug("parameters: {}", entity);
        }
        try {
            block19: {
                preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToUpdate);
                try {
                    columns = entityWrapper.getColumns();
                    i = 1;
                    for (BeanColumn beanColumn : columns) {
                        block22: {
                            block24: {
                                block26: {
                                    block25: {
                                        block20: {
                                            block23: {
                                                block21: {
                                                    if (beanColumn.isIdFlag()) continue;
                                                    if (!beanColumn.isVersion()) ** GOTO lbl48
                                                    if (beanColumn.getVal(entity) == null) {
                                                        throw new SqlException("\u4e50\u89c2\u9501PO\u7c7b\u66f4\u65b0\u65f6version\u5b57\u6bb5\u5fc5\u4f20!");
                                                    }
                                                    if (beanColumn.getVersionStrategy() != VersionGenerationType.DEFAULT) break block20;
                                                    if (!"INT".equals(beanColumn.getDateType())) break block21;
                                                    preSta.setObject(i, (Integer)beanColumn.getVal(entity) + 1);
                                                    break block22;
                                                }
                                                if (!"BIGINT".equals(beanColumn.getDateType())) break block23;
                                                preSta.setObject(i, (Long)beanColumn.getVal(entity) + 1L);
                                                break block22;
                                            }
                                            throw new SqlException("\u9ed8\u8ba4\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3aint/long\u7c7b\u578b!");
                                        }
                                        if (beanColumn.getVersionStrategy() != VersionGenerationType.SNOWFLAKE) break block24;
                                        if (!"VARCHAR".equals(beanColumn.getDateType())) break block25;
                                        preSta.setObject(i, this.config.getSnowFlake().nextId() + "");
                                        break block22;
                                    }
                                    if (!"BIGINT".equals(beanColumn.getDateType())) break block26;
                                    preSta.setObject(i, this.config.getSnowFlake().nextId());
                                    break block22;
                                }
                                throw new SqlException("\u96ea\u82b1\u968f\u673a\u6570\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring/long\u7c7b\u578b!");
                            }
                            if (beanColumn.getVersionStrategy() != VersionGenerationType.UUID) ** GOTO lbl47
                            if ("VARCHAR".equals(beanColumn.getDateType())) {
                                preSta.setObject(i, UUIDUtil.getUUID());
                            } else {
                                throw new SqlException("UUID\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring\u7c7b\u578b!");
lbl47:
                                // 1 sources

                                throw new SqlException("\u4e50\u89c2\u9501\u7c7b\u578b\u4e0d\u652f\u6301!");
lbl48:
                                // 1 sources

                                preSta.setObject(i, beanColumn.getVal(entity));
                            }
                        }
                        preSta.setObject(i, beanColumn.getVal(entity));
                        ++i;
                    }
                    preSta.setObject(i, entityWrapper.getIdColumn().getVal(entity));
                    ++i;
                    if (entityWrapper.isVersion()) {
                        preSta.setObject(i, entityWrapper.getVersionColumn().getVal(entity));
                        ++i;
                    }
                    for (Object val : example.getValues()) {
                        preSta.setObject(i, val);
                        ++i;
                    }
                    result = preSta.executeUpdate();
                    if (SessionImpl.log.isDebugEnabled()) {
                        SessionImpl.log.debug("result: {}", (Object)result);
                    }
                    var9_13 = result;
                    if (Collections.singletonList(preSta).get(0) == null) break block19;
                }
                catch (Throwable var10_14) {
                    if (Collections.singletonList(preSta).get(0) != null) {
                        preSta.close();
                    }
                    throw var10_14;
                }
                preSta.close();
            }
            return var9_13;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> int updateSelective(T entity) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(entity.getClass(), this.config);
        Example example = ExampleImpl.newInstanceAnd();
        this.config.getExecuteHandle().updateHandle(example, entityWrapper, entity);
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("update");
        sqlSb.append(" ");
        sqlSb.append(entityWrapper.getTableName());
        sqlSb.append(" ");
        sqlSb.append("set");
        sqlSb.append(" ");
        sqlSb.append(Joiner.on((String)" = ?,").join(entityWrapper.getColumns().stream().filter(c -> {
            try {
                Object value = null;
                if (c.isVersion()) {
                    if (c.getVal(entity) == null) {
                        throw new SqlException("\u4e50\u89c2\u9501PO\u7c7b\u66f4\u65b0\u65f6version\u5b57\u6bb5\u5fc5\u4f20!");
                    }
                    if (c.getVersionStrategy() == VersionGenerationType.DEFAULT) {
                        if ("INT".equals(c.getDateType())) {
                            value = (Integer)c.getVal(entity) + 1;
                        } else {
                            if (!"BIGINT".equals(c.getDateType())) throw new SqlException("\u9ed8\u8ba4\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3aint/long\u7c7b\u578b!");
                            value = (Long)c.getVal(entity) + 1L;
                        }
                    } else if (c.getVersionStrategy() == VersionGenerationType.SNOWFLAKE) {
                        if ("VARCHAR".equals(c.getDateType())) {
                            value = this.config.getSnowFlake().nextId() + "";
                        } else {
                            if (!"BIGINT".equals(c.getDateType())) throw new SqlException("\u96ea\u82b1\u968f\u673a\u6570\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring/long\u7c7b\u578b!");
                            value = this.config.getSnowFlake().nextId();
                        }
                    } else {
                        if (c.getVersionStrategy() != VersionGenerationType.UUID) throw new SqlException("\u4e50\u89c2\u9501\u7c7b\u578b\u4e0d\u652f\u6301!");
                        if (!"VARCHAR".equals(c.getDateType())) throw new SqlException("UUID\u4e50\u89c2\u9501\u5b57\u6bb5\u5fc5\u987b\u4e3astring\u7c7b\u578b!");
                        value = UUIDUtil.getUUID();
                    }
                } else {
                    value = c.getVal(entity);
                }
                if (c.isIdFlag() || value == null) {
                    return false;
                }
                values.add(value);
                return true;
            }
            catch (Exception e) {
                throw new StructureException(e);
            }
        }).map(c -> c.getName()).toArray()));
        sqlSb.append(" = ? ");
        sqlSb.append("where");
        sqlSb.append(" ");
        sqlSb.append(entityWrapper.getIdColumn().getName());
        sqlSb.append(" ");
        sqlSb.append("=");
        sqlSb.append(" ");
        sqlSb.append("?");
        values.add(entityWrapper.getIdColumn().getVal(entity));
        if (entityWrapper.isVersion()) {
            sqlSb.append("and");
            sqlSb.append(" ");
            sqlSb.append(entityWrapper.getVersionColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("=");
            sqlSb.append(" ");
            sqlSb.append("?");
            values.add(entityWrapper.getVersionColumn().getVal(entity));
        }
        sqlSb.append(example.toSql(entityWrapper, false));
        values.addAll(example.getValues());
        String sqlToUpdate = sqlSb.toString();
        try {
            int n;
            block15: {
                if (log.isDebugEnabled()) {
                    log.debug("Preparing: {}", (Object)sqlToUpdate);
                    log.debug("parameters: {}", values);
                }
                PreparedStatement preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToUpdate);
                try {
                    int i = 1;
                    for (Object e : values) {
                        preSta.setObject(i, e);
                        ++i;
                    }
                    int result = preSta.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug("result: {}", (Object)result);
                    }
                    n = result;
                    if (Collections.singletonList(preSta).get(0) == null) break block15;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(preSta).get(0) != null) {
                        preSta.close();
                    }
                    throw throwable;
                }
                preSta.close();
            }
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> int updateByExample(T entity, Example example) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(entity.getClass(), this.config);
        this.config.getExecuteHandle().updateHandle(example, entityWrapper, entity);
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("update");
        sqlSb.append(" ");
        sqlSb.append(entityWrapper.getTableName());
        sqlSb.append(" ");
        sqlSb.append("set");
        sqlSb.append(" ");
        sqlSb.append(Joiner.on((String)" = ?,").join(entityWrapper.getColumns().stream().filter(c -> {
            try {
                Object value = c.getVal(entity);
                if (c.isIdFlag() || value == null) {
                    return false;
                }
                values.add(value);
            }
            catch (Exception e) {
                throw new StructureException(e);
            }
            return true;
        }).map(c -> c.getName()).toArray()));
        sqlSb.append(" = ? ");
        sqlSb.append(example.toSql(entityWrapper, false));
        String sqlToUpdate = sqlSb.toString();
        try {
            int n;
            block14: {
                values.addAll(example.getValues());
                if (log.isDebugEnabled()) {
                    log.debug("Preparing: {}", (Object)sqlToUpdate);
                    log.debug("parameters: {}", values);
                }
                PreparedStatement preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToUpdate);
                try {
                    int i = 1;
                    for (Object e : values) {
                        preSta.setObject(i, e);
                        ++i;
                    }
                    int result = preSta.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug("result: {}", (Object)result);
                    }
                    n = result;
                    if (Collections.singletonList(preSta).get(0) == null) break block14;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(preSta).get(0) != null) {
                        preSta.close();
                    }
                    throw throwable;
                }
                preSta.close();
            }
            return n;
        }
        finally {
            this.close();
        }
    }

    @Override
    public <T> int delete(T entity) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(entity.getClass(), this.config);
        return this.delete(ExampleImpl.newInstance().equals(entityWrapper.getIdColumn().getFieldName(), entityWrapper.getIdColumn().getVal(entity)), entityWrapper);
    }

    @Override
    public <E> int delete(Example example, Class<E> E) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(E, this.config);
        return this.delete(example, entityWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int delete(Example example, BeanWrapper entityWrapper) throws SQLException {
        this.config.getExecuteHandle().deleteHandle(example, entityWrapper);
        String sqlToDelete = this.sqlHelp.getSqlToDelete(entityWrapper, false);
        sqlToDelete = sqlToDelete + example.toSql(entityWrapper);
        List<Object> values = example.getValues();
        if (log.isDebugEnabled()) {
            log.debug("Preparing: {}", (Object)sqlToDelete);
            log.debug("parameters: {}", values);
        }
        try {
            int n;
            block12: {
                PreparedStatement preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToDelete);
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        preSta.setObject(i + 1, values.get(i));
                    }
                    int result = preSta.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug("result: {}", (Object)result);
                    }
                    n = result;
                    if (Collections.singletonList(preSta).get(0) == null) break block12;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(preSta).get(0) != null) {
                        preSta.close();
                    }
                    throw throwable;
                }
                preSta.close();
            }
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <E> List<E> findAll(Example example, Class<E> E) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <E> E findOne(Example example, Class<E> E) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(E, this.config);
        return this.findOne(example, E, entityWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> E findOne(Example example, Class<E> E, BeanWrapper entityWrapper) throws Exception {
        this.config.getExecuteHandle().selectHandle(example, entityWrapper);
        StringBuilder sqlToSelect = new StringBuilder(this.sqlHelp.getSqlToSelect(entityWrapper, false));
        sqlToSelect.append(example.toSql(entityWrapper));
        if (example.isForUpdate()) {
            sqlToSelect.append(" for update ");
        }
        List<Object> values = example.getValues();
        if (log.isDebugEnabled()) {
            log.debug("Preparing: {}", (Object)sqlToSelect);
            log.debug("parameters: {}", values);
        }
        try {
            PreparedStatement preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToSelect.toString(), 1004, 1007);
            try {
                for (int i = 0; i < values.size(); ++i) {
                    preSta.setObject(i + 1, values.get(i));
                }
                ResultSet rs = preSta.executeQuery();
                try {
                    if (log.isDebugEnabled()) {
                        rs.last();
                        log.debug("result: {}", (Object)rs.getRow());
                        rs.beforeFirst();
                    }
                    if (entityWrapper.getBeanType() == "po") {
                        if (!rs.next()) return null;
                        E entity = E.newInstance();
                        Iterator<BeanColumn> iterator = entityWrapper.getColumns().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                iterator = entity;
                                return (E)iterator;
                            }
                            BeanColumn column = iterator.next();
                            column.setVal(entity, rs.getObject(column.getName()));
                        }
                    }
                    if (entityWrapper.getBeanType() != "vo") throw new RuntimeException("\u67e5\u8be2\u5bf9\u8c61\u975ePO/VO\u5bf9\u8c61!");
                    E entity = E.newInstance();
                    E result = null;
                    while (rs.next()) {
                        result = entity;
                        this.setValues(rs, entity, entityWrapper);
                    }
                    E e = result;
                    return e;
                }
                finally {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(preSta).get(0) != null) {
                    preSta.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close();
        }
    }

    private void setValues(ResultSet rs, Object entity, BeanWrapper entityWrapper) throws Exception {
        for (BeanColumn column : entityWrapper.getColumns()) {
            Object keyObj;
            StringBuilder keyAppend;
            String[] groupBy;
            if ("OBJECT".equals(column.getDateType())) {
                Object valObject = column.getVal(entity);
                if (valObject == null) {
                    valObject = column.getField().getType().newInstance();
                    column.setVal(entity, valObject);
                }
                this.setValues(rs, valObject, column.getFieldBeanWrapper());
                continue;
            }
            if ("SET".equals(column.getDateType())) {
                ConverMapToSet setObject = (ConverMapToSet)column.getVal(entity);
                if (setObject == null || !(setObject instanceof ConverMapToSet)) {
                    setObject = new ConverMapToSet();
                    column.setVal(entity, setObject);
                }
                if ((groupBy = column.getGroupBy()) == null || groupBy.length == 0) {
                    Object varObject2 = column.getFieldBeanWrapper().getPoClazz().newInstance();
                    this.setValues(rs, varObject2, column.getFieldBeanWrapper());
                    setObject.add(varObject2);
                    continue;
                }
                boolean hasValue = false;
                keyAppend = new StringBuilder();
                for (String key : groupBy) {
                    keyObj = rs.getObject(key);
                    if (keyObj == null) continue;
                    keyAppend.append(keyObj);
                    hasValue = true;
                }
                if (!hasValue) {
                    return;
                }
                Object obj = column.getFieldBeanWrapper().getPoClazz().newInstance();
                this.setValues(rs, obj, column.getFieldBeanWrapper());
                setObject.add(keyAppend.toString(), obj);
                continue;
            }
            if ("LIST".equals(column.getDateType())) {
                ConverMapToList listObject = (ConverMapToList)column.getVal(entity);
                if (listObject == null || !(listObject instanceof ConverMapToList)) {
                    listObject = new ConverMapToList();
                    column.setVal(entity, listObject);
                }
                if ((groupBy = column.getGroupBy()) == null || groupBy.length == 0) {
                    Object varObject = column.getFieldBeanWrapper().getPoClazz().newInstance();
                    this.setValues(rs, varObject, column.getFieldBeanWrapper());
                    listObject.add(varObject);
                    continue;
                }
                boolean hasValue = false;
                keyAppend = new StringBuilder();
                for (String key : groupBy) {
                    keyObj = rs.getObject(key);
                    if (keyObj == null) continue;
                    keyAppend.append(keyObj);
                    hasValue = true;
                }
                if (!hasValue) {
                    return;
                }
                Object obj = column.getFieldBeanWrapper().getPoClazz().newInstance();
                this.setValues(rs, obj, column.getFieldBeanWrapper());
                listObject.add(keyAppend.toString(), obj);
                continue;
            }
            if (column.getField().getType() == java.util.Date.class || column.getField().getType() == Date.class) {
                column.setVal(entity, rs.getDate(column.getAliasName()));
                continue;
            }
            column.setVal(entity, rs.getObject(column.getAliasName()));
        }
    }

    @Override
    public <E> E findOneById(Class<E> e, Object id) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(e, this.config);
        Example example = ExampleImpl.newInstance();
        if (entityWrapper.getBeanType() == "po") {
            example.equals(entityWrapper.getIdColumn().getFieldName(), id);
        } else if (entityWrapper.getBeanType() == "vo") {
            example.equals(entityWrapper.getTableAliasName() + "." + entityWrapper.getMainWrapper().getIdColumn().getFieldName(), id);
        } else {
            throw new RuntimeException("\u67e5\u8be2\u5bf9\u8c61\u975ePO/VO\u5bf9\u8c61!");
        }
        return this.findOne(example, e, entityWrapper);
    }

    @Override
    public <E> E findOneByIdForUpdate(Class<E> e, Object id) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(e, this.config);
        Example example = ExampleImpl.newInstance();
        example.forUpdate();
        if (entityWrapper.getBeanType() == "po") {
            example.equals(entityWrapper.getIdColumn().getFieldName(), id);
        } else if (entityWrapper.getBeanType() == "vo") {
            example.equals(entityWrapper.getTableAliasName() + "." + entityWrapper.getMainWrapper().getIdColumn().getFieldName(), id);
        } else {
            throw new RuntimeException("\u67e5\u8be2\u5bf9\u8c61\u975ePO/VO\u5bf9\u8c61!");
        }
        return this.findOne(example, e, entityWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <E> int findCount(Example example, Class<E> E) {
        BeanWrapper entityWrapper = BeanWrapper.instrance(E, this.config);
        this.config.getExecuteHandle().selectHandle(example, entityWrapper);
        String sqlToSelect = this.sqlHelp.getSqlToSelectCount(entityWrapper, false);
        sqlToSelect = TextUtil.replaceTemplateParams(sqlToSelect, param -> example.toSql(entityWrapper, false));
        List<Object> values = example.getValues();
        if (log.isDebugEnabled()) {
            log.debug("Preparing: {}", (Object)sqlToSelect);
            log.debug("parameters: {}", values);
        }
        try {
            PreparedStatement preSta = this.connHolper.getTargetConnection().prepareStatement(sqlToSelect, 1004, 1007);
            try {
                for (int i = 0; i < values.size(); ++i) {
                    preSta.setObject(i + 1, values.get(i));
                }
                ResultSet rs = preSta.executeQuery();
                try {
                    if (log.isDebugEnabled()) {
                        rs.last();
                        log.debug("result: {}", (Object)rs.getRow());
                        rs.beforeFirst();
                    }
                    if (!rs.next()) return 0;
                    int n = rs.getInt(1);
                    return n;
                }
                finally {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(preSta).get(0) != null) {
                    preSta.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void commit() {
        this.connHolper.getTargetConnection().commit();
    }

    @Override
    public void close() {
        this.connHolper.releaseConnection();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.connHolper.getTargetConnection().setAutoCommit(autoCommit);
    }

    @Override
    public void rollback() {
        this.connHolper.getTargetConnection().rollback();
    }
}

