/*
 * Decompiled with CFR 0.152.
 */
package io.github.sdu8080.stream;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StreamExample {
    public static void main(String[] args) {
        String[] strArray = new String[]{"foo", "bar", "blah"};
        Arrays.stream(strArray).forEach(s -> System.out.println((String)s));
        List list = Arrays.stream(strArray).filter(v -> !v.equals("bar")).map(String::toUpperCase).collect(Collectors.toList());
        System.out.println(list);
        List list2 = Arrays.stream(strArray).filter(new MyPredicate()).map(new MyFunction()).collect(Collectors.toList());
        System.out.println(list2);
    }

    static class MyPredicate<T>
    implements Predicate<T> {
        MyPredicate() {
        }

        @Override
        public boolean test(T t) {
            System.out.println("inside predicate t=" + String.valueOf(t));
            return !t.equals("bar");
        }
    }

    static class MyFunction
    implements Function<String, String> {
        MyFunction() {
        }

        @Override
        public String apply(String t) {
            System.out.println("inside function: " + t);
            return t.toUpperCase().replace('O', '$');
        }
    }
}

