/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.material;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.Orientable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003J?\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0007\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bJ\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lio/github/solid/resourcepack/api/material/SolidMaterial;", "", "material", "Lorg/bukkit/Material;", "minecraftKey", "Lnet/kyori/adventure/key/Key;", "minecraftParent", "minecraftTextures", "", "", "(Lorg/bukkit/Material;Lnet/kyori/adventure/key/Key;Lnet/kyori/adventure/key/Key;Ljava/util/Map;)V", "getMaterial", "()Lorg/bukkit/Material;", "getMinecraftKey", "()Lnet/kyori/adventure/key/Key;", "getMinecraftParent", "getMinecraftTextures", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "key", "textures", "toString", "Companion", "solid-api"})
public final class SolidMaterial {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Material material;
    @NotNull
    private final Key minecraftKey;
    @Nullable
    private final Key minecraftParent;
    @NotNull
    private final Map<String, Key> minecraftTextures;

    public SolidMaterial(@NotNull Material material, @NotNull Key minecraftKey, @Nullable Key minecraftParent, @NotNull Map<String, ? extends Key> minecraftTextures) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)minecraftKey, (String)"minecraftKey");
        Intrinsics.checkNotNullParameter(minecraftTextures, (String)"minecraftTextures");
        this.material = material;
        this.minecraftKey = minecraftKey;
        this.minecraftParent = minecraftParent;
        this.minecraftTextures = minecraftTextures;
    }

    @NotNull
    public final Material getMaterial() {
        return this.material;
    }

    @NotNull
    public final Key getMinecraftKey() {
        return this.minecraftKey;
    }

    @Nullable
    public final Key getMinecraftParent() {
        return this.minecraftParent;
    }

    @NotNull
    public final Map<String, Key> getMinecraftTextures() {
        return this.minecraftTextures;
    }

    @NotNull
    public final SolidMaterial minecraftParent(@Nullable Key key) {
        return new SolidMaterial(this.material, this.minecraftKey, key, this.minecraftTextures);
    }

    @NotNull
    public final SolidMaterial minecraftTextures(@NotNull Map<String, ? extends Key> textures) {
        Intrinsics.checkNotNullParameter(textures, (String)"textures");
        return new SolidMaterial(this.material, this.minecraftKey, this.minecraftParent, textures);
    }

    @NotNull
    public final Material component1() {
        return this.material;
    }

    @NotNull
    public final Key component2() {
        return this.minecraftKey;
    }

    @Nullable
    public final Key component3() {
        return this.minecraftParent;
    }

    @NotNull
    public final Map<String, Key> component4() {
        return this.minecraftTextures;
    }

    @NotNull
    public final SolidMaterial copy(@NotNull Material material, @NotNull Key minecraftKey, @Nullable Key minecraftParent, @NotNull Map<String, ? extends Key> minecraftTextures) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)minecraftKey, (String)"minecraftKey");
        Intrinsics.checkNotNullParameter(minecraftTextures, (String)"minecraftTextures");
        return new SolidMaterial(material, minecraftKey, minecraftParent, minecraftTextures);
    }

    public static /* synthetic */ SolidMaterial copy$default(SolidMaterial solidMaterial, Material material, Key key, Key key2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            material = solidMaterial.material;
        }
        if ((n & 2) != 0) {
            key = solidMaterial.minecraftKey;
        }
        if ((n & 4) != 0) {
            key2 = solidMaterial.minecraftParent;
        }
        if ((n & 8) != 0) {
            map = solidMaterial.minecraftTextures;
        }
        return solidMaterial.copy(material, key, key2, map);
    }

    @NotNull
    public String toString() {
        return "SolidMaterial(material=" + this.material + ", minecraftKey=" + this.minecraftKey + ", minecraftParent=" + this.minecraftParent + ", minecraftTextures=" + this.minecraftTextures + ")";
    }

    public int hashCode() {
        int result = this.material.hashCode();
        result = result * 31 + this.minecraftKey.hashCode();
        result = result * 31 + (this.minecraftParent == null ? 0 : this.minecraftParent.hashCode());
        result = result * 31 + ((Object)this.minecraftTextures).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SolidMaterial)) {
            return false;
        }
        SolidMaterial solidMaterial = (SolidMaterial)other;
        if (this.material != solidMaterial.material) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minecraftKey, (Object)solidMaterial.minecraftKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minecraftParent, (Object)solidMaterial.minecraftParent)) {
            return false;
        }
        return Intrinsics.areEqual(this.minecraftTextures, solidMaterial.minecraftTextures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tJ\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lio/github/solid/resourcepack/api/material/SolidMaterial$Companion;", "", "()V", "from", "Lio/github/solid/resourcepack/api/material/SolidMaterial;", "minecraftKey", "Lnet/kyori/adventure/key/Key;", "minecraftParent", "textureVariables", "", "", "material", "Lorg/bukkit/Material;", "fromUnsafe", "parseBlockParent", "parseBlockTexture", "parseItemParent", "parseItemTexture", "solid-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SolidMaterial from(@NotNull Key minecraftKey, @Nullable Key minecraftParent, @NotNull Map<String, ? extends Key> textureVariables) {
            Intrinsics.checkNotNullParameter((Object)minecraftKey, (String)"minecraftKey");
            Intrinsics.checkNotNullParameter(textureVariables, (String)"textureVariables");
            String string = minecraftKey.value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            String string2 = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            Material material = Material.matchMaterial((String)string2);
            if (material == null) {
                throw new IllegalArgumentException("Material not found for key: " + minecraftKey);
            }
            Material material2 = material;
            return new SolidMaterial(material2, minecraftKey, minecraftParent, textureVariables);
        }

        @ApiStatus.Experimental
        @Nullable
        public final SolidMaterial from(@NotNull Material material) {
            SolidMaterial solidMaterial;
            Intrinsics.checkNotNullParameter((Object)material, (String)"material");
            try {
                solidMaterial = this.fromUnsafe(material);
            }
            catch (Exception e) {
                solidMaterial = null;
            }
            return solidMaterial;
        }

        private final SolidMaterial fromUnsafe(Material material) {
            String prefix = null;
            Key parent = null;
            Map textures = new LinkedHashMap();
            if (material.isBlock()) {
                prefix = "block";
                parent = this.parseBlockParent(material);
                textures.putAll(this.parseBlockTexture(material));
            } else if (material.isItem()) {
                prefix = "item";
                parent = this.parseItemParent(material);
                textures.putAll(this.parseItemTexture(material));
            }
            if (prefix == null) {
                throw new IllegalArgumentException("Material is not a block or item");
            }
            String string = material.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Key key = Key.key((String)"minecraft", (String)(prefix + "/" + string));
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            return new SolidMaterial(material, key, parent, textures);
        }

        private final Map<String, Key> parseBlockTexture(Material material) {
            String string = material.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Key key = Key.key((String)"minecraft", (String)("block/" + string));
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            Key key2 = key;
            if (material.isSolid()) {
                BlockType blockType = material.asBlockType();
                Intrinsics.checkNotNull((Object)blockType);
                if (!(blockType.createBlockData() instanceof Orientable)) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"all", (Object)key2), TuplesKt.to((Object)"particle", (Object)key2)};
                    return MapsKt.mapOf((Pair[])pairArray);
                }
            }
            throw new IllegalArgumentException("Textures not found for material: " + material + "! This material is not yet supported, please use SolidMaterial#from(Material, Key, Map<String, Key>)");
        }

        private final Key parseBlockParent(Material material) {
            if (material.isSolid()) {
                BlockType blockType = material.asBlockType();
                Intrinsics.checkNotNull((Object)blockType);
                if (!(blockType.createBlockData() instanceof Orientable)) {
                    return Key.key((String)"minecraft", (String)"block/cube_all");
                }
            }
            throw new IllegalArgumentException("Parent not found for material: " + material + "! This material is not yet supported, please use SolidMaterial#from(Material, Key, Map<String, Key>)");
        }

        private final Map<String, Key> parseItemTexture(Material material) {
            String string = material.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Key key = Key.key((String)"minecraft", (String)("item/" + string));
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            Key key2 = key;
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"layer0", (Object)key2));
        }

        private final Key parseItemParent(Material material) {
            if (material.getMaxDurability() > 1) {
                Key key = Key.key((String)"minecraft", (String)"item/handheld");
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
                return key;
            }
            Key key = Key.key((String)"minecraft", (String)"item/generated");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
            return key;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

