/*
 * Decompiled with CFR 0.152.
 */
package io.github.tcq1007.valid.errorcode.util;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import io.github.tcq1007.valid.errorcode.util.EnumFieldFinder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;

public class ErrorCodeExtractor {
    public static Integer extractErrorCodeValue(Element enumConstant, String codeFieldName, Trees trees) {
        Integer value = ErrorCodeExtractor.extractFromSyntaxTree(enumConstant, codeFieldName, trees);
        if (value != null) {
            return value;
        }
        return ErrorCodeExtractor.extractFromSourceString(enumConstant, codeFieldName);
    }

    private static Integer extractFromSyntaxTree(Element enumConstant, String codeFieldName, Trees trees) {
        try {
            LiteralTree literal;
            Object value;
            TreePath path = trees.getPath(enumConstant);
            if (path == null) {
                return null;
            }
            Tree leaf = path.getLeaf();
            if (!(leaf instanceof VariableTree)) {
                return null;
            }
            VariableTree varTree = (VariableTree)leaf;
            ExpressionTree initializer = varTree.getInitializer();
            if (!(initializer instanceof NewClassTree)) {
                return null;
            }
            NewClassTree newClassTree = (NewClassTree)initializer;
            List<? extends ExpressionTree> arguments = newClassTree.getArguments();
            if (arguments.isEmpty()) {
                return null;
            }
            int codeFieldIndex = EnumFieldFinder.findFieldIndexInConstructor(enumConstant, codeFieldName);
            if (codeFieldIndex == -1 || codeFieldIndex >= arguments.size()) {
                return null;
            }
            ExpressionTree argTree = arguments.get(codeFieldIndex);
            if (argTree instanceof LiteralTree && (value = (literal = (LiteralTree)argTree).getValue()) instanceof Number) {
                return ((Number)value).intValue();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer extractFromSourceString(Element enumConstant, String codeFieldName) {
        try {
            String enumConstantStr = enumConstant.toString();
            Integer value = ErrorCodeExtractor.extractUsingRegexPattern(enumConstant, enumConstantStr);
            if (value != null) {
                return value;
            }
            return ErrorCodeExtractor.extractFromConstructorParameterOrder(enumConstant, codeFieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer extractUsingRegexPattern(Element enumConstant, String enumConstantStr) {
        try {
            String patternString = String.format("%s\\s*\\(\\s*(\\d+)", enumConstant.getSimpleName());
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(enumConstantStr);
            if (matcher.find()) {
                String numberStr = matcher.group(1);
                return Integer.parseInt(numberStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Integer extractFromConstructorParameterOrder(Element enumConstant, String codeFieldName) {
        try {
            String argsStr;
            String[] args;
            int codeFieldIndex = EnumFieldFinder.findFieldIndexInConstructor(enumConstant, codeFieldName);
            if (codeFieldIndex == -1) {
                return null;
            }
            String enumStr = enumConstant.toString();
            Pattern pattern = Pattern.compile("\\(([^)]+)\\)");
            Matcher matcher = pattern.matcher(enumStr);
            if (matcher.find() && codeFieldIndex < (args = (argsStr = matcher.group(1)).split(",")).length) {
                String arg = args[codeFieldIndex].trim();
                if (!(arg = arg.replaceAll("[^\\d-]", "")).isEmpty()) {
                    return Integer.parseInt(arg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ErrorCodeExtractor() {
    }
}

