/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.utils.Exceptions;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Map;
import java.util.Optional;

public class SecuritySchemeResolver {
    private final Map<String, SecurityScheme> securityShemes;

    SecuritySchemeResolver(Map<String, SecurityScheme> securityShemes) {
        this.securityShemes = securityShemes;
    }

    public Optional<SecurityScheme> get(String name) {
        return Optional.ofNullable(this.securityShemes.get(name));
    }

    public SecurityScheme getOrThrow(String name) {
        return this.get(name).orElseThrow(Exceptions.illegalStateException("Security scheme %s not found", name));
    }
}

