/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.HeaderResolver;
import io.github.torand.openapi2java.collectors.ParameterResolver;
import io.github.torand.openapi2java.collectors.ResponseResolver;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.SecuritySchemeResolver;
import io.swagger.v3.oas.models.OpenAPI;

public class ComponentResolver {
    private final HeaderResolver headers;
    private final ParameterResolver parameters;
    private final ResponseResolver responses;
    private final SchemaResolver schemas;
    private final SecuritySchemeResolver securitySchemes;

    public ComponentResolver(OpenAPI openApiDoc) {
        this.headers = new HeaderResolver(openApiDoc.getComponents().getHeaders());
        this.parameters = new ParameterResolver(openApiDoc.getComponents().getParameters());
        this.responses = new ResponseResolver(openApiDoc.getComponents().getResponses());
        this.schemas = new SchemaResolver(openApiDoc.getComponents().getSchemas());
        this.securitySchemes = new SecuritySchemeResolver(openApiDoc.getComponents().getSecuritySchemes());
    }

    public HeaderResolver headers() {
        return this.headers;
    }

    public ParameterResolver parameters() {
        return this.parameters;
    }

    public ResponseResolver responses() {
        return this.responses;
    }

    public SchemaResolver schemas() {
        return this.schemas;
    }

    public SecuritySchemeResolver securitySchemes() {
        return this.securitySchemes;
    }
}

