/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.kotlin;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.PojoWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KotlinPojoWriter
extends BaseWriter
implements PojoWriter {
    private static final Set<String> RESERVED_KEYWORDS = Set.of("as", "break", "class", "continue", "do", "else", "false", "for", "fun", "if", "in", "interface", "is", "null", "object", "package", "return", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while");

    public KotlinPojoWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(PojoInfo pojoInfo) {
        this.writeLine("package %s", this.opts.getModelPackage(pojoInfo.modelSubpackage));
        this.writeNewLine();
        Predicate<String> isModelType = qt -> this.isModelPackage((String)qt, pojoInfo.modelSubpackage);
        TreeSet<String> imports = new TreeSet<String>();
        imports.addAll(pojoInfo.imports);
        pojoInfo.properties.stream().flatMap(p -> p.imports.stream()).forEach(imports::add);
        pojoInfo.properties.stream().flatMap(p -> p.type.typeImports()).filter(Predicate.not(isModelType)).forEach(imports::add);
        pojoInfo.properties.stream().flatMap(p -> p.type.annotationImports()).filter(Predicate.not(isModelType)).forEach(imports::add);
        imports.removeIf(i -> i.equals("java.util.List"));
        imports.removeIf(i -> i.equals("java.util.Map"));
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(ti -> this.writeLine("import %s".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        if (pojoInfo.isDeprecated()) {
            this.writeLine("@Deprecated(\"%s\")".formatted(pojoInfo.deprecationMessage), new Object[0]);
        }
        pojoInfo.annotations.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
        this.writeLine("@JvmRecord", new Object[0]);
        this.writeLine("data class %s (".formatted(pojoInfo.name), new Object[0]);
        AtomicInteger propNo = new AtomicInteger(1);
        pojoInfo.properties.forEach(propInfo -> {
            this.writeNewLine();
            this.writePropertyAnnotationLines((PropertyInfo)propInfo);
            this.writeIndent(1);
            this.write("val %s: ", KotlinPojoWriter.escapeReservedKeywords(propInfo.name));
            String typeName = KotlinTypeMapper.toKotlinNative(propInfo.type.name);
            if (Objects.nonNull(propInfo.type.itemType)) {
                String itemTypeWithAnnotations = CollectionHelper.streamConcat(propInfo.type.itemType.annotations, List.of(propInfo.type.itemType.name)).collect(Collectors.joining(" "));
                if (Objects.nonNull(propInfo.type.keyType)) {
                    String keyTypeWithAnnotations = CollectionHelper.streamConcat(propInfo.type.keyType.annotations, List.of(propInfo.type.keyType.name)).collect(Collectors.joining(" "));
                    this.write("%s<%s, %s>".formatted(typeName, keyTypeWithAnnotations, itemTypeWithAnnotations), new Object[0]);
                } else {
                    this.write("%s<%s>".formatted(typeName, itemTypeWithAnnotations), new Object[0]);
                }
            } else {
                this.write("%s".formatted(typeName), new Object[0]);
            }
            if (!propInfo.required || propInfo.type.nullable) {
                this.write("? = null", new Object[0]);
            }
            if (propNo.getAndIncrement() < pojoInfo.properties.size()) {
                this.writeLine(",", new Object[0]);
            } else {
                this.writeNewLine();
            }
        });
        this.writeLine(")", new Object[0]);
    }

    private void writePropertyAnnotationLines(PropertyInfo propInfo) {
        if (propInfo.isDeprecated()) {
            this.writeIndent(1);
            this.writeLine("@Deprecated(\"%s\")".formatted(propInfo.deprecationMessage), new Object[0]);
        }
        CollectionHelper.streamSafely(propInfo.annotations).map(this::prefixPropertyAnnotation).forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
        CollectionHelper.streamSafely(propInfo.type.annotations).map(this::prefixPropertyAnnotation).forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
    }

    private String prefixPropertyAnnotation(String annotation) {
        if (annotation.startsWith("@JsonProperty")) {
            return annotation;
        }
        return "@field:" + annotation.substring(1);
    }

    private boolean isModelPackage(String qualifiedType, String pojoModelSubpackage) {
        int lastDotIdx = qualifiedType.lastIndexOf(".");
        String typePackage = qualifiedType.substring(0, lastDotIdx);
        return this.opts.getModelPackage(pojoModelSubpackage).equals(typePackage);
    }

    private static String escapeReservedKeywords(String name) {
        return RESERVED_KEYWORDS.contains(name) ? "`%s`".formatted(name) : name;
    }
}

