/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static <T> boolean nonEmpty(Collection<T> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static <K, V> boolean nonEmpty(Map<K, V> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static <T> Stream<T> streamSafely(Collection<T> collection) {
        return Objects.isNull(collection) ? Stream.empty() : collection.stream();
    }

    public static <T> Stream<T> streamConcat(Collection<T> collection1, Collection<T> collection2) {
        return Stream.concat(CollectionHelper.streamSafely(collection1), CollectionHelper.streamSafely(collection2));
    }
}

