/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.SecurityRequirementCollector;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.MethodInfo;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MethodInfoCollector
extends BaseCollector {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String TEXT_PLAIN = "text/plain";
    private static final Map<String, String> standardContentTypes = Map.of("application/json", "APPLICATION_JSON", "application/octet-stream", "APPLICATION_OCTET_STREAM", "application/x-www-form-urlencoded", "APPLICATION_FORM_URLENCODED", "multipart/form-data", "MULTIPART_FORM_DATA", "text/plain", "TEXT_PLAIN");
    private final ComponentResolver componentResolver;
    private final TypeInfoCollector typeInfoCollector;
    private final SecurityRequirementCollector securityRequirementCollector;

    public MethodInfoCollector(ComponentResolver componentResolver, TypeInfoCollector typeInfoCollector, Options opts) {
        super(opts);
        this.componentResolver = componentResolver;
        this.typeInfoCollector = typeInfoCollector;
        this.securityRequirementCollector = new SecurityRequirementCollector(opts);
    }

    public MethodInfo getMethodInfo(String verb, String path, Operation operation) {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.name = operation.getOperationId();
        if (Boolean.TRUE.equals(operation.getDeprecated())) {
            methodInfo.deprecationMessage = this.formatDeprecationMessage(operation.getExtensions());
        }
        methodInfo.imports.add("jakarta.ws.rs.%s".formatted(verb));
        methodInfo.annotations.add("@%s".formatted(verb));
        methodInfo.imports.add("jakarta.ws.rs.Path");
        methodInfo.annotations.add("@Path(\"%s\")".formatted(this.normalizePath(path)));
        if (Objects.nonNull(operation.getRequestBody())) {
            String consumesAnnotation = this.getConsumesAnnotation(operation.getRequestBody(), methodInfo.imports, methodInfo.staticImports);
            methodInfo.annotations.add(consumesAnnotation);
        }
        if (Objects.nonNull(operation.getResponses())) {
            String producesAnnotation = this.getProducesAnnotation(operation.getResponses(), methodInfo.imports, methodInfo.staticImports);
            methodInfo.annotations.add(producesAnnotation);
        }
        if (CollectionHelper.nonEmpty(operation.getSecurity())) {
            SecurityRequirementInfo secReqInfo = this.securityRequirementCollector.getSequrityRequirementInfo(operation.getSecurity());
            methodInfo.imports.addAll(secReqInfo.imports);
            methodInfo.annotations.addAll(secReqInfo.annotations);
        }
        if (this.opts.addMpOpenApiAnnotations) {
            methodInfo.annotations.add(this.getOperationAnnotation(operation, methodInfo.imports));
            if (CollectionHelper.nonEmpty(operation.getParameters())) {
                operation.getParameters().forEach(parameter -> {
                    String parameterAnnotation = this.getParameterAnnotation((Parameter)parameter, methodInfo.imports, methodInfo.staticImports);
                    methodInfo.annotations.add(parameterAnnotation);
                });
            }
            if (CollectionHelper.nonEmpty(operation.getResponses())) {
                operation.getResponses().forEach((code, response) -> {
                    String apiResponseAnnotation = this.getApiResponseAnnotation((ApiResponse)response, (String)code, methodInfo.imports, methodInfo.staticImports);
                    if (this.opts.useResteasyResponse && Objects.isNull(methodInfo.returnType)) {
                        methodInfo.returnType = this.getResponseType((String)code, (ApiResponse)response);
                    }
                    methodInfo.annotations.add(apiResponseAnnotation);
                });
            }
        }
        if (CollectionHelper.nonEmpty(operation.getParameters())) {
            operation.getParameters().forEach(param -> {
                TypeInfo paramType;
                Parameter realParam = param;
                if (Objects.nonNull(param.get$ref())) {
                    realParam = this.componentResolver.parameters().getOrThrow(param.get$ref());
                }
                MethodParamInfo paramInfo = new MethodParamInfo();
                paramInfo.nullable = !Boolean.TRUE.equals(realParam.getRequired());
                String methodParamAnnotation = this.getMethodParameterAnnotation(realParam, paramInfo.imports, paramInfo.staticImports);
                paramInfo.annotations.add(methodParamAnnotation);
                Schema realSchema = realParam.getSchema();
                if (Objects.isNull(realSchema)) {
                    throw new IllegalStateException("No schema found for ApiParameter %s".formatted(realParam.getName()));
                }
                paramInfo.type = paramType = this.typeInfoCollector.getTypeInfo(realParam.getSchema(), paramInfo.nullable ? TypeInfoCollector.NullabilityResolution.FORCE_NULLABLE : TypeInfoCollector.NullabilityResolution.FORCE_NOT_NULLABLE);
                paramInfo.name = this.toParamName(realParam.getName());
                paramInfo.comment = paramType.description;
                paramInfo.annotations.addAll(paramType.annotations);
                paramInfo.imports.addAll(paramType.annotationImports);
                if (Boolean.TRUE.equals(realParam.getDeprecated())) {
                    paramInfo.deprecationMessage = this.formatDeprecationMessage(realParam.getExtensions());
                }
                methodInfo.parameters.add(paramInfo);
            });
        }
        if (Objects.nonNull(operation.getRequestBody()) && CollectionHelper.nonEmpty(operation.getRequestBody().getContent())) {
            operation.getRequestBody().getContent().keySet().stream().findFirst().ifPresent(mtKey -> {
                boolean isMultipart = MULTIPART_FORM_DATA.equals(mtKey);
                MediaType mt = (MediaType)operation.getRequestBody().getContent().get(mtKey);
                Schema mtSchema = mt.getSchema();
                if (Objects.nonNull(mtSchema)) {
                    if (isMultipart) {
                        if (!SchemaResolver.isObjectType(mtSchema)) {
                            throw new IllegalStateException("Multipart body should be of type 'object'");
                        }
                        if (mtSchema.getProperties().containsKey("file") && !mtSchema.getProperties().containsKey("filename")) {
                            throw new IllegalStateException("A multipart property 'file' should be accompanied by a 'filename' property containing the filename, since the File object will reference a random temporary internal filename.");
                        }
                        mtSchema.getProperties().forEach((propName, propSchema) -> {
                            MethodParamInfo paramInfo = this.getMultipartPayloadMethodParameter((String)propName, (Schema<?>)propSchema);
                            methodInfo.parameters.add(paramInfo);
                        });
                    } else {
                        MethodParamInfo paramInfo = this.getSingularPayloadMethodParameter(mtSchema);
                        methodInfo.parameters.add(paramInfo);
                    }
                }
            });
        }
        return methodInfo;
    }

    private String getResponseType(String code, ApiResponse response) {
        String responseType = null;
        int numericCode = Integer.parseInt(code);
        if (numericCode >= 200 && numericCode <= 299 && CollectionHelper.nonEmpty(response.getContent())) {
            for (MediaType mediaType : response.getContent().values()) {
                Schema schema = mediaType.getSchema();
                TypeInfo bodyType = this.typeInfoCollector.getTypeInfo(schema);
                if (!Objects.nonNull(bodyType)) continue;
                String fullName = bodyType.getFullName();
                if (Objects.isNull(responseType)) {
                    responseType = fullName;
                    continue;
                }
                if (fullName.equals(responseType)) continue;
                responseType = this.opts.useKotlinSyntax ? "*" : "?";
                break;
            }
        }
        return responseType;
    }

    private MethodParamInfo getSingularPayloadMethodParameter(Schema<?> schema) {
        TypeInfo bodyType;
        MethodParamInfo paramInfo = new MethodParamInfo();
        paramInfo.nullable = false;
        paramInfo.type = bodyType = this.typeInfoCollector.getTypeInfo(schema, TypeInfoCollector.NullabilityResolution.FORCE_NOT_NULLABLE);
        paramInfo.name = this.toParamName(bodyType.name);
        paramInfo.comment = bodyType.description;
        paramInfo.annotations.addAll(bodyType.annotations);
        paramInfo.imports.addAll(bodyType.annotationImports);
        return paramInfo;
    }

    private MethodParamInfo getMultipartPayloadMethodParameter(String name, Schema<?> schema) {
        TypeInfo bodyType;
        MethodParamInfo paramInfo = new MethodParamInfo();
        String partMediaType = null;
        if ("file".equals(name)) {
            bodyType = new TypeInfo();
            bodyType.name = "File";
            bodyType.typeImports.add("java.io.File");
            bodyType.nullable = false;
            bodyType.annotations.add("@NotNull");
            bodyType.annotationImports.add("jakarta.validation.constraints.NotNull");
            bodyType.description = schema.getDescription();
            partMediaType = APPLICATION_OCTET_STREAM;
        } else {
            bodyType = this.typeInfoCollector.getTypeInfo(schema);
            if (SchemaResolver.isObjectType(schema)) {
                throw new IllegalStateException("Multipart property of type 'object' not supported. Use $ref instead.");
            }
            partMediaType = APPLICATION_JSON;
            if (bodyType.isPrimitive() || bodyType.isArray() && bodyType.itemType.isPrimitive()) {
                partMediaType = TEXT_PLAIN;
            }
        }
        if (StringHelper.nonBlank(schema.getContentMediaType())) {
            partMediaType = schema.getContentMediaType();
        }
        partMediaType = this.toMediaTypeConstant(partMediaType, paramInfo.staticImports);
        paramInfo.nullable = bodyType.nullable;
        paramInfo.type = bodyType;
        paramInfo.name = name;
        paramInfo.comment = bodyType.description;
        paramInfo.annotations.add("@RestForm(\"%s\")".formatted(name));
        paramInfo.imports.add("org.jboss.resteasy.reactive.RestForm");
        paramInfo.annotations.add("@PartType(%s)".formatted(partMediaType));
        paramInfo.imports.add("org.jboss.resteasy.reactive.PartType");
        paramInfo.annotations.addAll(bodyType.annotations);
        paramInfo.imports.addAll(bodyType.annotationImports);
        return paramInfo;
    }

    private String getConsumesAnnotation(RequestBody requestBody, Set<String> imports, Set<String> staticImports) {
        imports.add("jakarta.ws.rs.Consumes");
        ArrayList<String> mediaTypes = new ArrayList<String>();
        if (CollectionHelper.nonEmpty(requestBody.getContent())) {
            requestBody.getContent().keySet().stream().forEach(mt -> mediaTypes.add(this.toMediaTypeConstant((String)mt, staticImports)));
        }
        String mediaTypesString = this.formatAnnotationDefaultParam(mediaTypes);
        return "@Consumes(%s)".formatted(mediaTypesString);
    }

    private String getProducesAnnotation(ApiResponses responses, Set<String> imports, Set<String> staticImports) {
        imports.add("jakarta.ws.rs.Produces");
        staticImports.add("jakarta.ws.rs.core.MediaType.APPLICATION_JSON");
        ArrayList<String> mediaTypes = new ArrayList<String>();
        mediaTypes.add("APPLICATION_JSON");
        this.getSuccessResponse(responses).ifPresent(apiResponse -> {
            if (Objects.nonNull(apiResponse.getContent())) {
                apiResponse.getContent().keySet().stream().filter(mt -> !APPLICATION_JSON.equals(mt)).forEach(mt -> mediaTypes.add(this.toMediaTypeConstant((String)mt, staticImports)));
            }
        });
        String mediaTypesString = this.formatAnnotationDefaultParam(mediaTypes);
        return "@Produces(%s)".formatted(mediaTypesString);
    }

    private String getOperationAnnotation(Operation operation, Set<String> imports) {
        imports.add("org.eclipse.microprofile.openapi.annotations.Operation");
        ArrayList<String> operationParams = new ArrayList<String>();
        operationParams.add("operationId = \"%s\"".formatted(operation.getOperationId()));
        operationParams.add("summary = \"%s\"".formatted(operation.getSummary()));
        if (Boolean.TRUE.equals(operation.getDeprecated())) {
            operationParams.add("deprecated = true");
        }
        return "@Operation(%s)".formatted(StringHelper.joinCsv(operationParams));
    }

    private String getParameterAnnotation(Parameter parameter, Set<String> imports, Set<String> staticImports) {
        Parameter realParameter = parameter;
        if (Objects.nonNull(parameter.get$ref())) {
            realParameter = this.componentResolver.parameters().getOrThrow(parameter.get$ref());
        }
        ArrayList<String> parameterParams = new ArrayList<String>();
        imports.add("org.eclipse.microprofile.openapi.annotations.parameters.Parameter");
        String inValue = this.getParameterInValue(realParameter, staticImports);
        String inName = this.opts.useKotlinSyntax ? "`in`" : "in";
        parameterParams.add("%s = %s".formatted(inName, inValue));
        if (inValue.equalsIgnoreCase("header")) {
            parameterParams.add("name = %s".formatted(this.getHeaderNameConstant(realParameter.getName(), staticImports)));
        } else {
            parameterParams.add("name = \"%s\"".formatted(realParameter.getName()));
        }
        parameterParams.add("description = \"%s\"".formatted(this.normalizeDescription(realParameter.getDescription())));
        if (Boolean.TRUE.equals(realParameter.getRequired())) {
            parameterParams.add("required = true");
        }
        if (Objects.nonNull(realParameter.getSchema())) {
            String schemaAnnotation = this.getSchemaAnnotation(realParameter.getSchema(), imports, staticImports);
            parameterParams.add("schema = %s".formatted(schemaAnnotation));
        }
        if (CollectionHelper.nonEmpty(realParameter.getContent())) {
            ArrayList<String> contentItems = new ArrayList<String>();
            realParameter.getContent().forEach((contentType, mediaType) -> {
                String contentAnnotation = this.getContentAnnotation((String)contentType, (MediaType)mediaType, imports, staticImports);
                contentItems.add(contentAnnotation);
            });
            parameterParams.add("content = %s".formatted(this.formatAnnotationNamedParam(contentItems)));
        }
        if (Boolean.TRUE.equals(realParameter.getDeprecated())) {
            parameterParams.add("deprecated = true");
        }
        return "@Parameter(%s)".formatted(StringHelper.joinCsv(parameterParams));
    }

    private String getParameterInValue(Parameter parameter, Set<String> staticImports) {
        String inValue = switch (parameter.getIn().toLowerCase()) {
            case "" -> "DEFAULT";
            case "header" -> "HEADER";
            case "query" -> "QUERY";
            case "path" -> "PATH";
            case "cookie" -> "COOKIE";
            default -> throw new IllegalStateException("Parameter in-value %s not supported".formatted(parameter.getIn()));
        };
        staticImports.add("org.eclipse.microprofile.openapi.annotations.enums.ParameterIn." + inValue);
        return inValue;
    }

    private String getApiResponseAnnotation(ApiResponse response, String statusCode, Set<String> imports, Set<String> staticImports) {
        ApiResponse realResponse = response;
        if (Objects.nonNull(response.get$ref())) {
            realResponse = this.componentResolver.responses().getOrThrow(response.get$ref());
        }
        ArrayList<String> apiResponseParams = new ArrayList<String>();
        imports.add("org.eclipse.microprofile.openapi.annotations.responses.APIResponse");
        apiResponseParams.add("responseCode = \"%s\"".formatted(statusCode));
        apiResponseParams.add("description = \"%s\"".formatted(this.normalizeDescription(realResponse.getDescription())));
        if (CollectionHelper.nonEmpty(realResponse.getHeaders())) {
            ArrayList<String> headerItems = new ArrayList<String>();
            realResponse.getHeaders().forEach((name, header) -> {
                String headerAnnotation = this.getHeaderAnnotation((String)name, (Header)header, imports, staticImports);
                headerItems.add(headerAnnotation);
            });
            apiResponseParams.add("headers = %s".formatted(this.formatAnnotationNamedParam(headerItems)));
        }
        if (CollectionHelper.nonEmpty(realResponse.getContent())) {
            ArrayList<String> contentItems = new ArrayList<String>();
            realResponse.getContent().forEach((contentType, mediaType) -> {
                String contentAnnotation = this.getContentAnnotation((String)contentType, (MediaType)mediaType, imports, staticImports);
                contentItems.add(contentAnnotation);
            });
            apiResponseParams.add("content = %s".formatted(this.formatAnnotationNamedParam(contentItems)));
        }
        return "@APIResponse(%s)".formatted(StringHelper.joinCsv(apiResponseParams));
    }

    private String getMethodParameterAnnotation(Parameter parameter, Set<String> imports, Set<String> staticImports) {
        String paramAnnotationName = switch (parameter.getIn().toLowerCase()) {
            case "header" -> "HeaderParam";
            case "query" -> "QueryParam";
            case "path" -> "PathParam";
            case "cookie" -> "CookieParam";
            default -> throw new IllegalStateException("Parameter in-value %s not supported".formatted(parameter.getIn()));
        };
        imports.add("jakarta.ws.rs." + paramAnnotationName);
        if (paramAnnotationName.equals("HeaderParam")) {
            return "@%s(%s)".formatted(paramAnnotationName, this.getHeaderNameConstant(parameter.getName(), staticImports));
        }
        return "@%s(\"%s\")".formatted(paramAnnotationName, parameter.getName());
    }

    private String getHeaderNameConstant(String name, Set<String> staticImports) {
        String standardHeaderConstant;
        switch (name.toUpperCase()) {
            case "ACCEPT-LANGUAGE": {
                String string = "ACCEPT_LANGUAGE";
                break;
            }
            case "CONTENT-LANGUAGE": {
                String string = "CONTENT_LANGUAGE";
                break;
            }
            case "LOCATION": {
                String string = "LOCATION";
                break;
            }
            default: {
                String string = standardHeaderConstant = null;
            }
        }
        if (Objects.nonNull(standardHeaderConstant)) {
            staticImports.add("jakarta.ws.rs.core.HttpHeaders." + standardHeaderConstant);
            return standardHeaderConstant;
        }
        return StringHelper.quote(name);
    }

    private String getContentAnnotation(String contentType, MediaType mediaType, Set<String> imports, Set<String> staticImports) {
        imports.add("org.eclipse.microprofile.openapi.annotations.media.Content");
        contentType = this.toMediaTypeConstant(contentType, staticImports);
        String schemaAnnotation = this.getSchemaAnnotation(mediaType.getSchema(), imports, staticImports);
        return this.formatInnerAnnotation("Content(mediaType = %s, schema = %s)", contentType, schemaAnnotation);
    }

    private String getSchemaAnnotation(Schema<?> schema, Set<String> imports, Set<String> staticImports) {
        imports.add("org.eclipse.microprofile.openapi.annotations.media.Schema");
        ArrayList<String> schemaParams = new ArrayList<String>();
        TypeInfo bodyType = this.typeInfoCollector.getTypeInfo(schema);
        imports.addAll(bodyType.typeImports);
        if (Objects.nonNull(bodyType.itemType)) {
            staticImports.add("org.eclipse.microprofile.openapi.annotations.enums.SchemaType.ARRAY");
            imports.addAll(bodyType.itemType.typeImports);
            schemaParams.add("type = ARRAY");
            bodyType = bodyType.itemType;
        }
        schemaParams.add("implementation = %s".formatted(this.formatClassRef(bodyType.name)));
        if (Objects.nonNull(schema.getDefault())) {
            schemaParams.add("defaultValue = \"%s\"".formatted(schema.getDefault().toString()));
        }
        if (StringHelper.nonBlank(bodyType.schemaFormat)) {
            schemaParams.add("format = \"%s\"".formatted(bodyType.schemaFormat));
        }
        if (StringHelper.nonBlank(bodyType.schemaPattern)) {
            schemaParams.add("pattern = \"%s\"".formatted(bodyType.schemaPattern));
        }
        return this.formatInnerAnnotation("Schema(%s)", StringHelper.joinCsv(schemaParams));
    }

    private String getHeaderAnnotation(String name, Header header, Set<String> imports, Set<String> staticImports) {
        Header realHeader = header;
        if (Objects.nonNull(header.get$ref())) {
            realHeader = this.componentResolver.headers().getOrThrow(header.get$ref());
        }
        imports.add("org.eclipse.microprofile.openapi.annotations.headers.Header");
        String schemaAnnotation = this.getSchemaAnnotation(realHeader.getSchema(), imports, staticImports);
        return this.formatInnerAnnotation("Header(name = \"%s\", description = \"%s\", schema = %s)", name, this.normalizeDescription(realHeader.getDescription()), schemaAnnotation);
    }

    private String toParamName(String paramName) {
        Objects.requireNonNull(paramName);
        if (StringHelper.nonBlank(this.opts.pojoNameSuffix) && paramName.endsWith(this.opts.pojoNameSuffix)) {
            paramName = StringHelper.stripTail(paramName, this.opts.pojoNameSuffix.length());
        }
        paramName = paramName.replaceAll("-", "");
        paramName = paramName.replaceAll("\\[]", "s");
        return StringHelper.uncapitalize(paramName);
    }

    private Optional<ApiResponse> getSuccessResponse(ApiResponses responses) {
        Objects.requireNonNull(responses);
        return responses.keySet().stream().filter(sc -> sc.startsWith("2")).findFirst().map(arg_0 -> responses.get(arg_0));
    }

    private String toMediaTypeConstant(String contentType, Set<String> staticImports) {
        if (standardContentTypes.containsKey(contentType)) {
            contentType = standardContentTypes.get(contentType);
            staticImports.add("jakarta.ws.rs.core.MediaType." + contentType);
        } else {
            contentType = StringHelper.quote(contentType);
        }
        return contentType;
    }
}

