/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.generators;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.ResourceInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.github.torand.openapi2java.writers.ResourceWriter;
import io.github.torand.openapi2java.writers.WriterFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGenerator.class);
    private final Options opts;

    public ResourceGenerator(Options opts) {
        this.opts = opts;
    }

    public void generate(OpenAPI openApiDoc) {
        int clientCount = 0;
        if (StringHelper.nonBlank((String)this.opts.resourceNameOverride)) {
            clientCount = this.generateWithNameOverride(openApiDoc);
        } else {
            if (CollectionHelper.isEmpty((Collection)openApiDoc.getTags())) {
                logger.error("The OpenAPI specification does not contain tags. Please configure a resource name override to generate a resource interface.");
                return;
            }
            clientCount = this.generateFromTags(openApiDoc);
        }
        logger.info("Generated {} REST client{} in directory {}", new Object[]{clientCount, StringUtils.pluralSuffix(clientCount), this.opts.outputDir});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int generateWithNameOverride(OpenAPI openApiDoc) {
        ComponentResolver componentResolver = new ComponentResolver(openApiDoc);
        ResourceInfoCollector resourceInfoCollector = new ResourceInfoCollector(componentResolver, this.opts);
        String resourceName = this.opts.resourceNameOverride;
        if (this.opts.verbose) {
            logger.info("Generating REST client: {}{}", (Object)resourceName, (Object)this.opts.resourceNameSuffix);
        }
        ResourceInfo resourceInfo = resourceInfoCollector.getResourceInfo(resourceName, (Map<String, PathItem>)openApiDoc.getPaths(), openApiDoc.getSecurity(), null);
        String resourceFilename = resourceInfo.name + this.opts.getFileExtension();
        try (ResourceWriter resourceWriter = WriterFactory.createResourceWriter(resourceFilename, this.opts);){
            if (resourceInfo.isEmpty()) {
                logger.warn("No paths found in OpenAPI specification");
                int n2 = 0;
                return n2;
            }
            resourceWriter.write(resourceInfo);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            logger.error("Failed to write file {}", (Object)resourceFilename, (Object)e);
            return 0;
        }
    }

    private int generateFromTags(OpenAPI openApiDoc) {
        ComponentResolver componentResolver = new ComponentResolver(openApiDoc);
        ResourceInfoCollector resourceInfoCollector = new ResourceInfoCollector(componentResolver, this.opts);
        AtomicInteger clientCount = new AtomicInteger(0);
        openApiDoc.getTags().forEach(tag -> {
            if (CollectionHelper.isEmpty(this.opts.includeTags) || this.opts.includeTags.contains(tag.getName())) {
                String resourceName = this.getResourceName((Tag)tag);
                if (this.opts.verbose) {
                    logger.info("Generating REST client for tag \"{}\": {}{}", new Object[]{tag.getName(), resourceName, this.opts.resourceNameSuffix});
                }
                ResourceInfo resourceInfo = resourceInfoCollector.getResourceInfo(resourceName, (Map<String, PathItem>)openApiDoc.getPaths(), openApiDoc.getSecurity(), (Tag)tag);
                String resourceFilename = resourceInfo.name + this.opts.getFileExtension();
                try (ResourceWriter resourceWriter = WriterFactory.createResourceWriter(resourceFilename, this.opts);){
                    if (resourceInfo.isEmpty()) {
                        logger.warn("No paths found for tag \"{}\"", (Object)tag.getName());
                    } else {
                        resourceWriter.write(resourceInfo);
                        clientCount.incrementAndGet();
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to write file {}", (Object)resourceFilename, (Object)e);
                }
            }
        });
        return clientCount.get();
    }

    private String getResourceName(Tag tag) {
        String tagName = tag.getName().trim();
        String[] tagSubNames = tagName.split(" ");
        return Stream.of(tagSubNames).map(StringHelper::capitalize).collect(Collectors.joining());
    }
}

