/*
 * Decompiled with CFR 0.152.
 */
package A501JavaSDKPackage.WebClients;

import A501JavaSDKPackage.Models.A501.A501ResponseDto;
import A501JavaSDKPackage.Models.A501ClientModel.A501ClientRequestModel;
import A501JavaSDKPackage.Models.A501ClientModel.A501ClientResponseModel;
import A501JavaSDKPackage.Models.Encryption.EncryptedRequestModel;
import A501JavaSDKPackage.Models.Encryption.EncryptedResponseModel;
import A501JavaSDKPackage.WebClients.BaseAPIWebClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;

public class A501WebClient
extends BaseAPIWebClient {
    public A501ClientResponseModel execute(A501ClientRequestModel a501ClientRequestModel) throws Exception {
        String signedJsonApiRequest = this.getSignedJsonApiRequest(a501ClientRequestModel);
        String jsonResponse = A501WebClient.WebClientPost(signedJsonApiRequest, a501ClientRequestModel);
        return this.verifyAndReturnResponse(a501ClientRequestModel, jsonResponse);
    }

    private A501ClientResponseModel verifyAndReturnResponse(A501ClientRequestModel a501ClientRequestModel, String jsonResponse) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        EncryptedResponseModel encryptedResponseModel = (EncryptedResponseModel)objectMapper.readValue(jsonResponse, (TypeReference)new TypeReference<EncryptedResponseModel>(){});
        if (A501WebClient.IsNullOrEmpty(encryptedResponseModel.signature) || A501WebClient.IsNullOrEmpty(encryptedResponseModel.encryptionKey) || A501WebClient.IsNullOrEmpty(encryptedResponseModel.encryptedData)) {
            throw new Exception("Unexpected Error in API.");
        }
        A501WebClient.verifySignature(encryptedResponseModel, a501ClientRequestModel.getPublicKey());
        Key sessionKey = A501WebClient.decryptDataAsymmetrically(encryptedResponseModel.encryptionKey, a501ClientRequestModel.getPrivateKeyPassword(), a501ClientRequestModel.getPrivateKey());
        String responseA501InternalJson = A501WebClient.decryptDataSymmetrically(sessionKey, encryptedResponseModel.encryptedData);
        A501ResponseDto a501ResponseDto = (A501ResponseDto)objectMapper.readValue(responseA501InternalJson, (TypeReference)new TypeReference<A501ResponseDto>(){});
        A501ClientResponseModel a501ClientResponseModel = new A501ClientResponseModel();
        a501ClientResponseModel.ValidationCode = encryptedResponseModel.validationCode;
        a501ClientResponseModel.ValidationDescription = encryptedResponseModel.validationDescription;
        a501ClientResponseModel.RequestId = encryptedResponseModel.requestId;
        a501ClientResponseModel.A501ResponseDto = a501ResponseDto;
        return a501ClientResponseModel;
    }

    private String getSignedJsonApiRequest(A501ClientRequestModel a501ClientRequestModel) throws Exception {
        EncryptedRequestModel encryptedRequestModel = new EncryptedRequestModel();
        if (a501ClientRequestModel == null) {
            throw new Exception("A501ClientRequestModel object cannot be empty.");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String reqJson = objectMapper.writeValueAsString((Object)a501ClientRequestModel.getRequestModel());
        this.encryptRequestDataAndSessionKey(reqJson, a501ClientRequestModel.getPublicKey(), encryptedRequestModel);
        PrivateKey pvtKey = A501WebClient.getPrivateKey(a501ClientRequestModel.getPrivateKey(), a501ClientRequestModel.getPrivateKeyPassword());
        encryptedRequestModel.signature = A501WebClient.signData(pvtKey, encryptedRequestModel.encryptedData + encryptedRequestModel.encryptionKey);
        encryptedRequestModel.requestId = a501ClientRequestModel.getRequestId();
        return objectMapper.writeValueAsString((Object)encryptedRequestModel);
    }

    private void encryptRequestDataAndSessionKey(String reqJson, byte[] publicKey, EncryptedRequestModel encryptedRequestModel) throws GeneralSecurityException, IOException {
        Key sessionKey = A501WebClient.generateSessionKey();
        String encryptedReqData = A501WebClient.encryptUsingSessionKey(sessionKey, reqJson);
        String encryptedSessionKey = A501WebClient.encryptUsingPublicKey(sessionKey, publicKey);
        encryptedRequestModel.encryptedData = encryptedReqData;
        encryptedRequestModel.encryptionKey = encryptedSessionKey;
    }
}

