/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.aws.lambda.events.system;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LambdaDestinationEvent
implements Serializable {
    private String version;
    private String timestamp;
    private RequestContext requestContext;
    private Map<String, Object> requestPayload;
    private Map<String, Object> responseContext;
    private Map<String, Object> responsePayload;

    @NotNull
    public Map<String, Object> getRequestPayload() {
        return this.requestPayload == null ? Collections.emptyMap() : this.requestPayload;
    }

    public LocalDateTime getTimestampAsDateTime() {
        return LocalDateTime.parse(this.timestamp);
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public Map<String, Object> getResponsePayload() {
        return this.responsePayload;
    }

    public LambdaDestinationEvent setVersion(String version) {
        this.version = version;
        return this;
    }

    public LambdaDestinationEvent setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public LambdaDestinationEvent setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public LambdaDestinationEvent setRequestPayload(Map<String, Object> requestPayload) {
        this.requestPayload = requestPayload;
        return this;
    }

    public LambdaDestinationEvent setResponseContext(Map<String, Object> responseContext) {
        this.responseContext = responseContext;
        return this;
    }

    public LambdaDestinationEvent setResponsePayload(Map<String, Object> responsePayload) {
        this.responsePayload = responsePayload;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaDestinationEvent)) {
            return false;
        }
        LambdaDestinationEvent other = (LambdaDestinationEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        if (this$requestContext == null ? other$requestContext != null : !((Object)this$requestContext).equals(other$requestContext)) {
            return false;
        }
        Map<String, Object> this$requestPayload = this.getRequestPayload();
        Map<String, Object> other$requestPayload = other.getRequestPayload();
        if (this$requestPayload == null ? other$requestPayload != null : !((Object)this$requestPayload).equals(other$requestPayload)) {
            return false;
        }
        Map<String, Object> this$responseContext = this.getResponseContext();
        Map<String, Object> other$responseContext = other.getResponseContext();
        if (this$responseContext == null ? other$responseContext != null : !((Object)this$responseContext).equals(other$responseContext)) {
            return false;
        }
        Map<String, Object> this$responsePayload = this.getResponsePayload();
        Map<String, Object> other$responsePayload = other.getResponsePayload();
        return !(this$responsePayload == null ? other$responsePayload != null : !((Object)this$responsePayload).equals(other$responsePayload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LambdaDestinationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : ((Object)$requestContext).hashCode());
        Map<String, Object> $requestPayload = this.getRequestPayload();
        result = result * 59 + ($requestPayload == null ? 43 : ((Object)$requestPayload).hashCode());
        Map<String, Object> $responseContext = this.getResponseContext();
        result = result * 59 + ($responseContext == null ? 43 : ((Object)$responseContext).hashCode());
        Map<String, Object> $responsePayload = this.getResponsePayload();
        result = result * 59 + ($responsePayload == null ? 43 : ((Object)$responsePayload).hashCode());
        return result;
    }

    public String toString() {
        return "LambdaDestinationEvent(version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", requestContext=" + this.getRequestContext() + ", requestPayload=" + this.getRequestPayload() + ", responseContext=" + this.getResponseContext() + ", responsePayload=" + this.getResponsePayload() + ")";
    }

    public static class RequestContext
    implements Serializable {
        private String requestId;
        private String functionArn;
        private String condition;
        private int approximateInvokeCount;

        public String getRequestId() {
            return this.requestId;
        }

        public String getFunctionArn() {
            return this.functionArn;
        }

        public String getCondition() {
            return this.condition;
        }

        public int getApproximateInvokeCount() {
            return this.approximateInvokeCount;
        }

        public RequestContext setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RequestContext setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public RequestContext setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        public RequestContext setApproximateInvokeCount(int approximateInvokeCount) {
            this.approximateInvokeCount = approximateInvokeCount;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getApproximateInvokeCount() != other.getApproximateInvokeCount()) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$functionArn = this.getFunctionArn();
            String other$functionArn = other.getFunctionArn();
            if (this$functionArn == null ? other$functionArn != null : !this$functionArn.equals(other$functionArn)) {
                return false;
            }
            String this$condition = this.getCondition();
            String other$condition = other.getCondition();
            return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getApproximateInvokeCount();
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $functionArn = this.getFunctionArn();
            result = result * 59 + ($functionArn == null ? 43 : $functionArn.hashCode());
            String $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            return result;
        }

        public String toString() {
            return "LambdaDestinationEvent.RequestContext(requestId=" + this.getRequestId() + ", functionArn=" + this.getFunctionArn() + ", condition=" + this.getCondition() + ", approximateInvokeCount=" + this.getApproximateInvokeCount() + ")";
        }
    }
}

