/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.pdfdata.model.Entity;
import java.io.IOException;

@JsonDeserialize(using=BoundsDeserializer.class)
@JsonSerialize(using=BoundsSerializer.class)
public class Bounds
extends Entity {
    private final double lx;
    private final double by;
    private final double rx;
    private final double ty;

    public Bounds(double lx, double by, double rx, double ty) {
        this.lx = lx;
        this.by = by;
        this.rx = rx;
        this.ty = ty;
    }

    public double lx() {
        return this.lx;
    }

    public double by() {
        return this.by;
    }

    public double rx() {
        return this.rx;
    }

    public double ty() {
        return this.ty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)o;
        if (Double.compare(bounds.lx, this.lx) != 0) {
            return false;
        }
        if (Double.compare(bounds.by, this.by) != 0) {
            return false;
        }
        if (Double.compare(bounds.rx, this.rx) != 0) {
            return false;
        }
        return Double.compare(bounds.ty, this.ty) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lx);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.by);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rx);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.ty);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    static class BoundsSerializer
    extends StdSerializer<Bounds> {
        BoundsSerializer() {
            super(Bounds.class);
        }

        public void serialize(Bounds t, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
            jg.writeStartArray();
            jg.writeNumber(t.lx());
            jg.writeNumber(t.by());
            jg.writeNumber(t.rx());
            jg.writeNumber(t.ty());
            jg.writeEndArray();
        }
    }

    static class BoundsDeserializer
    extends StdDeserializer<Bounds> {
        BoundsDeserializer() {
            super(Bounds.class);
        }

        public Bounds deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
            JsonNode array = (JsonNode)jp.getCodec().readTree(jp);
            if (array.isArray() && array.size() == 4) {
                return new Bounds(array.get(0).doubleValue(), array.get(1).doubleValue(), array.get(2).doubleValue(), array.get(3).doubleValue());
            }
            throw new IOException("Invalid bounds data, must be array of 4 numbers");
        }
    }
}

