/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.tests.integration.plugins.EchoChannelHandler;

public class EchoProtocolHandler
implements ProtocolHandler {
    private ServiceConfiguration conf;
    private BrokerService brokerService;

    public String protocolName() {
        return "echo";
    }

    public boolean accept(String protocol) {
        return this.protocolName().equals(protocol.toLowerCase());
    }

    public void initialize(ServiceConfiguration conf) {
        this.conf = conf;
    }

    public String getProtocolDataToAdvertise() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName() + ":" + this.conf.getProperties().getProperty("echoServerPort");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(BrokerService service) {
        Objects.requireNonNull(this.conf, "initialize(ServiceConfiguration) has not been called before start");
        this.brokerService = service;
    }

    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        Objects.requireNonNull(this.brokerService, "start(BrokerService) has not been called before newChannelInitializers");
        InetSocketAddress address = this.getEchoAddress();
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new EchoChannelHandler()});
            }
        };
        return Collections.singletonMap(address, initializer);
    }

    private InetSocketAddress getEchoAddress() {
        String hostAndPort = this.getProtocolDataToAdvertise();
        String[] parsed = hostAndPort.split(":");
        return new InetSocketAddress(parsed[0], Integer.parseInt(parsed[1]));
    }

    public void close() {
    }
}

