/*
 * Decompiled with CFR 0.152.
 */
package io.testable.selenium;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.testable.selenium.TestableCSVReader;
import io.testable.selenium.TestableLog;
import io.testable.selenium.TestableMetric;
import io.testable.selenium.TestableTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class TestableSelenium {
    public static final int SELENIUM_PORT = Integer.getInteger("SELENIUM_PORT", -1);
    public static final String OUTPUT_DIR = System.getProperty("OUTPUT_DIR");
    public static final String REGION_NAME = System.getProperty("TESTABLE_REGION_NAME");
    public static final String GLOBAL_CLIENT_INDEX = System.getProperty("TESTABLE_GLOBAL_CLIENT_INDEX");
    public static final String ITERATION = System.getProperty("TESTABLE_ITERATION");
    public static final String PROXY_AUTOCONFIG_URL = System.getProperty("PROXY_AUTOCONFIG_URL");
    public static final String CHROME_BINARY_PATH = System.getProperty("CHROME_BINARY_PATH");
    public static final String FIREFOX_BINARY_PATH = System.getProperty("FIREFOX_BINARY_PATH");
    public static final String EDGE_BINARY_PATH = System.getProperty("EDGE_BINARY_PATH");
    public static final String PROFILE_DIR = System.getProperty("TESTABLE_PROFILE_DIR");
    public static final String RESULT_FILE = System.getProperty("TESTABLE_RESULT_FILE");
    public static final String DISPLAY_SIZE = System.getProperty("DISPLAY_SIZE");
    public static final String USER_AGENT = System.getProperty("USER_AGENT");
    public static final String SCALE_FACTOR = System.getProperty("SCALE_FACTOR");
    private static String RUM_SPEEDINDEXJS;
    private static PrintWriter resultStream;

    public static WebDriver newWebDriver(Capabilities capabilities) {
        try {
            Capabilities caps;
            if (capabilities instanceof DesiredCapabilities) {
                DesiredCapabilities desiredCapabilities = (DesiredCapabilities)capabilities;
                String browserName = desiredCapabilities.getBrowserName();
                if (browserName == null) {
                    throw new RuntimeException("DesiredCapabilities with no browser passed");
                }
                if (browserName.equals("chrome")) {
                    caps = new ChromeOptions();
                } else if (browserName.equals("firefox")) {
                    caps = new FirefoxOptions();
                } else if (browserName.equals("MicrosoftEdge")) {
                    caps = new EdgeOptions();
                } else {
                    throw new RuntimeException("Currently only Chrome, Firefox and Edge are supported on Testable");
                }
                caps.merge((Capabilities)desiredCapabilities);
            } else {
                caps = capabilities;
            }
            if (caps instanceof MutableCapabilities) {
                String[] screenSize;
                ChromeOptions opts;
                if (PROXY_AUTOCONFIG_URL != null && caps instanceof ChromeOptions) {
                    Float height;
                    Float width;
                    opts = (ChromeOptions)caps;
                    opts.setCapability("acceptInsecureCerts", true);
                    opts.addArguments(new String[]{"--proxy-pac-url=" + PROXY_AUTOCONFIG_URL, "--always-authorize-plugins", "--disable-gpu", "--no-sandbox", "--whitelisted-ips", "--enable-precise-memory-info", "--ignore-certificate-errors"});
                    if (PROFILE_DIR != null) {
                        opts.addArguments(new String[]{"--user-data-dir=" + PROFILE_DIR});
                    }
                    opts.addArguments(new String[]{"--profile-directory=Profile" + GLOBAL_CLIENT_INDEX});
                    opts.addArguments(new String[]{"--window-position=0,0"});
                    if (SCALE_FACTOR != null) {
                        opts.addArguments(new String[]{"--force-device-scale-factor=" + SCALE_FACTOR});
                        opts.addArguments(new String[]{"--high-dpi-support=" + SCALE_FACTOR});
                    }
                    if (DISPLAY_SIZE != null) {
                        screenSize = DISPLAY_SIZE.split("x", -1);
                        width = Float.valueOf(Float.parseFloat(screenSize[0]));
                        height = Float.valueOf(Float.parseFloat(screenSize[1]));
                        if (SCALE_FACTOR != null) {
                            width = Float.valueOf(width.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            height = Float.valueOf(height.floatValue() / Float.parseFloat(SCALE_FACTOR));
                        }
                        opts.addArguments(new String[]{"--window-size=" + Math.round(width.floatValue()) + "," + Math.round(height.floatValue())});
                    }
                    if (USER_AGENT != null) {
                        screenSize = DISPLAY_SIZE.split("x", -1);
                        width = Float.valueOf(Float.parseFloat(screenSize[0]));
                        height = Float.valueOf(Float.parseFloat(screenSize[1]));
                        HashMap<String, Object> mobileEmulation = new HashMap<String, Object>();
                        HashMap<String, Number> deviceMetrics = new HashMap<String, Number>();
                        if (SCALE_FACTOR != null) {
                            width = Float.valueOf(width.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            height = Float.valueOf(height.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            deviceMetrics.put("width", Math.round(width.floatValue()));
                            deviceMetrics.put("height", Math.round(height.floatValue()));
                            deviceMetrics.put("pixelRatio", Float.valueOf(Float.parseFloat(SCALE_FACTOR)));
                        }
                        mobileEmulation.put("deviceMetrics", deviceMetrics);
                        mobileEmulation.put("userAgent", USER_AGENT);
                        opts.setExperimentalOption("mobileEmulation", mobileEmulation);
                    }
                    if (CHROME_BINARY_PATH != null) {
                        opts.setBinary(CHROME_BINARY_PATH);
                    }
                } else if (caps instanceof FirefoxOptions) {
                    opts = (FirefoxOptions)caps;
                    opts.setCapability("acceptInsecureCerts", true);
                    opts.addPreference("browser.tabs.remote.autostart", false);
                    opts.addPreference("browser.tabs.remote.autostart.2", false);
                    opts.addPreference("dom.webnotifications.enabled", false);
                    opts.addPreference("dom.push.connection.enabled", false);
                    opts.addPreference("dom.push.enabled", false);
                    opts.addPreference("dom.push.alwaysConnect", false);
                    if (PROXY_AUTOCONFIG_URL != null) {
                        opts.addPreference("network.proxy.type", 2);
                        opts.addPreference("network.proxy.autoconfig_url", PROXY_AUTOCONFIG_URL);
                    }
                    opts.addPreference("browser.startup.page", 0);
                    opts.addPreference("network.captive-portal-service.enabled", false);
                    opts.addPreference("browser.newtabpage.activity-stream.disableSnippets", true);
                    opts.addPreference("browser.newtabpage.activity-stream.feeds.snippets", false);
                    opts.addPreference("services.sync.prefs.sync.browser.newtabpage.activity-stream.feeds.snippets", false);
                    if (FIREFOX_BINARY_PATH != null) {
                        opts.setBinary(FIREFOX_BINARY_PATH);
                    }
                    if (USER_AGENT != null) {
                        opts.addPreference("general.useragent.override", USER_AGENT);
                        opts.addPreference("layout.css.devPixelsPerPx", SCALE_FACTOR);
                    }
                    if (DISPLAY_SIZE != null) {
                        screenSize = DISPLAY_SIZE.split("x", -1);
                        Float width = Float.valueOf(Float.parseFloat(screenSize[0]));
                        Float height = Float.valueOf(Float.parseFloat(screenSize[1]));
                        if (SCALE_FACTOR != null) {
                            width = Float.valueOf(width.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            height = Float.valueOf(height.floatValue() / Float.parseFloat(SCALE_FACTOR));
                        }
                        opts.addArguments(new String[]{"--width", "" + Math.round(width.floatValue())});
                        opts.addArguments(new String[]{"--height", "" + Math.round(height.floatValue())});
                    }
                } else if (PROXY_AUTOCONFIG_URL != null && caps instanceof EdgeOptions) {
                    Float height;
                    Float width;
                    String[] screenSize2;
                    EdgeOptions edgeOptions = (EdgeOptions)caps;
                    edgeOptions.setCapability("acceptInsecureCerts", true);
                    ArrayList<String> args = new ArrayList<String>();
                    HashMap experimentalOptions = new HashMap();
                    TreeMap<String, Object> options = new TreeMap<String, Object>();
                    args.add("--proxy-pac-url=" + PROXY_AUTOCONFIG_URL);
                    args.add("--always-authorize-plugins");
                    args.add("--disable-gpu");
                    args.add("--no-sandbox");
                    args.add("--whitelisted-ips");
                    args.add("--enable-precise-memory-info");
                    args.add("--ignore-certificate-errors");
                    if (PROFILE_DIR != null) {
                        args.add("--user-data-dir=" + PROFILE_DIR);
                    }
                    args.add("--profile-directory=Profile" + GLOBAL_CLIENT_INDEX);
                    args.add("--window-position=0,0");
                    if (SCALE_FACTOR != null) {
                        args.add("--force-device-scale-factor=" + SCALE_FACTOR);
                    }
                    if (DISPLAY_SIZE != null) {
                        screenSize2 = DISPLAY_SIZE.split("x", -1);
                        width = Float.valueOf(Float.parseFloat(screenSize2[0]));
                        height = Float.valueOf(Float.parseFloat(screenSize2[1]));
                        if (SCALE_FACTOR != null) {
                            width = Float.valueOf(width.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            height = Float.valueOf(height.floatValue() / Float.parseFloat(SCALE_FACTOR));
                        }
                        args.add("--window-size=" + Math.round(width.floatValue()) + "," + Math.round(height.floatValue()));
                    }
                    if (USER_AGENT != null) {
                        screenSize2 = DISPLAY_SIZE.split("x", -1);
                        width = Float.valueOf(Float.parseFloat(screenSize2[0]));
                        height = Float.valueOf(Float.parseFloat(screenSize2[1]));
                        HashMap<String, Number> deviceMetrics = new HashMap<String, Number>();
                        if (SCALE_FACTOR != null) {
                            width = Float.valueOf(width.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            height = Float.valueOf(height.floatValue() / Float.parseFloat(SCALE_FACTOR));
                            deviceMetrics.put("width", Math.round(width.floatValue()));
                            deviceMetrics.put("height", Math.round(height.floatValue()));
                            deviceMetrics.put("pixelRatio", Float.valueOf(Float.parseFloat(SCALE_FACTOR)));
                        }
                        HashMap<String, Object> mobileEmulation = new HashMap<String, Object>();
                        mobileEmulation.put("deviceMetrics", deviceMetrics);
                        mobileEmulation.put("userAgent", USER_AGENT);
                        options.put("mobileEmulation", mobileEmulation);
                    }
                    if (EDGE_BINARY_PATH != null) {
                        options.put("binary", EDGE_BINARY_PATH);
                    }
                    options.put("args", ImmutableList.copyOf(args));
                    edgeOptions.setCapability("ms:edgeOptions", options);
                }
            }
            int port = SELENIUM_PORT > 0 ? SELENIUM_PORT : 4444;
            return new RemoteWebDriver(new URL("http://localhost:" + port + "/wd/hub"), caps);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static Path takeScreenshot(WebDriver driver, String name) {
        try {
            File screenshot = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            if (OUTPUT_DIR != null) {
                return Files.copy(screenshot.toPath(), Paths.get(OUTPUT_DIR, TestableSelenium.toName(name)), StandardCopyOption.REPLACE_EXISTING);
            }
            return screenshot.toPath();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static void reportMetric(TestableMetric metric) {
        TestableSelenium.writeToStream(new Result(metric.getType().name(), metric));
    }

    public static void log(TestableLog.Level level, String msg) {
        TestableSelenium.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static void log(TestableLog.Level level, Throwable cause) {
        String msg = Throwables.getStackTraceAsString((Throwable)cause);
        TestableSelenium.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static Map<String, Object> collectPerformanceMetrics(WebDriver driver) {
        if (RUM_SPEEDINDEXJS != null) {
            Map results = (Map)((JavascriptExecutor)driver).executeScript(RUM_SPEEDINDEXJS, new Object[0]);
            TestableSelenium.writeToStream(new Result("BrowserMetrics", results));
            return results;
        }
        return Collections.emptyMap();
    }

    public static TestableCSVReader readCsv(String path) throws IOException {
        return new TestableCSVReader(path);
    }

    public static TestableTest startTest(String name) {
        return new TestableTest(name);
    }

    private static String toName(String name) {
        if (REGION_NAME != null) {
            return REGION_NAME + "-" + GLOBAL_CLIENT_INDEX + "-" + ITERATION + "-" + name;
        }
        return name;
    }

    static void writeToStream(Result result) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String text = mapper.writeValueAsString((Object)result);
            if (resultStream != null) {
                resultStream.println(text);
                resultStream.flush();
            } else {
                System.out.println("[" + result.getType() + "] " + text);
            }
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    static {
        try {
            URL url = Resources.getResource((String)"rum-speedindex.js");
            RUM_SPEEDINDEXJS = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            System.out.println("Issue reading rum-speedindex.js from file");
            e.printStackTrace();
            RUM_SPEEDINDEXJS = null;
        }
        try {
            resultStream = RESULT_FILE != null ? new PrintWriter(new FileWriter(RESULT_FILE, true)) : null;
        }
        catch (IOException ioe) {
            System.out.println("Issue writing to Testable result file");
            ioe.printStackTrace();
            resultStream = null;
        }
    }

    static class Result {
        private String type;
        private Object data;

        public Result(String type, Object data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }
}

