/*
 * Decompiled with CFR 0.152.
 */
package io.vulpine.lib.sql.load;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;

public class SqlLoader {
    private static final Pattern dotToSlash = Pattern.compile("\\.");
    private static final Pattern comments = Pattern.compile("(/^\\s*\\*[\\s\\S]+?\\*/)|(--.*)*");
    private Map<String, String> sqlMap = new HashMap<String, String>();
    private String basePath = "/sql/";
    private String insertPath = "insert/";
    private String deletePath = "delete/";
    private String updatePath = "update/";
    private String selectPath = "select/";
    private String mergePath = "merge/";
    private String createPath = "create/";
    private String alterPath = "alter/";
    private String renamePath = "rename/";
    private String truncatePath = "truncate/";
    private String dropPath = "drop/";
    private String grantPath = "grant/";
    private String revokePath = "revoke/";

    public SqlLoader() {
    }

    public SqlLoader(String basePath) {
        this.basePath = basePath;
    }

    public String getAlterPath() {
        return this.alterPath;
    }

    public SqlLoader setAlterPath(String s) {
        this.alterPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public SqlLoader setBasePath(String s) {
        this.basePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getCreatePath() {
        return this.createPath;
    }

    public SqlLoader setCreatePath(String s) {
        this.createPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getDeletePath() {
        return this.deletePath;
    }

    public SqlLoader setDeletePath(String s) {
        this.deletePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getDropPath() {
        return this.dropPath;
    }

    public SqlLoader setDropPath(String s) {
        this.dropPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getGrantPath() {
        return this.grantPath;
    }

    public SqlLoader setGrantPath(String s) {
        this.grantPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getInsertPath() {
        return this.insertPath;
    }

    public SqlLoader setInsertPath(String s) {
        this.insertPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getMergePath() {
        return this.mergePath;
    }

    public SqlLoader setMergePath(String s) {
        this.mergePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getRenamePath() {
        return this.renamePath;
    }

    public SqlLoader setRenamePath(String s) {
        this.renamePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getRevokePath() {
        return this.revokePath;
    }

    public SqlLoader setRevokePath(String s) {
        this.revokePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getSelectPath() {
        return this.selectPath;
    }

    public SqlLoader setSelectPath(String s) {
        this.selectPath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getTruncatePath() {
        return this.truncatePath;
    }

    public SqlLoader setTruncatePath(String s) {
        this.truncatePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public String getUpdatePath() {
        return this.updatePath;
    }

    public SqlLoader setUpdatePath(String s) {
        this.updatePath = s.endsWith("/") ? s : s + "/";
        return this;
    }

    public Optional<String> alter(String path) {
        return this.rawSql(this.alterPath + path);
    }

    public Optional<String> create(String path) {
        return this.rawSql(this.createPath + path);
    }

    public Optional<String> delete(String path) {
        return this.rawSql(this.deletePath + path);
    }

    public Optional<String> drop(String path) {
        return this.rawSql(this.dropPath + path);
    }

    public Optional<String> grant(String path) {
        return this.rawSql(this.grantPath + path);
    }

    public Optional<String> insert(String path) {
        return this.rawSql(this.insertPath + path);
    }

    public Optional<String> merge(String path) {
        return this.rawSql(this.mergePath + path);
    }

    public Optional<String> rawSql(String path) {
        if (this.sqlMap.containsKey(path)) {
            return Optional.of(this.sqlMap.get(path));
        }
        String parsed = dotToSlash.matcher(path).replaceAll("/");
        InputStream in = this.getClass().getResourceAsStream(this.basePath + parsed + ".sql");
        if (in == null) {
            return Optional.empty();
        }
        Scanner sql = new Scanner(in);
        StringBuilder build = new StringBuilder();
        do {
            String s;
            if ((s = sql.skip(comments).nextLine()).isEmpty()) continue;
            build.append(s).append(System.getProperty("line.separator", "\n"));
        } while (sql.hasNextLine());
        this.sqlMap.put(path, build.toString());
        return Optional.of(build.toString());
    }

    public Optional<String> rename(String path) {
        return this.rawSql(this.renamePath + path);
    }

    public Optional<String> revoke(String path) {
        return this.rawSql(this.revokePath + path);
    }

    public Optional<String> select(String path) {
        return this.rawSql(this.selectPath + path);
    }

    public Optional<String> truncate(String path) {
        return this.rawSql(this.truncatePath + path);
    }

    public Optional<String> udpate(String path) {
        return this.rawSql(this.updatePath + path);
    }
}

