/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.Callable;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.DynamicUtil;
import com.mockobjects.dynamic.Mock;
import junit.framework.Assert;

public class CallSignature
extends Assert
implements Callable {
    private String methodName;
    private ConstraintMatcher constraints;
    private Callable delegate;

    public CallSignature(String methodName, ConstraintMatcher constraints, Callable delegate) {
        this.methodName = methodName;
        this.constraints = constraints;
        this.delegate = delegate;
    }

    public Object call(Mock mock, String methodName, Object[] args) throws Throwable {
        return this.delegate.call(mock, methodName, args);
    }

    public void verify() {
        this.delegate.verify();
    }

    public boolean matches(String methodName, Object[] args) {
        return this.methodName.equals(methodName) && this.constraints.matches(args);
    }

    public String getDescription() {
        return DynamicUtil.methodToString(this.methodName, this.constraints.getConstraints());
    }

    public String toString() {
        return Mock.className(this.getClass()) + "(" + this.getDescription() + ")";
    }
}

