/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.pgp;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPDecryptionException;
import net.quedex.api.pgp.PGPInvalidSignatureException;
import net.quedex.api.pgp.PGPKeyNotFoundException;
import net.quedex.api.pgp.PGPUnknownRecipientException;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;

public class BcDecryptor {
    private static final long HIDDEN_RECIPIENT_KEY_ID = 0L;
    private final BcPublicKey publicKey;
    private final BcPrivateKey ourKey;

    public BcDecryptor(BcPublicKey publicKey, BcPrivateKey ourKey) {
        this.publicKey = (BcPublicKey)Preconditions.checkNotNull((Object)publicKey);
        this.ourKey = (BcPrivateKey)Preconditions.checkNotNull((Object)ourKey);
    }

    public String decrypt(String message) throws PGPDecryptionException, PGPKeyNotFoundException, PGPUnknownRecipientException, PGPInvalidSignatureException {
        try {
            BcPGPObjectFactory uncompressedFactory;
            InputStream in = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
            BcPGPObjectFactory encryptedFactory = new BcPGPObjectFactory(in);
            Object object = encryptedFactory.nextObject();
            PGPEncryptedDataList encryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)encryptedFactory.nextObject();
            PGPPublicKeyEncryptedData encryptedData = null;
            InputStream clear = null;
            Iterator it = encryptedDataList.getEncryptedDataObjects();
            while (it.hasNext()) {
                encryptedData = (PGPPublicKeyEncryptedData)it.next();
                if (encryptedData.getKeyID() == 0L) {
                    for (PGPPrivateKey keyToCheck : this.ourKey.getPrivateKeys()) {
                        try {
                            clear = encryptedData.getDataStream((PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(keyToCheck));
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                } else {
                    try {
                        PGPPrivateKey privateKey = this.ourKey.getPrivateKeyWithId(encryptedData.getKeyID());
                        clear = encryptedData.getDataStream((PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(privateKey));
                    }
                    catch (PGPKeyNotFoundException privateKey) {
                        // empty catch block
                    }
                }
                if (clear == null) continue;
            }
            if (clear == null) {
                throw new PGPUnknownRecipientException("Message is encrypted for unknown recipient");
            }
            BcPGPObjectFactory plainFactory = new BcPGPObjectFactory(clear);
            Object nextObject = plainFactory.nextObject();
            PGPCompressedData compressedData = (PGPCompressedData)nextObject;
            plainFactory = uncompressedFactory = new BcPGPObjectFactory(compressedData.getDataStream());
            nextObject = uncompressedFactory.nextObject();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)nextObject;
            PGPOnePassSignature signature = sigList.get(0);
            nextObject = plainFactory.nextObject();
            if (!(nextObject instanceof PGPLiteralData)) {
                throw new PGPDataValidationException("Expected literal data packet");
            }
            PGPLiteralData literalData = (PGPLiteralData)nextObject;
            ByteStreams.copy((InputStream)literalData.getInputStream(), (OutputStream)out);
            PGPSignatureList signatureList = (PGPSignatureList)plainFactory.nextObject();
            signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), this.publicKey.getSigningKey());
            signature.update(out.toByteArray());
            if (signature.verify(signatureList.get(0))) {
                BcDecryptor.checkIntegrity(encryptedData);
                return new String(out.toByteArray(), StandardCharsets.UTF_8);
            }
            throw new PGPInvalidSignatureException("The signature is not valid");
        }
        catch (IOException | RuntimeException | PGPException e) {
            throw new PGPDecryptionException("Error Decrypting message", e);
        }
    }

    private static void checkIntegrity(PGPPublicKeyEncryptedData encryptedData) throws PGPException, IOException, PGPDecryptionException {
        if (encryptedData.isIntegrityProtected()) {
            if (!encryptedData.verify()) {
                throw new PGPDecryptionException("Message failed integrity check");
            }
        } else {
            throw new PGPDecryptionException("Message not integrity protected");
        }
    }
}

