/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class OrderFilled {
    private final long clientOrderId;
    private final int filledQuantity;

    @JsonCreator
    public OrderFilled(@JsonProperty(value="client_order_id") long clientOrderId, @JsonProperty(value="trade_quantity") int filledQuantity) {
        Preconditions.checkArgument((filledQuantity > 0 ? 1 : 0) != 0, (String)"filledQuantity=%s <= 0", (Object[])new Object[]{filledQuantity});
        this.clientOrderId = clientOrderId;
        this.filledQuantity = filledQuantity;
    }

    public long getClientOrderId() {
        return this.clientOrderId;
    }

    public int getFilledQuantity() {
        return this.filledQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFilled that = (OrderFilled)o;
        return this.clientOrderId == that.clientOrderId && this.filledQuantity == that.filledQuantity;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.filledQuantity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("filledQuantity", this.filledQuantity).toString();
    }
}

