/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public final class PriceQuantity {
    private final BigDecimal price;
    private final int quantity;

    public PriceQuantity(BigDecimal price, int quantity) {
        this.price = (BigDecimal)Preconditions.checkNotNull((Object)price, (Object)"null price");
        this.quantity = quantity;
    }

    public PriceQuantity(int quantity) {
        this.price = null;
        this.quantity = quantity;
    }

    @JsonCreator
    private PriceQuantity(BigDecimal[] priceQty) {
        Preconditions.checkArgument((priceQty.length == 2 ? 1 : 0) != 0, (String)"priceQty.length=%s != 2", (Object[])new Object[]{priceQty.length});
        this.price = priceQty[0];
        this.quantity = priceQty[1].intValueExact();
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceQuantity priceQuantity = (PriceQuantity)o;
        return this.quantity == priceQuantity.quantity && Objects.equal((Object)this.price, (Object)priceQuantity.price);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.price, this.quantity});
    }

    public String toString() {
        return "[" + this.price + ',' + this.quantity + ']';
    }
}

