/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.pgp.BcDecryptor;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPExceptionBase;
import net.quedex.api.user.AccountState;
import net.quedex.api.user.AccountStateListener;
import net.quedex.api.user.InternalTransferExecuted;
import net.quedex.api.user.InternalTransferListener;
import net.quedex.api.user.InternalTransferReceived;
import net.quedex.api.user.InternalTransferRejected;
import net.quedex.api.user.LiquidationOrderCancelled;
import net.quedex.api.user.LiquidationOrderFilled;
import net.quedex.api.user.LiquidationOrderPlaced;
import net.quedex.api.user.OpenPosition;
import net.quedex.api.user.OpenPositionListener;
import net.quedex.api.user.OrderCancelFailed;
import net.quedex.api.user.OrderCancelled;
import net.quedex.api.user.OrderFilled;
import net.quedex.api.user.OrderForcefullyCancelled;
import net.quedex.api.user.OrderListener;
import net.quedex.api.user.OrderModificationFailed;
import net.quedex.api.user.OrderModified;
import net.quedex.api.user.OrderPlaceFailed;
import net.quedex.api.user.OrderPlaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMessageReceiver.class);
    private final BcDecryptor decryptor;
    private final CompletableFuture<Long> lastNonceFuture = new CompletableFuture();
    private volatile OrderListener orderListener;
    private volatile OpenPositionListener openPositionListener;
    private volatile AccountStateListener accountStateListener;
    private volatile InternalTransferListener internalTransferListener;

    UserMessageReceiver(BcPublicKey qdxPublicKey, BcPrivateKey userPrivateKey) {
        super(LOGGER);
        this.decryptor = new BcDecryptor(qdxPublicKey, userPrivateKey);
    }

    void registerOrderListener(OrderListener orderListener) {
        this.orderListener = orderListener;
    }

    void registerOpenPositionListener(OpenPositionListener openPositionListener) {
        this.openPositionListener = openPositionListener;
    }

    void registerAccountStateListener(AccountStateListener accountStateListener) {
        this.accountStateListener = accountStateListener;
    }

    void registerInternalTransferListener(InternalTransferListener listener) {
        this.internalTransferListener = listener;
    }

    long getLastNonce() throws TimeoutException, InterruptedException {
        try {
            return this.lastNonceFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot happen", e);
        }
    }

    @Override
    protected void processData(String data) throws IOException, PGPExceptionBase {
        String decrypted = this.decryptor.decrypt(data);
        LOGGER.trace("processData(data={}, decrypted={})", (Object)data, (Object)decrypted);
        try {
            JsonNode dataJsonArray = OBJECT_MAPPER.readTree(decrypted);
            for (JsonNode dataJson : dataJsonArray) {
                switch (dataJson.get("type").asText()) {
                    case "account_state": {
                        this.onAccountState((AccountState)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, AccountState.class));
                        break;
                    }
                    case "open_position": {
                        this.onOpenPosition((OpenPosition)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OpenPosition.class));
                        break;
                    }
                    case "order_cancelled": {
                        this.onOrderCancelled((OrderCancelled)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderCancelled.class));
                        break;
                    }
                    case "order_forcefully_cancelled": {
                        this.onOrderForcefullyCancelled((OrderForcefullyCancelled)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderForcefullyCancelled.class));
                        break;
                    }
                    case "order_cancel_failed": {
                        this.onOrderCancelFailed((OrderCancelFailed)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderCancelFailed.class));
                        break;
                    }
                    case "order_filled": {
                        this.onOrderFilled((OrderFilled)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderFilled.class));
                        break;
                    }
                    case "order_placed": {
                        this.onOrderPlaced((OrderPlaced)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderPlaced.class));
                        break;
                    }
                    case "order_modified": {
                        this.onOrderModified((OrderModified)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderModified.class));
                        break;
                    }
                    case "order_modification_failed": {
                        this.onOrderModificationFailed((OrderModificationFailed)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderModificationFailed.class));
                        break;
                    }
                    case "order_place_failed": {
                        this.onOrderPlaceFailed((OrderPlaceFailed)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderPlaceFailed.class));
                        break;
                    }
                    case "subscribed": {
                        LOGGER.debug("Subscribed successfully");
                        break;
                    }
                    case "last_nonce": {
                        this.onLastNonce(dataJson);
                        break;
                    }
                    case "liquidation_order_placed": {
                        this.onLiquidationOrderPlaced((LiquidationOrderPlaced)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, LiquidationOrderPlaced.class));
                        break;
                    }
                    case "liquidation_order_cancelled": {
                        this.onLiquidationOrderCancelled((LiquidationOrderCancelled)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, LiquidationOrderCancelled.class));
                        break;
                    }
                    case "liquidation_order_filled": {
                        this.onLiquidationOrderFilled((LiquidationOrderFilled)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, LiquidationOrderFilled.class));
                        break;
                    }
                    case "internal_transfer_executed": {
                        this.onInternalTransferExecuted((InternalTransferExecuted)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, InternalTransferExecuted.class));
                        break;
                    }
                    case "internal_transfer_rejected": {
                        this.onInternalTransferRejected((InternalTransferRejected)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, InternalTransferRejected.class));
                        break;
                    }
                    case "internal_transfer_received": {
                        this.onInternalTransferReceived((InternalTransferReceived)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, InternalTransferReceived.class));
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommunicationException("Error parsing json on decrypted=" + decrypted, e);
        }
    }

    private void onAccountState(AccountState accountState) {
        AccountStateListener accountStateListener = this.accountStateListener;
        if (accountStateListener != null) {
            accountStateListener.onAccountState(accountState);
        }
    }

    private void onOpenPosition(OpenPosition openPosition) {
        OpenPositionListener openPositionListener = this.openPositionListener;
        if (openPositionListener != null) {
            openPositionListener.onOpenPosition(openPosition);
        }
    }

    private void onOrderCancelled(OrderCancelled orderCancelled) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderCancelled(orderCancelled);
        }
    }

    private void onOrderForcefullyCancelled(OrderForcefullyCancelled orderForcefullyCancelled) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderForcefullyCancelled(orderForcefullyCancelled);
        }
    }

    private void onOrderCancelFailed(OrderCancelFailed orderCancelFailed) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderCancelFailed(orderCancelFailed);
        }
    }

    private void onOrderFilled(OrderFilled orderFilled) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderFilled(orderFilled);
        }
    }

    private void onOrderModificationFailed(OrderModificationFailed orderModificationFailed) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderModificationFailed(orderModificationFailed);
        }
    }

    private void onOrderModified(OrderModified orderModified) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderModified(orderModified);
        }
    }

    private void onOrderPlaced(OrderPlaced orderPlaced) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderPlaced(orderPlaced);
        }
    }

    private void onOrderPlaceFailed(OrderPlaceFailed orderPlaceFailed) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onOrderPlaceFailed(orderPlaceFailed);
        }
    }

    private void onLiquidationOrderPlaced(LiquidationOrderPlaced liquidationOrderPlaced) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onLiquidationOrderPlaced(liquidationOrderPlaced);
        }
    }

    private void onLiquidationOrderCancelled(LiquidationOrderCancelled liquidationOrderCancelled) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onLiquidationOrderCancelled(liquidationOrderCancelled);
        }
    }

    private void onLiquidationOrderFilled(LiquidationOrderFilled liquidationOrderFilled) {
        OrderListener orderListener = this.orderListener;
        if (orderListener != null) {
            orderListener.onLiquidationOrderFilled(liquidationOrderFilled);
        }
    }

    private void onInternalTransferExecuted(InternalTransferExecuted internalTransferExecuted) {
        InternalTransferListener listener = this.internalTransferListener;
        if (listener != null) {
            listener.onInternalTransferExecuted(internalTransferExecuted);
        }
    }

    private void onInternalTransferRejected(InternalTransferRejected internalTransferRejected) {
        InternalTransferListener listener = this.internalTransferListener;
        if (listener != null) {
            listener.onInternalTransferRejected(internalTransferRejected);
        }
    }

    private void onInternalTransferReceived(InternalTransferReceived internalTransferReceived) {
        InternalTransferListener listener = this.internalTransferListener;
        if (listener != null) {
            listener.onInternalTransferReceived(internalTransferReceived);
        }
    }

    private void onLastNonce(JsonNode dataJson) {
        this.lastNonceFuture.complete(dataJson.get("last_nonce").asLong());
    }
}

