/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.future.model;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.raphimc.noteblocklib.format.future.model.FutureHeader;
import net.raphimc.noteblocklib.format.future.model.FutureNote;
import net.raphimc.noteblocklib.model.NotemapData;
import net.raphimc.noteblocklib.util.Instrument;

public class FutureData
extends NotemapData<FutureNote> {
    public FutureData(FutureHeader header, LittleEndianDataInputStream dis) throws IOException {
        int tick = 0;
        while (dis.available() > 0) {
            byte b = dis.readByte();
            if (b == (header.useMagicValue() ? (byte)5 : 64)) {
                tick += dis.readUnsignedShort();
                continue;
            }
            this.notes.computeIfAbsent(tick, k -> new ArrayList()).add(new FutureNote(dis.readByte(), Instrument.fromMcId(b)));
        }
    }

    public FutureData(Map<Integer, List<FutureNote>> notes) {
        super(notes);
    }
}

