/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.asterisk.fastagi.ReplyBuilder;
import net.sf.asterisk.fastagi.reply.AGIReply;

public class ReplyBuilderImpl
implements ReplyBuilder {
    private static final Pattern STATUS_PATTERN = Pattern.compile("^(\\d{3})[ -]");
    private static final Pattern RESULT_PATTERN = Pattern.compile("^200 result=(\\S+)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("^200 result=\\S+ \\((.*)\\)");
    private static final Pattern ADDITIONAL_ATTRIBUTES_PATTERN = Pattern.compile("^200 result=\\S+( \\(.*\\) )?(.+)$");
    private static final Pattern ADDITIONAL_ATTRIBUTE_PATTERN = Pattern.compile("(\\S+)=(\\S+)");
    private static final Pattern SYNOPSIS_PATTERN = Pattern.compile("^\\s*Usage:\\s*(.*)\\s*$");
    private static final String END_OF_PROPER_USAGE = "520 End of proper usage.";

    public AGIReply buildReply(List lines) {
        if (lines.size() == 0) {
            return null;
        }
        AGIReply reply = new AGIReply();
        String firstLine = (String)lines.get(0);
        Matcher matcher = STATUS_PATTERN.matcher(firstLine);
        if (matcher.find()) {
            reply.setStatus(Integer.parseInt(matcher.group(1)));
        }
        if (reply.getStatus() == AGIReply.SC_SUCCESS) {
            matcher = RESULT_PATTERN.matcher(firstLine);
            if (matcher.find()) {
                reply.setResult(matcher.group(1));
            }
            if ((matcher = PARENTHESIS_PATTERN.matcher(firstLine)).find()) {
                reply.setExtra(matcher.group(1));
            }
            if ((matcher = ADDITIONAL_ATTRIBUTES_PATTERN.matcher(firstLine)).find()) {
                String s = matcher.group(2);
                Matcher attributeMatcher = ADDITIONAL_ATTRIBUTE_PATTERN.matcher(s);
                while (attributeMatcher.find()) {
                    String key = attributeMatcher.group(1);
                    String value = attributeMatcher.group(2);
                    reply.setAttribute(key, value);
                }
            }
        } else if (reply.getStatus() == AGIReply.SC_INVALID_COMMAND_SYNTAX) {
            String line;
            String secondLine;
            Matcher synopsisMatcher;
            if (lines.size() > 1 && (synopsisMatcher = SYNOPSIS_PATTERN.matcher(secondLine = (String)lines.get(1))).find()) {
                reply.setSynopsis(synopsisMatcher.group(1));
            }
            StringBuffer usageSB = new StringBuffer();
            for (int i = 2; i < lines.size() && !END_OF_PROPER_USAGE.equals(line = (String)lines.get(i)); ++i) {
                usageSB.append(line.trim());
                usageSB.append(" ");
            }
            reply.setUsage(usageSB.toString().trim());
        }
        return reply;
    }
}

