/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.RequestBuilder;
import net.sf.asterisk.fastagi.impl.AGIRequestImpl;

public class RequestBuilderImpl
implements RequestBuilder {
    public AGIRequest buildRequest(Collection lines) {
        if (lines == null) {
            throw new IllegalArgumentException("Environment must not be null.");
        }
        AGIRequestImpl request = new AGIRequestImpl();
        Map map = this.buildMap(lines);
        request.setScript((String)map.get("network_script"));
        request.setRequestURL((String)map.get("request"));
        request.setChannel((String)map.get("channel"));
        request.setUniqueId((String)map.get("uniqueid"));
        request.setType((String)map.get("type"));
        request.setLanguage((String)map.get("language"));
        if (map.get("callerid") != null) {
            String rawCallerId = (String)map.get("callerid");
            request.setCallerId(this.getCallerId(rawCallerId));
            request.setCallerIdName(this.getCallerIdName(rawCallerId));
        }
        request.setDnid((String)map.get("dnid"));
        request.setRdnis((String)map.get("rdnis"));
        request.setContext((String)map.get("context"));
        request.setExtension((String)map.get("extension"));
        if (map.get("priority") != null) {
            request.setPriority(new Integer((String)map.get("priority")));
        }
        if (map.get("enhanced") != null) {
            if ("1.0".equals((String)map.get("enhanced"))) {
                request.setEnhanced(Boolean.TRUE);
            } else {
                request.setEnhanced(Boolean.FALSE);
            }
        }
        request.setAccountCode((String)map.get("accountcode"));
        return request;
    }

    private Map buildMap(Collection lines) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator lineIterator = lines.iterator();
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            int colonPosition = line.indexOf(58);
            if (colonPosition < 0 || !line.startsWith("agi_") || line.length() < colonPosition + 2) continue;
            String key = line.substring(4, colonPosition).toLowerCase();
            String value = line.substring(colonPosition + 2);
            if (value.length() == 0) continue;
            map.put(key, value);
        }
        return map;
    }

    private String getCallerId(String rawCallerId) {
        int lbPosition = rawCallerId.indexOf(60);
        int rbPosition = rawCallerId.indexOf(62);
        if (lbPosition < 0 || rbPosition < 0) {
            return rawCallerId;
        }
        return rawCallerId.substring(lbPosition + 1, rbPosition);
    }

    private String getCallerIdName(String rawCallerId) {
        int lbPosition = rawCallerId.indexOf(60);
        if (lbPosition < 0) {
            return null;
        }
        String callerIdName = rawCallerId.substring(0, lbPosition).trim();
        if (callerIdName.startsWith("\"") && callerIdName.endsWith("\"")) {
            callerIdName = callerIdName.substring(1, callerIdName.length() - 1);
        }
        if (callerIdName.length() == 0) {
            return null;
        }
        return callerIdName;
    }
}

