/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager.impl;

import java.io.IOException;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.manager.ActionBuilder;
import net.sf.asterisk.manager.ManagerWriter;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.manager.impl.ActionBuilderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagerWriterImpl
implements ManagerWriter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ActionBuilder actionBuilder = new ActionBuilderImpl();
    private SocketConnectionFacade socket;

    public synchronized void setSocket(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    public synchronized void sendAction(ManagerAction action) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send action: socket is null");
        }
        String actionString = this.actionBuilder.buildAction(action);
        this.socket.write(actionString);
        this.socket.flush();
        this.logger.debug((Object)("Sent " + action.getAction() + " action with actionId '" + action.getActionId() + "':\n" + actionString));
    }
}

