/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean;

import act.app.App;
import act.db.DbPlugin;
import act.db.DbService;
import act.db.ebean.EbeanService;
import act.db.sql.tx.TxError;
import act.db.sql.tx.TxInfo;
import act.db.sql.tx.TxStart;
import act.db.sql.tx.TxStop;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.inject.param.ParamValueLoaderService;
import com.avaje.ebean.TxScope;
import com.avaje.ebeaninternal.api.HelpScopeTrans;
import com.avaje.ebeaninternal.api.ScopeTrans;
import java.util.EventObject;
import java.util.Map;
import org.osgl.OsglConfig;
import osgl.version.Version;

public class EbeanPlugin
extends DbPlugin {
    public static final Version VERSION = Version.of(EbeanPlugin.class);
    private static final ThreadLocal<ScopeTrans> txHolder = new ThreadLocal();

    public void register() {
        super.register();
        this.registerGlobalMappingFilter();
    }

    protected void applyTo(App app) {
        super.applyTo(app);
        app.eventBus().bind(TxStart.class, (ActEventListener)new ActEventListenerBase<TxStart>(){

            public void on(TxStart eventObject) {
                TxInfo info = (TxInfo)eventObject.source();
                TxScope scope = new TxScope();
                scope.setReadOnly(info.readOnly());
                ScopeTrans tx = HelpScopeTrans.createScopeTrans((TxScope)scope);
                txHolder.set(tx);
            }
        }).bind(TxStop.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject eventObject) throws Exception {
                ScopeTrans tx = (ScopeTrans)txHolder.get();
                if (null != tx) {
                    tx.onExit(null, 1);
                }
            }
        }).bind(TxError.class, (ActEventListener)new ActEventListenerBase<TxError>(){

            public void on(TxError eventObject) throws Exception {
                ScopeTrans tx = (ScopeTrans)txHolder.get();
                if (null != tx) {
                    Throwable cause = (Throwable)eventObject.source();
                    tx.onExit((Object)cause, 191);
                }
            }
        });
    }

    public DbService initDbService(String id, App app, Map<String, String> conf) {
        ParamValueLoaderService.waiveFields((String[])new String[]{"_ebean_intercept", "_ebean_identity"});
        return new EbeanService(id, app, conf);
    }

    private void registerGlobalMappingFilter() {
        OsglConfig.addGlobalMappingFilter((String)"starts:_ebean_");
    }
}

