/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.conf.AppConfigKey;
import act.conf.ConfigKey;
import act.db.Dao;
import act.db.ebean.EbeanAgentLoader;
import act.db.ebean.EbeanConfigLoaded;
import act.db.ebean.EbeanDao;
import act.db.ebean.EbeanModelBase;
import act.db.ebean.EbeanPlugin;
import act.db.ebean.util.EbeanConfigAdaptor;
import act.db.ebean.util.EbeanDataSourceProvider;
import act.db.ebean.util.EbeanDataSourceWrapper;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbService;
import act.db.sql.tx.TxContext;
import act.event.ActEvent;
import act.event.SysEventListenerBase;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.TxScope;
import com.avaje.ebean.config.ServerConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EventObject;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public final class EbeanService
extends SqlDbService {
    public static final Version VERSION = EbeanPlugin.VERSION;
    private EbeanServer ebean;
    private EbeanServer ebeanReadOnly;

    public EbeanService(String dbId, App app, Map<String, String> config) {
        super(dbId, app, config);
        String s = config.get("agentPackage");
        String scanPackage = (String)this.app().config().get((ConfigKey)AppConfigKey.SCAN_PACKAGE, null);
        final String agentPackage = null == s ? scanPackage : S.string((Object)s).trim();
        E.invalidConfigurationIf((boolean)S.blank((String)agentPackage), (String)"\"agentPackage\" not configured", (Object[])new Object[0]);
        if (this.isTraceEnabled()) {
            this.trace("\"agentPackage\" configured: %s", new Object[]{agentPackage});
        }
        app.eventBus().bind(SysEventId.PRE_LOAD_CLASSES, (SysEventListener)new SysEventListenerBase(S.concat((String)dbId, (String)"-ebean-pre-cl")){

            public void on(EventObject event) {
                String s = S.buffer((String)"debug=").append(Act.isDev() ? "1" : "0").append(";packages=").append(agentPackage).toString();
                if (!EbeanAgentLoader.loadAgentFromClasspath("ebean-agent", s)) {
                    this.warn("ebean-agent not found in classpath - not dynamically loaded", new Object[0]);
                }
            }
        });
    }

    protected boolean supportDdl() {
        return true;
    }

    protected void dataSourceProvided(DataSource dataSource, DataSourceConfig dsConfig, boolean readonly) {
        ServerConfig ebeanConfig;
        if (dataSource instanceof EbeanDataSourceWrapper) {
            EbeanDataSourceWrapper wrapper = (EbeanDataSourceWrapper)dataSource;
            ebeanConfig = wrapper.ebeanConfig;
        } else {
            ebeanConfig = new EbeanConfigAdaptor().adaptFrom(this.config, dsConfig, this);
            ebeanConfig.setDataSource(dataSource);
        }
        this.app().eventBus().trigger((ActEvent)new EbeanConfigLoaded(ebeanConfig), new Object[0]);
        if (readonly) {
            ebeanConfig.setDdlGenerate(false);
            ebeanConfig.setDdlRun(false);
            this.ebeanReadOnly = EbeanServerFactory.create((ServerConfig)ebeanConfig);
        } else {
            this.ebean = EbeanServerFactory.create((ServerConfig)ebeanConfig);
            if (null == this.ebeanReadOnly) {
                this.ebeanReadOnly = this.ebean;
            }
        }
    }

    protected DataSourceProvider builtInDataSourceProvider() {
        return new EbeanDataSourceProvider(this.config, this);
    }

    protected void releaseResources() {
        if (null != this.ebean) {
            this.ebean.shutdown(true, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ebean shutdown: %s", new Object[]{this.id()});
            }
            this.ebean = null;
        }
        if (null != this.ebeanReadOnly) {
            this.ebeanReadOnly.shutdown(true, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ebean readonly shutdown: %s", new Object[]{this.id()});
            }
            this.ebeanReadOnly = null;
        }
        super.releaseResources();
    }

    public <DAO extends Dao> DAO defaultDao(Class<?> modelType) {
        Type type;
        if (EbeanModelBase.class.isAssignableFrom(modelType) && (type = modelType.getGenericSuperclass()) instanceof ParameterizedType) {
            return (DAO)((Dao)$.cast(new EbeanDao((Class)((ParameterizedType)type).getActualTypeArguments()[0], modelType, this)));
        }
        Class idType = EbeanService.findModelIdTypeByAnnotation(modelType, Id.class);
        E.illegalArgumentIf((null == idType ? 1 : 0) != 0, (String)"Cannot find out Dao for model type[%s]: unable to identify the ID type", (Object[])new Object[]{modelType});
        return (DAO)((Dao)$.cast(new EbeanDao(idType, modelType, this)));
    }

    public <DAO extends Dao> DAO newDaoInstance(Class<DAO> daoType) {
        E.illegalArgumentIf((!EbeanDao.class.isAssignableFrom(daoType) ? 1 : 0) != 0, (String)"expected EbeanDao, found: %s", (Object[])new Object[]{daoType});
        EbeanDao dao = (EbeanDao)((Object)$.cast((Object)this.app().getInstance(daoType)));
        dao.dbService(this);
        return (DAO)((Object)dao);
    }

    public Class<? extends Annotation> entityAnnotationType() {
        return Entity.class;
    }

    protected void doStartTx(Object delegate, boolean readOnly) {
        if (readOnly) {
            TxScope scope = TxScope.required().setReadOnly(true);
            this.ebeanReadOnly.beginTransaction(scope);
        } else {
            this.ebean.beginTransaction();
        }
    }

    protected void doRollbackTx(Object delegate, Throwable cause) {
        Transaction tx = this.ebean.currentTransaction();
        if (null == tx) {
            return;
        }
        if (TxContext.readOnly()) {
            this.ebeanReadOnly.endTransaction();
        } else {
            this.logger.warn(cause, "Roll back transaction");
            this.ebean.rollbackTransaction();
        }
    }

    protected void doEndTxIfActive(Object delegate) {
        Transaction tx = this.ebean.currentTransaction();
        if (null == tx) {
            return;
        }
        if (TxContext.readOnly()) {
            this.ebeanReadOnly.endTransaction();
        } else {
            this.ebean.commitTransaction();
        }
    }

    public EbeanServer ebean(boolean readOnly) {
        return readOnly ? this.ebeanReadOnly : this.ebean;
    }

    public EbeanServer ebean() {
        return this.ebean;
    }

    public EbeanServer ebeanReadOnly() {
        return this.ebeanReadOnly;
    }
}

