/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean.util;

import act.db.ebean.util.EbeanConfigAdaptor;
import act.db.ebean.util.EbeanDataSourceWrapper;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbService;
import act.db.sql.SqlDbServiceConfig;
import act.db.sql.monitor.DataSourceStatus;
import com.avaje.ebean.config.ServerConfig;
import java.util.Map;
import javax.sql.DataSource;
import org.avaje.datasource.DataSourceAlertFactory;
import org.avaje.datasource.DataSourceFactory;

public class EbeanDataSourceProvider
extends DataSourceProvider {
    private SqlDbServiceConfig actConfig;
    private SqlDbService svc;

    public EbeanDataSourceProvider(SqlDbServiceConfig actConfig, SqlDbService svc) {
        this.actConfig = actConfig;
        this.svc = svc;
    }

    public DataSource createDataSource(DataSourceConfig conf) {
        ServerConfig ebeanConfig = new EbeanConfigAdaptor().adaptFrom(this.actConfig, conf, this.svc);
        DataSourceFactory factory = (DataSourceFactory)ebeanConfig.service(DataSourceFactory.class);
        if (factory == null) {
            throw new IllegalStateException("No DataSourceFactory service implementation found in class path. Probably missing dependency to avaje-datasource?");
        }
        DataSourceAlertFactory alertFactory = (DataSourceAlertFactory)ebeanConfig.service(DataSourceAlertFactory.class);
        org.avaje.datasource.DataSourceConfig dsConfig = ebeanConfig.getDataSourceConfig();
        if (alertFactory != null) {
            dsConfig.setAlert(alertFactory.createAlert());
        }
        if (conf.readOnly) {
            dsConfig.setAutoCommit(true);
        }
        String poolName = ebeanConfig.getName() + (conf.readOnly ? "-ro" : "");
        return new EbeanDataSourceWrapper(ebeanConfig, factory.createPool(poolName, dsConfig));
    }

    public Map<String, String> confKeyMapping() {
        return null;
    }

    public DataSourceStatus getStatus(DataSource ds) {
        return null;
    }
}

