/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import java.util.Set;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;
import org.androidannotations.api.sharedpreferences.SharedPreferencesCompat;

public final class StringSetPrefField
extends AbstractPrefField {
    private final Set<String> defaultValue;

    StringSetPrefField(SharedPreferences sharedPreferences, String key, Set<String> defaultValue) {
        super(sharedPreferences, key);
        this.defaultValue = defaultValue;
    }

    public Set<String> get() {
        return this.getOr(this.defaultValue);
    }

    public Set<String> getOr(Set<String> defaultValue) {
        return SharedPreferencesCompat.getStringSet(this.sharedPreferences, this.key, defaultValue);
    }

    public void put(Set<String> value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        SharedPreferencesCompat.putStringSet(editor, this.key, value);
        this.apply(editor);
    }
}

