/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.annotations.ReceiverAction;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.ExtraParameterHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.EReceiverHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ReceiverActionHandler
extends BaseAnnotationHandler<EReceiverHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private ExtraHandler extraHandler;

    public ReceiverActionHandler(ProcessingEnvironment processingEnvironment) {
        super(ReceiverAction.class, processingEnvironment);
        this.extraHandler = new ExtraHandler(processingEnvironment);
    }

    public void register(AnnotationHandlers annotationHandlers) {
        annotationHandlers.add(this);
        annotationHandlers.add(this.extraHandler);
    }

    @Override
    protected void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEReceiver(element, validatedElements, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.param.hasNoOtherParameterThanContextOrIntentOrReceiverActionExtraAnnotated((ExecutableElement)element, valid);
    }

    @Override
    public void process(Element element, EReceiverHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        ReceiverAction annotation = element.getAnnotation(ReceiverAction.class);
        String[] dataSchemes = annotation.dataSchemes();
        String extraKey = annotation.value();
        if (extraKey.isEmpty()) {
            extraKey = methodName;
        }
        JFieldVar actionKeyField = this.createStaticActionField(holder, extraKey, methodName);
        JFieldVar dataSchemesField = this.createStaticDataSchemesField(holder, dataSchemes, methodName);
        this.addActionInOnReceive(holder, executableElement, methodName, actionKeyField, dataSchemesField);
    }

    private JFieldVar createStaticActionField(EReceiverHolder holder, String extraKey, String methodName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase("action", methodName, null);
        return holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(extraKey));
    }

    private JFieldVar createStaticDataSchemesField(EReceiverHolder holder, String[] dataSchemes, String methodName) {
        if (dataSchemes == null || dataSchemes.length == 0) {
            return null;
        }
        JClass listOfStrings = this.classes().LIST.narrow(this.classes().STRING);
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase("dataSchemes", methodName, null);
        JInvocation asListInvoke = this.classes().ARRAYS.staticInvoke("asList");
        for (String scheme : dataSchemes) {
            asListInvoke.arg(scheme);
        }
        return holder.getGeneratedClass().field(25, listOfStrings, staticFieldName, (JExpression)asListInvoke);
    }

    private void addActionInOnReceive(EReceiverHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionKeyField, JFieldVar dataSchemesField) {
        JExpression filterCondition = actionKeyField.invoke("equals").arg(holder.getOnReceiveIntentAction());
        if (dataSchemesField != null) {
            filterCondition = filterCondition.cand(dataSchemesField.invoke("contains").arg(holder.getOnReceiveIntentDataScheme()));
        }
        JBlock callActionBlock = holder.getOnReceiveBody()._if(filterCondition)._then();
        JFieldRef receiverRef = holder.getGeneratedClass().staticRef("this");
        JInvocation callActionInvocation = receiverRef.invoke(methodName);
        JVar intent = holder.getOnReceiveIntent();
        JVar extras = null;
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        for (VariableElement variableElement : methodParameters) {
            JClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), holder);
            if (extraParamClass.equals(this.classes().CONTEXT)) {
                callActionInvocation.arg(holder.getOnReceiveContext());
                continue;
            }
            if (extraParamClass.equals(this.classes().INTENT)) {
                callActionInvocation.arg(intent);
                continue;
            }
            if (variableElement.getAnnotation(ReceiverAction.Extra.class) == null) continue;
            if (extras == null) {
                extras = callActionBlock.decl(this.classes().BUNDLE, "extras_", JOp.cond(intent.invoke("getExtras").ne(JExpr._null()), intent.invoke("getExtras"), JExpr._new(this.classes().BUNDLE)));
            }
            callActionInvocation.arg(this.extraHandler.getExtraValue(variableElement, extras, callActionBlock, holder));
        }
        callActionBlock.add(callActionInvocation);
        callActionBlock._return();
    }

    private static class ExtraHandler
    extends ExtraParameterHandler {
        public ExtraHandler(ProcessingEnvironment processingEnvironment) {
            super(ReceiverAction.Extra.class, ReceiverAction.class, processingEnvironment);
        }

        @Override
        public String getAnnotationValue(VariableElement parameter) {
            return parameter.getAnnotation(ReceiverAction.Extra.class).value();
        }

        public JExpression getExtraValue(VariableElement parameter, JVar extras, JBlock block, EReceiverHolder holder) {
            return this.getExtraValue(parameter, holder.getOnReceiveIntent(), extras, block, holder.getOnReceiveMethod(), holder);
        }
    }
}

