/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.Extra;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.HasExtras;
import org.androidannotations.holder.HasIntentBuilder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ExtraHandler
extends BaseAnnotationHandler<HasExtras> {
    private final AnnotationHelper annotationHelper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public ExtraHandler(ProcessingEnvironment processingEnvironment) {
        super(Extra.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivity(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.canBePutInABundle(element, valid);
    }

    @Override
    public void process(Element element, HasExtras holder) {
        Extra annotation = element.getAnnotation(Extra.class);
        String extraKey = annotation.value();
        String fieldName = element.getSimpleName().toString();
        if (extraKey.isEmpty()) {
            extraKey = fieldName;
        }
        JFieldVar extraKeyStaticField = this.createStaticExtraField(holder, extraKey, fieldName);
        this.injectExtraInComponent(element, holder, extraKeyStaticField, fieldName);
        if (holder instanceof HasIntentBuilder) {
            this.createIntentInjectionMethod(element, (HasIntentBuilder)((Object)holder), extraKeyStaticField, fieldName);
        }
    }

    private JFieldVar createStaticExtraField(HasExtras holder, String extraKey, String fieldName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, fieldName, "Extra");
        JFieldVar staticExtraField = holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(extraKey));
        }
        return staticExtraField;
    }

    private void injectExtraInComponent(Element element, HasExtras hasExtras, JFieldVar extraKeyStaticField, String fieldName) {
        JMethod injectExtrasMethod = hasExtras.getInjectExtrasMethod();
        JVar extras = hasExtras.getInjectExtras();
        JBlock injectExtrasBlock = hasExtras.getInjectExtrasBlock();
        TypeMirror type = this.codeModelHelper.getActualType(element, hasExtras);
        JClass elementClass = this.codeModelHelper.typeMirrorToJClass(element.asType(), hasExtras);
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, type);
        JFieldRef extraField = JExpr.ref(fieldName);
        JInvocation intent = JExpr.invoke("getIntent");
        JBlock ifContainsKey = injectExtrasBlock._if(JExpr.invoke((JExpression)extras, "containsKey").arg(extraKeyStaticField))._then();
        JExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromIntentOrBundle(elementClass, intent, extras, extraKeyStaticField, injectExtrasMethod, hasExtras);
        ifContainsKey.assign(extraField, restoreMethodCall);
    }

    private void createIntentInjectionMethod(Element element, HasIntentBuilder holder, JFieldVar extraKeyStaticField, String fieldName) {
        holder.getIntentBuilder().getPutExtraMethod(element.asType(), fieldName, extraKeyStaticField);
    }
}

