/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.sharedpreferences.Pref;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class PrefHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public PrefHandler(ProcessingEnvironment processingEnvironment) {
        super(Pref.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isSharedPreference(element, validatedElements, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror fieldTypeMirror = element.asType();
        JClass prefClass = this.refClass(fieldTypeMirror.toString());
        String elementTypeName = fieldTypeMirror.toString();
        int index = elementTypeName.lastIndexOf(".");
        if (index != -1) {
            elementTypeName = elementTypeName.substring(index + 1);
        }
        Set<? extends Element> sharedPrefElements = this.validatedModel.getRootAnnotatedElements(SharedPref.class.getName());
        for (Element element2 : sharedPrefElements) {
            GeneratedClassHolder sharedPrefHolder = this.processHolder.getGeneratedClassHolder(element2);
            String sharedPrefName = sharedPrefHolder.getGeneratedClass().name();
            if (!elementTypeName.equals(sharedPrefName)) continue;
            prefClass = sharedPrefHolder.getGeneratedClass();
            break;
        }
        JBlock methodBody = holder.getInitBody();
        JFieldRef jFieldRef = JExpr.ref(fieldName);
        methodBody.assign(jFieldRef, JExpr._new(prefClass).arg(holder.getContextRef()));
    }
}

