/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.process;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.process.OriginatingElements;

public class ProcessHolder {
    private final Map<Element, GeneratedClassHolder> generatedClassHolders = new HashMap<Element, GeneratedClassHolder>();
    private final ProcessingEnvironment processingEnvironment;
    private final JCodeModel codeModel;
    private final Map<String, JClass> loadedClasses = new HashMap<String, JClass>();
    private final Classes classes;
    private final Set<Class<?>> apiClassesToGenerate = new HashSet();
    private final OriginatingElements originatingElements = new OriginatingElements();

    public ProcessHolder(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.codeModel = new JCodeModel();
        this.classes = new Classes();
        this.refClass(CanonicalNameConstants.STRING);
        this.preloadJavaLangClasses();
    }

    private void preloadJavaLangClasses() {
        this.loadedClasses.put(String.class.getName(), this.refClass(String.class));
        this.loadedClasses.put(Object.class.getName(), this.refClass(Object.class));
    }

    public void put(Element element, GeneratedClassHolder generatedClassHolder) {
        JDefinedClass generatedClass = generatedClassHolder.getGeneratedClass();
        String qualifiedName = generatedClass.fullName();
        this.originatingElements.add(qualifiedName, element);
        this.generatedClassHolders.put(element, generatedClassHolder);
    }

    public GeneratedClassHolder getGeneratedClassHolder(Element element) {
        for (Element key : this.generatedClassHolders.keySet()) {
            if (!key.asType().toString().equals(element.asType().toString())) continue;
            return this.generatedClassHolders.get(key);
        }
        return null;
    }

    public JClass refClass(Class<?> clazz) {
        return this.codeModel.ref(clazz);
    }

    public JClass refClass(String fullyQualifiedClassName) {
        int arrayCounter = 0;
        while (fullyQualifiedClassName.endsWith("[]")) {
            ++arrayCounter;
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.length() - 2);
        }
        JClass refClass = this.loadedClasses.get(fullyQualifiedClassName);
        if (refClass == null) {
            refClass = this.codeModel.directClass(fullyQualifiedClassName);
            this.loadedClasses.put(fullyQualifiedClassName, refClass);
        }
        for (int i = 0; i < arrayCounter; ++i) {
            refClass = refClass.array();
        }
        return refClass;
    }

    public JDefinedClass definedClass(String fullyQualifiedClassName) {
        JDefinedClass refClass = (JDefinedClass)this.loadedClasses.get(fullyQualifiedClassName);
        if (refClass == null) {
            try {
                refClass = this.codeModel._class(fullyQualifiedClassName);
            }
            catch (JClassAlreadyExistsException e) {
                refClass = (JDefinedClass)this.refClass(fullyQualifiedClassName);
            }
            this.loadedClasses.put(fullyQualifiedClassName, refClass);
        }
        return refClass;
    }

    public ProcessingEnvironment processingEnvironment() {
        return this.processingEnvironment;
    }

    public JCodeModel codeModel() {
        return this.codeModel;
    }

    public Classes classes() {
        return this.classes;
    }

    public OriginatingElements getOriginatingElements() {
        return this.originatingElements;
    }

    public Set<Class<?>> getApiClassesToGenerate() {
        return this.apiClassesToGenerate;
    }

    public void generateApiClass(Element originatingElement, Class<?> apiClass) {
        this.originatingElements.add(apiClass.getCanonicalName(), originatingElement);
        this.apiClassesToGenerate.add(apiClass);
    }

    public class Classes {
        public final JClass RUNTIME_EXCEPTION;
        public final JClass EXCEPTION;
        public final JClass THROWABLE;
        public final JClass CHAR_SEQUENCE;
        public final JClass CLASS_CAST_EXCEPTION;
        public final JClass SERIALIZABLE;
        public final JClass STRING;
        public final JClass STRING_BUILDER;
        public final JClass SYSTEM;
        public final JClass INPUT_STREAM;
        public final JClass FILE_INPUT_STREAM;
        public final JClass SQL_EXCEPTION;
        public final JClass COLLECTIONS;
        public final JClass THREAD;
        public final JClass HASH_MAP;
        public final JClass LIST;
        public final JClass OBJECT;
        public final JClass ARRAYS;
        public final JClass HASH_SET;
        public final JClass LOG;
        public final JClass BUNDLE;
        public final JClass ACTIVITY;
        public final JClass EDITABLE;
        public final JClass TEXT_WATCHER;
        public final JClass SEEKBAR;
        public final JClass ON_SEEKBAR_CHANGE_LISTENER;
        public final JClass TEXT_VIEW;
        public final JClass TEXT_VIEW_ON_EDITOR_ACTION_LISTENER;
        public final JClass COMPOUND_BUTTON;
        public final JClass COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER;
        public final JClass VIEW;
        public final JClass VIEW_ON_CLICK_LISTENER;
        public final JClass VIEW_ON_TOUCH_LISTENER;
        public final JClass VIEW_ON_LONG_CLICK_LISTENER;
        public final JClass VIEW_ON_FOCUS_CHANGE_LISTENER;
        public final JClass VIEW_GROUP_LAYOUT_PARAMS;
        public final JClass KEY_EVENT;
        public final JClass CONTEXT;
        public final JClass INTENT;
        public final JClass INTENT_FILTER;
        public final JClass BROADCAST_RECEIVER;
        public final JClass LOCAL_BROADCAST_MANAGER;
        public final JClass COMPONENT_NAME;
        public final JClass VIEW_GROUP;
        public final JClass LAYOUT_INFLATER;
        public final JClass FRAGMENT_ACTIVITY;
        public final JClass FRAGMENT;
        public final JClass SUPPORT_V4_FRAGMENT;
        public final JClass HTML;
        public final JClass WINDOW_MANAGER_LAYOUT_PARAMS;
        public final JClass ADAPTER_VIEW;
        public final JClass ON_ITEM_LONG_CLICK_LISTENER;
        public final JClass ON_ITEM_CLICK_LISTENER;
        public final JClass ON_ITEM_SELECTED_LISTENER;
        public final JClass WINDOW;
        public final JClass MENU_ITEM;
        public final JClass MENU_INFLATER;
        public final JClass MENU;
        public final JClass ANIMATION_UTILS;
        public final JClass RESOURCES;
        public final JClass CONFIGURATION;
        public final JClass MOTION_EVENT;
        public final JClass HANDLER;
        public final JClass KEY_STORE;
        public final JClass VIEW_SERVER;
        public final JClass PARCELABLE;
        public final JClass LOOPER;
        public final JClass POWER_MANAGER;
        public final JClass WAKE_LOCK;
        public final JClass BUILD_VERSION;
        public final JClass BUILD_VERSION_CODES;
        public final JClass ACTIVITY_COMPAT;
        public final JClass APP_WIDGET_MANAGER;
        public final JClass PREFERENCE;
        public final JClass PREFERENCE_CHANGE_LISTENER;
        public final JClass PREFERENCE_CLICK_LISTENER;
        public final JClass PREFERENCE_ACTIVITY_HEADER;
        public final JClass SHERLOCK_MENU;
        public final JClass SHERLOCK_MENU_ITEM;
        public final JClass SHERLOCK_MENU_INFLATER;
        public final JClass ROBO_CONTEXT;
        public final JClass ROBO_INJECTOR;
        public final JClass CONTENT_VIEW_LISTENER;
        public final JClass KEY;
        public final JClass ON_RESTART_EVENT;
        public final JClass ON_START_EVENT;
        public final JClass ON_RESUME_EVENT;
        public final JClass ON_PAUSE_EVENT;
        public final JClass ON_NEW_INTENT_EVENT;
        public final JClass EVENT_MANAGER;
        public final JClass CONTEXT_SCOPE;
        public final JClass VIEW_MEMBERS_INJECTOR;
        public final JClass ROBO_GUICE;
        public final JClass INJECT;
        public final JClass ON_STOP_EVENT;
        public final JClass ON_DESTROY_EVENT;
        public final JClass ON_CONFIGURATION_CHANGED_EVENT;
        public final JClass ON_CONTENT_CHANGED_EVENT;
        public final JClass ON_ACTIVITY_RESULT_EVENT;
        public final JClass ON_CREATE_EVENT;
        public final JClass CONNECTION_SOURCE;
        public final JClass OPEN_HELPER_MANAGER;
        public final JClass RUNTIME_EXCEPTION_DAO;
        public final JClass DAO_MANAGER;
        public final JClass CLIENT_CONNECTION_MANAGER;
        public final JClass DEFAULT_HTTP_CLIENT;
        public final JClass SSL_SOCKET_FACTORY;
        public final JClass PLAIN_SOCKET_FACTORY;
        public final JClass SCHEME;
        public final JClass SCHEME_REGISTRY;
        public final JClass SINGLE_CLIENT_CONN_MANAGER;
        public final JClass REST_TEMPLATE;
        public final JClass HTTP_METHOD;
        public final JClass HTTP_ENTITY;
        public final JClass HTTP_HEADERS;
        public final JClass MEDIA_TYPE;
        public final JClass RESPONSE_ENTITY;
        public final JClass HTTP_AUTHENTICATION;
        public final JClass HTTP_BASIC_AUTHENTICATION;
        public final JClass REST_CLIENT_EXCEPTION;
        public final JClass NESTED_RUNTIME_EXCEPTION;

        public Classes() {
            this.RUNTIME_EXCEPTION = ProcessHolder.this.refClass(RuntimeException.class);
            this.EXCEPTION = ProcessHolder.this.refClass(Exception.class);
            this.THROWABLE = ProcessHolder.this.refClass(Throwable.class);
            this.CHAR_SEQUENCE = ProcessHolder.this.refClass(CharSequence.class);
            this.CLASS_CAST_EXCEPTION = ProcessHolder.this.refClass(ClassCastException.class);
            this.SERIALIZABLE = ProcessHolder.this.refClass(Serializable.class);
            this.STRING = ProcessHolder.this.refClass(String.class);
            this.STRING_BUILDER = ProcessHolder.this.refClass(StringBuilder.class);
            this.SYSTEM = ProcessHolder.this.refClass(System.class);
            this.INPUT_STREAM = ProcessHolder.this.refClass(InputStream.class);
            this.FILE_INPUT_STREAM = ProcessHolder.this.refClass(FileInputStream.class);
            this.SQL_EXCEPTION = ProcessHolder.this.refClass(SQLException.class);
            this.COLLECTIONS = ProcessHolder.this.refClass(Collections.class);
            this.THREAD = ProcessHolder.this.refClass(Thread.class);
            this.HASH_MAP = ProcessHolder.this.refClass(HashMap.class);
            this.LIST = ProcessHolder.this.refClass(List.class);
            this.OBJECT = ProcessHolder.this.refClass(Object.class);
            this.ARRAYS = ProcessHolder.this.refClass(Arrays.class);
            this.HASH_SET = ProcessHolder.this.refClass(HashSet.class);
            this.LOG = ProcessHolder.this.refClass("android.util.Log");
            this.BUNDLE = ProcessHolder.this.refClass("android.os.Bundle");
            this.ACTIVITY = ProcessHolder.this.refClass("android.app.Activity");
            this.EDITABLE = ProcessHolder.this.refClass("android.text.Editable");
            this.TEXT_WATCHER = ProcessHolder.this.refClass("android.text.TextWatcher");
            this.SEEKBAR = ProcessHolder.this.refClass("android.widget.SeekBar");
            this.ON_SEEKBAR_CHANGE_LISTENER = ProcessHolder.this.refClass("android.widget.SeekBar.OnSeekBarChangeListener");
            this.TEXT_VIEW = ProcessHolder.this.refClass("android.widget.TextView");
            this.TEXT_VIEW_ON_EDITOR_ACTION_LISTENER = ProcessHolder.this.refClass("android.widget.TextView.OnEditorActionListener");
            this.COMPOUND_BUTTON = ProcessHolder.this.refClass("android.widget.CompoundButton");
            this.COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER = ProcessHolder.this.refClass("android.widget.CompoundButton.OnCheckedChangeListener");
            this.VIEW = ProcessHolder.this.refClass("android.view.View");
            this.VIEW_ON_CLICK_LISTENER = ProcessHolder.this.refClass("android.view.View.OnClickListener");
            this.VIEW_ON_TOUCH_LISTENER = ProcessHolder.this.refClass("android.view.View.OnTouchListener");
            this.VIEW_ON_LONG_CLICK_LISTENER = ProcessHolder.this.refClass("android.view.View.OnLongClickListener");
            this.VIEW_ON_FOCUS_CHANGE_LISTENER = ProcessHolder.this.refClass("android.view.View.OnFocusChangeListener");
            this.VIEW_GROUP_LAYOUT_PARAMS = ProcessHolder.this.refClass("android.view.ViewGroup.LayoutParams");
            this.KEY_EVENT = ProcessHolder.this.refClass("android.view.KeyEvent");
            this.CONTEXT = ProcessHolder.this.refClass("android.content.Context");
            this.INTENT = ProcessHolder.this.refClass("android.content.Intent");
            this.INTENT_FILTER = ProcessHolder.this.refClass("android.content.IntentFilter");
            this.BROADCAST_RECEIVER = ProcessHolder.this.refClass("android.content.BroadcastReceiver");
            this.LOCAL_BROADCAST_MANAGER = ProcessHolder.this.refClass("android.support.v4.content.LocalBroadcastManager");
            this.COMPONENT_NAME = ProcessHolder.this.refClass("android.content.ComponentName");
            this.VIEW_GROUP = ProcessHolder.this.refClass("android.view.ViewGroup");
            this.LAYOUT_INFLATER = ProcessHolder.this.refClass("android.view.LayoutInflater");
            this.FRAGMENT_ACTIVITY = ProcessHolder.this.refClass("android.support.v4.app.FragmentActivity");
            this.FRAGMENT = ProcessHolder.this.refClass("android.app.Fragment");
            this.SUPPORT_V4_FRAGMENT = ProcessHolder.this.refClass("android.support.v4.app.Fragment");
            this.HTML = ProcessHolder.this.refClass("android.text.Html");
            this.WINDOW_MANAGER_LAYOUT_PARAMS = ProcessHolder.this.refClass("android.view.WindowManager.LayoutParams");
            this.ADAPTER_VIEW = ProcessHolder.this.refClass("android.widget.AdapterView");
            this.ON_ITEM_LONG_CLICK_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemLongClickListener");
            this.ON_ITEM_CLICK_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemClickListener");
            this.ON_ITEM_SELECTED_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemSelectedListener");
            this.WINDOW = ProcessHolder.this.refClass("android.view.Window");
            this.MENU_ITEM = ProcessHolder.this.refClass("android.view.MenuItem");
            this.MENU_INFLATER = ProcessHolder.this.refClass("android.view.MenuInflater");
            this.MENU = ProcessHolder.this.refClass("android.view.Menu");
            this.ANIMATION_UTILS = ProcessHolder.this.refClass("android.view.animation.AnimationUtils");
            this.RESOURCES = ProcessHolder.this.refClass("android.content.res.Resources");
            this.CONFIGURATION = ProcessHolder.this.refClass("android.content.res.Configuration");
            this.MOTION_EVENT = ProcessHolder.this.refClass("android.view.MotionEvent");
            this.HANDLER = ProcessHolder.this.refClass("android.os.Handler");
            this.KEY_STORE = ProcessHolder.this.refClass("java.security.KeyStore");
            this.VIEW_SERVER = ProcessHolder.this.refClass("org.androidannotations.api.ViewServer");
            this.PARCELABLE = ProcessHolder.this.refClass("android.os.Parcelable");
            this.LOOPER = ProcessHolder.this.refClass("android.os.Looper");
            this.POWER_MANAGER = ProcessHolder.this.refClass("android.os.PowerManager");
            this.WAKE_LOCK = ProcessHolder.this.refClass("android.os.PowerManager.WakeLock");
            this.BUILD_VERSION = ProcessHolder.this.refClass("android.os.Build.VERSION");
            this.BUILD_VERSION_CODES = ProcessHolder.this.refClass("android.os.Build.VERSION_CODES");
            this.ACTIVITY_COMPAT = ProcessHolder.this.refClass("android.support.v4.app.ActivityCompat");
            this.APP_WIDGET_MANAGER = ProcessHolder.this.refClass("android.appwidget.AppWidgetManager");
            this.PREFERENCE = ProcessHolder.this.refClass("android.preference.Preference");
            this.PREFERENCE_CHANGE_LISTENER = ProcessHolder.this.refClass("android.preference.Preference.OnPreferenceChangeListener");
            this.PREFERENCE_CLICK_LISTENER = ProcessHolder.this.refClass("android.preference.Preference.OnPreferenceClickListener");
            this.PREFERENCE_ACTIVITY_HEADER = ProcessHolder.this.refClass("android.preference.PreferenceActivity.Header");
            this.SHERLOCK_MENU = ProcessHolder.this.refClass("com.actionbarsherlock.view.Menu");
            this.SHERLOCK_MENU_ITEM = ProcessHolder.this.refClass("com.actionbarsherlock.view.MenuItem");
            this.SHERLOCK_MENU_INFLATER = ProcessHolder.this.refClass("com.actionbarsherlock.view.MenuInflater");
            this.ROBO_CONTEXT = ProcessHolder.this.refClass("roboguice.util.RoboContext");
            this.ROBO_INJECTOR = ProcessHolder.this.refClass("roboguice.inject.RoboInjector");
            this.CONTENT_VIEW_LISTENER = ProcessHolder.this.refClass("roboguice.inject.ContentViewListener");
            this.KEY = ProcessHolder.this.refClass("com.google.inject.Key");
            this.ON_RESTART_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnRestartEvent");
            this.ON_START_EVENT = ProcessHolder.this.refClass("roboguice.context.event.OnStartEvent");
            this.ON_RESUME_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnResumeEvent");
            this.ON_PAUSE_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnPauseEvent");
            this.ON_NEW_INTENT_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnNewIntentEvent");
            this.EVENT_MANAGER = ProcessHolder.this.refClass("roboguice.event.EventManager");
            this.CONTEXT_SCOPE = ProcessHolder.this.refClass("roboguice.inject.ContextScope");
            this.VIEW_MEMBERS_INJECTOR = ProcessHolder.this.refClass("roboguice.inject.ViewListener.ViewMembersInjector");
            this.ROBO_GUICE = ProcessHolder.this.refClass("roboguice.RoboGuice");
            this.INJECT = ProcessHolder.this.refClass("com.google.inject.Inject");
            this.ON_STOP_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnStopEvent");
            this.ON_DESTROY_EVENT = ProcessHolder.this.refClass("roboguice.context.event.OnDestroyEvent");
            this.ON_CONFIGURATION_CHANGED_EVENT = ProcessHolder.this.refClass("roboguice.context.event.OnConfigurationChangedEvent");
            this.ON_CONTENT_CHANGED_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnContentChangedEvent");
            this.ON_ACTIVITY_RESULT_EVENT = ProcessHolder.this.refClass("roboguice.activity.event.OnActivityResultEvent");
            this.ON_CREATE_EVENT = ProcessHolder.this.refClass("roboguice.context.event.OnCreateEvent");
            this.CONNECTION_SOURCE = ProcessHolder.this.refClass("com.j256.ormlite.support.ConnectionSource");
            this.OPEN_HELPER_MANAGER = ProcessHolder.this.refClass("com.j256.ormlite.android.apptools.OpenHelperManager");
            this.RUNTIME_EXCEPTION_DAO = ProcessHolder.this.refClass("com.j256.ormlite.dao.RuntimeExceptionDao");
            this.DAO_MANAGER = ProcessHolder.this.refClass("com.j256.ormlite.dao.DaoManager");
            this.CLIENT_CONNECTION_MANAGER = ProcessHolder.this.refClass("org.apache.http.conn.ClientConnectionManager");
            this.DEFAULT_HTTP_CLIENT = ProcessHolder.this.refClass("org.apache.http.impl.client.DefaultHttpClient");
            this.SSL_SOCKET_FACTORY = ProcessHolder.this.refClass("org.apache.http.conn.ssl.SSLSocketFactory");
            this.PLAIN_SOCKET_FACTORY = ProcessHolder.this.refClass("org.apache.http.conn.scheme.PlainSocketFactory");
            this.SCHEME = ProcessHolder.this.refClass("org.apache.http.conn.scheme.Scheme");
            this.SCHEME_REGISTRY = ProcessHolder.this.refClass("org.apache.http.conn.scheme.SchemeRegistry");
            this.SINGLE_CLIENT_CONN_MANAGER = ProcessHolder.this.refClass("org.apache.http.impl.conn.SingleClientConnManager");
            this.REST_TEMPLATE = ProcessHolder.this.refClass("org.springframework.web.client.RestTemplate");
            this.HTTP_METHOD = ProcessHolder.this.refClass("org.springframework.http.HttpMethod");
            this.HTTP_ENTITY = ProcessHolder.this.refClass("org.springframework.http.HttpEntity");
            this.HTTP_HEADERS = ProcessHolder.this.refClass("org.springframework.http.HttpHeaders");
            this.MEDIA_TYPE = ProcessHolder.this.refClass("org.springframework.http.MediaType");
            this.RESPONSE_ENTITY = ProcessHolder.this.refClass("org.springframework.http.ResponseEntity");
            this.HTTP_AUTHENTICATION = ProcessHolder.this.refClass("org.springframework.http.HttpAuthentication");
            this.HTTP_BASIC_AUTHENTICATION = ProcessHolder.this.refClass("org.springframework.http.HttpBasicAuthentication");
            this.REST_CLIENT_EXCEPTION = ProcessHolder.this.refClass("org.springframework.web.client.RestClientException");
            this.NESTED_RUNTIME_EXCEPTION = ProcessHolder.this.refClass("org.springframework.core.NestedRuntimeException");
        }
    }
}

