/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.testutils;

import java.io.File;
import java.lang.reflect.Method;
import org.androidannotations.testutils.ProcessorTestHelper;

public class AAProcessorTestHelper
extends ProcessorTestHelper {
    public void addManifestProcessorParameter(Class<?> classOfPackagingContainingManifest) {
        this.addManifestProcessorParameter(classOfPackagingContainingManifest, "AndroidManifest.xml");
    }

    public void addManifestProcessorParameter(Class<?> classOfPackagingContainingManifest, String manifestFileName) {
        String manifestPath = this.toPath(classOfPackagingContainingManifest, manifestFileName);
        this.addProcessorParameter("androidManifestFile", manifestPath);
    }

    public File toGeneratedFile(Class<?> compiledClass) {
        File output = new File("target/generated-test", this.toPath(compiledClass.getPackage()) + "/" + compiledClass.getSimpleName() + AAProcessorTestHelper.getAndroidAnnotationsClassSuffix() + ".java");
        return output;
    }

    public File toGeneratedFile(Class<?> classOfPackagingContainingFile, String compiledClassSimpleName) {
        return new File("target/generated-test", this.toPath(classOfPackagingContainingFile.getPackage()) + "/" + compiledClassSimpleName + AAProcessorTestHelper.getAndroidAnnotationsClassSuffix() + ".java");
    }

    public String toPath(Class<?> classOfPackagingContainingFile, String filename) {
        return classOfPackagingContainingFile.getResource(filename).getPath();
    }

    private static String getAndroidAnnotationsClassSuffix() {
        try {
            Class<?> modelConstantsClazz = Class.forName("org.androidannotations.helper.ModelConstants");
            Method classSuffixMethod = modelConstantsClazz.getMethod("classSuffix", new Class[0]);
            return (String)classSuffixMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return "_";
        }
    }
}

