/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class MinimalWordCount {
    public static void main(String[] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.read().from("gs://apache-beam-samples/shakespeare/*"))).apply("ExtractWords", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (String word : ((String)c.element()).split("[^\\p{L}]+")) {
                    if (word.isEmpty()) continue;
                    c.output((Object)word);
                }
            }
        }))).apply(Count.perElement())).apply("FormatResults", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<String, Long>, String>(){

            public String apply(KV<String, Long> input) {
                return (String)input.getKey() + ": " + input.getValue();
            }
        }))).apply((PTransform)TextIO.write().to("wordcounts"));
        p.run().waitUntilFinish();
    }
}

