/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.common;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExamplePubsubTopicAndSubscriptionOptions;
import org.apache.beam.examples.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.examples.java.repackaged.com.google.common.collect.Lists;
import org.apache.beam.examples.java.repackaged.com.google.common.collect.Sets;
import org.apache.beam.examples.java.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.util.Transport;
import org.joda.time.Duration;

public class ExampleUtils {
    private static final int SC_NOT_FOUND = 404;
    public static final String TOKENIZER_PATTERN = "[^\\p{L}]+";
    private final PipelineOptions options;
    private Bigquery bigQueryClient = null;
    private Pubsub pubsubClient = null;
    private Set<PipelineResult> pipelinesToCancel = Sets.newHashSet();
    private List<String> pendingMessages = Lists.newArrayList();

    public ExampleUtils(PipelineOptions options) {
        this.options = options;
    }

    public void setup() throws IOException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backOff = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.millis((long)200L)).backoff();
        GoogleJsonResponseException lastException = null;
        try {
            while (true) {
                try {
                    this.setupPubsub();
                    this.setupBigQueryTable();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    lastException = e;
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff)) continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(lastException);
    }

    public void setupPubsub() throws IOException {
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)this.options.as(ExamplePubsubTopicAndSubscriptionOptions.class);
        if (!pubsubOptions.getPubsubTopic().isEmpty()) {
            this.pendingMessages.add("**********************Set Up Pubsub************************");
            this.setupPubsubTopic(pubsubOptions.getPubsubTopic());
            this.pendingMessages.add("The Pub/Sub topic has been set up for this example: " + pubsubOptions.getPubsubTopic());
            if (!pubsubOptions.getPubsubSubscription().isEmpty()) {
                this.setupPubsubSubscription(pubsubOptions.getPubsubTopic(), pubsubOptions.getPubsubSubscription());
                this.pendingMessages.add("The Pub/Sub subscription has been set up for this example: " + pubsubOptions.getPubsubSubscription());
            }
        }
    }

    public void setupBigQueryTable() throws IOException {
        ExampleBigQueryTableOptions bigQueryTableOptions = (ExampleBigQueryTableOptions)this.options.as(ExampleBigQueryTableOptions.class);
        if (bigQueryTableOptions.getBigQueryDataset() != null && bigQueryTableOptions.getBigQueryTable() != null && bigQueryTableOptions.getBigQuerySchema() != null) {
            this.pendingMessages.add("******************Set Up Big Query Table*******************");
            this.setupBigQueryTable(bigQueryTableOptions.getProject(), bigQueryTableOptions.getBigQueryDataset(), bigQueryTableOptions.getBigQueryTable(), bigQueryTableOptions.getBigQuerySchema());
            this.pendingMessages.add("The BigQuery table has been set up for this example: " + bigQueryTableOptions.getProject() + ":" + bigQueryTableOptions.getBigQueryDataset() + "." + bigQueryTableOptions.getBigQueryTable());
        }
    }

    private void tearDown() {
        ExampleBigQueryTableOptions bigQueryTableOptions;
        this.pendingMessages.add("*************************Tear Down*************************");
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)this.options.as(ExamplePubsubTopicAndSubscriptionOptions.class);
        if (!pubsubOptions.getPubsubTopic().isEmpty()) {
            try {
                this.deletePubsubTopic(pubsubOptions.getPubsubTopic());
                this.pendingMessages.add("The Pub/Sub topic has been deleted: " + pubsubOptions.getPubsubTopic());
            }
            catch (IOException e) {
                this.pendingMessages.add("Failed to delete the Pub/Sub topic : " + pubsubOptions.getPubsubTopic());
            }
            if (!pubsubOptions.getPubsubSubscription().isEmpty()) {
                try {
                    this.deletePubsubSubscription(pubsubOptions.getPubsubSubscription());
                    this.pendingMessages.add("The Pub/Sub subscription has been deleted: " + pubsubOptions.getPubsubSubscription());
                }
                catch (IOException e) {
                    this.pendingMessages.add("Failed to delete the Pub/Sub subscription : " + pubsubOptions.getPubsubSubscription());
                }
            }
        }
        if ((bigQueryTableOptions = (ExampleBigQueryTableOptions)this.options.as(ExampleBigQueryTableOptions.class)).getBigQueryDataset() != null && bigQueryTableOptions.getBigQueryTable() != null && bigQueryTableOptions.getBigQuerySchema() != null) {
            this.pendingMessages.add("The BigQuery table might contain the example's output, and it is not deleted automatically: " + bigQueryTableOptions.getProject() + ":" + bigQueryTableOptions.getBigQueryDataset() + "." + bigQueryTableOptions.getBigQueryTable());
            this.pendingMessages.add("Please go to the Developers Console to delete it manually. Otherwise, you may be charged for its usage.");
        }
    }

    private static Bigquery.Builder newBigQueryClient(BigQueryOptions options) {
        return new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), ExampleUtils.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404))))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    private static Pubsub.Builder newPubsubClient(PubsubOptions options) {
        return new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), ExampleUtils.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404))))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), httpRequestInitializer});
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private void setupBigQueryTable(String projectId, String datasetId, String tableId, TableSchema schema) throws IOException {
        Bigquery.Tables tableService;
        Table table;
        Bigquery.Datasets datasetService;
        if (this.bigQueryClient == null) {
            this.bigQueryClient = ExampleUtils.newBigQueryClient((BigQueryOptions)this.options.as(BigQueryOptions.class)).build();
        }
        if (ExampleUtils.executeNullIfNotFound((datasetService = this.bigQueryClient.datasets()).get(projectId, datasetId)) == null) {
            Dataset newDataset = new Dataset().setDatasetReference(new DatasetReference().setProjectId(projectId).setDatasetId(datasetId));
            datasetService.insert(projectId, newDataset).execute();
        }
        if ((table = (Table)ExampleUtils.executeNullIfNotFound((tableService = this.bigQueryClient.tables()).get(projectId, datasetId, tableId))) == null) {
            Table newTable = new Table().setSchema(schema).setTableReference(new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId));
            tableService.insert(projectId, datasetId, newTable).execute();
        } else if (!table.getSchema().equals((Object)schema)) {
            throw new RuntimeException("Table exists and schemas do not match, expecting: " + schema.toPrettyString() + ", actual: " + table.getSchema().toPrettyString());
        }
    }

    private void setupPubsubTopic(String topic) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = ExampleUtils.newPubsubClient((PubsubOptions)this.options.as(PubsubOptions.class)).build();
        }
        if (ExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().topics().get(topic)) == null) {
            this.pubsubClient.projects().topics().create(topic, new Topic().setName(topic)).execute();
        }
    }

    private void setupPubsubSubscription(String topic, String subscription) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = ExampleUtils.newPubsubClient((PubsubOptions)this.options.as(PubsubOptions.class)).build();
        }
        if (ExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().subscriptions().get(subscription)) == null) {
            Subscription subInfo = new Subscription().setAckDeadlineSeconds(Integer.valueOf(60)).setTopic(topic);
            this.pubsubClient.projects().subscriptions().create(subscription, subInfo).execute();
        }
    }

    private void deletePubsubTopic(String topic) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = ExampleUtils.newPubsubClient((PubsubOptions)this.options.as(PubsubOptions.class)).build();
        }
        if (ExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().topics().get(topic)) != null) {
            this.pubsubClient.projects().topics().delete(topic).execute();
        }
    }

    private void deletePubsubSubscription(String subscription) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = ExampleUtils.newPubsubClient((PubsubOptions)this.options.as(PubsubOptions.class)).build();
        }
        if (ExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().subscriptions().get(subscription)) != null) {
            this.pubsubClient.projects().subscriptions().delete(subscription).execute();
        }
    }

    public void waitToFinish(PipelineResult result) {
        this.pipelinesToCancel.add(result);
        if (!((ExampleOptions)this.options.as(ExampleOptions.class)).getKeepJobsRunning()) {
            this.addShutdownHook(this.pipelinesToCancel);
        }
        try {
            result.waitUntilFinish();
        }
        catch (UnsupportedOperationException e) {
            this.tearDown();
            this.printPendingMessages();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to wait the pipeline until finish: " + result);
        }
    }

    private void addShutdownHook(final Collection<PipelineResult> pipelineResults) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ExampleUtils.this.tearDown();
                ExampleUtils.this.printPendingMessages();
                for (PipelineResult pipelineResult : pipelineResults) {
                    try {
                        pipelineResult.cancel();
                    }
                    catch (IOException e) {
                        System.out.println("Failed to cancel the job.");
                        System.out.println(e.getMessage());
                    }
                }
                for (PipelineResult pipelineResult : pipelineResults) {
                    boolean cancellationVerified = false;
                    for (int retryAttempts = 6; retryAttempts > 0; --retryAttempts) {
                        if (pipelineResult.getState().isTerminal()) {
                            cancellationVerified = true;
                            break;
                        }
                        System.out.println("The example pipeline is still running. Verifying the cancellation.");
                        Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.SECONDS);
                    }
                    if (cancellationVerified) continue;
                    System.out.println("Failed to verify the cancellation for job: " + pipelineResult);
                }
            }
        });
    }

    private void printPendingMessages() {
        System.out.println();
        System.out.println("***********************************************************");
        System.out.println("***********************************************************");
        for (String message : this.pendingMessages) {
            System.out.println(message);
        }
        System.out.println("***********************************************************");
        System.out.println("***********************************************************");
    }

    private static <T> T executeNullIfNotFound(AbstractGoogleClientRequest<T> request) throws IOException {
        try {
            return (T)request.execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }
}

