/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.DatastoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExampleUtils;
import org.apache.beam.examples.java.repackaged.com.google.common.base.MoreObjects;
import org.apache.beam.examples.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.joda.time.Duration;

public class AutoComplete {
    public static void main(String[] args) throws IOException {
        GlobalWindows windowFn;
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        options.setBigQuerySchema(FormatForBigquery.getSchema());
        ExampleUtils exampleUtils = new ExampleUtils(options);
        if (options.isStreaming()) {
            Preconditions.checkArgument(options.getOutputToDatastore() == false, "DatastoreIO is not supported in streaming.");
            windowFn = SlidingWindows.of((Duration)Duration.standardMinutes((long)30L)).every(Duration.standardSeconds((long)5L));
        } else {
            windowFn = new GlobalWindows();
        }
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection toWrite = (PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new ExtractHashtags()))).apply((PTransform)Window.into((WindowFn)windowFn))).apply((PTransform)ComputeTopCompletions.top(10, options.getRecursive()));
        if (options.getOutputToDatastore().booleanValue()) {
            ((PCollection)toWrite.apply("FormatForDatastore", (PTransform)ParDo.of((DoFn)new FormatForDatastore(options.getKind(), options.getDatastoreAncestorKey())))).apply((PTransform)DatastoreIO.v1().write().withProjectId(MoreObjects.firstNonNull(options.getOutputProject(), options.getProject())));
        }
        if (options.getOutputToBigQuery().booleanValue()) {
            exampleUtils.setupBigQueryTable();
            TableReference tableRef = new TableReference();
            tableRef.setProjectId(options.getProject());
            tableRef.setDatasetId(options.getBigQueryDataset());
            tableRef.setTableId(options.getBigQueryTable());
            ((PCollection)toWrite.apply((PTransform)ParDo.of((DoFn)new FormatForBigquery()))).apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withSchema(FormatForBigquery.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(options.isStreaming() ? BigQueryIO.Write.WriteDisposition.WRITE_APPEND : BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        }
        PipelineResult result = p.run();
        exampleUtils.waitToFinish(result);
    }

    public static interface Options
    extends ExampleOptions,
    ExampleBigQueryTableOptions,
    StreamingOptions {
        @Description(value="Input text file")
        @Validation.Required
        public String getInputFile();

        public void setInputFile(String var1);

        @Description(value="Whether to use the recursive algorithm")
        @Default.Boolean(value=true)
        public Boolean getRecursive();

        public void setRecursive(Boolean var1);

        @Description(value="Cloud Datastore entity kind")
        @Default.String(value="autocomplete-demo")
        public String getKind();

        public void setKind(String var1);

        @Description(value="Whether output to BigQuery")
        @Default.Boolean(value=true)
        public Boolean getOutputToBigQuery();

        public void setOutputToBigQuery(Boolean var1);

        @Description(value="Whether output to Cloud Datastore")
        @Default.Boolean(value=false)
        public Boolean getOutputToDatastore();

        public void setOutputToDatastore(Boolean var1);

        @Description(value="Cloud Datastore ancestor key")
        @Default.String(value="root")
        public String getDatastoreAncestorKey();

        public void setDatastoreAncestorKey(String var1);

        @Description(value="Cloud Datastore output project ID, defaults to project ID")
        public String getOutputProject();

        public void setOutputProject(String var1);
    }

    static class FormatForDatastore
    extends DoFn<KV<String, List<CompletionCandidate>>, Entity> {
        private String kind;
        private String ancestorKey;

        public FormatForDatastore(String kind, String ancestorKey) {
            this.kind = kind;
            this.ancestorKey = ancestorKey;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Entity.Builder entityBuilder = Entity.newBuilder();
            Key key = DatastoreHelper.makeKey((Object[])new Object[]{DatastoreHelper.makeKey((Object[])new Object[]{this.kind, this.ancestorKey}).build(), this.kind, ((KV)c.element()).getKey()}).build();
            entityBuilder.setKey(key);
            ArrayList<Value> candidates = new ArrayList<Value>();
            HashMap<String, Value> properties = new HashMap<String, Value>();
            for (CompletionCandidate tag : (List)((KV)c.element()).getValue()) {
                Entity.Builder tagEntity = Entity.newBuilder();
                properties.put("tag", DatastoreHelper.makeValue((String)tag.value).build());
                properties.put("count", DatastoreHelper.makeValue((long)tag.count).build());
                candidates.add(DatastoreHelper.makeValue((Entity.Builder)tagEntity).build());
            }
            properties.put("candidates", DatastoreHelper.makeValue(candidates).build());
            entityBuilder.putAllProperties(properties);
            c.output((Object)entityBuilder.build());
        }
    }

    static class FormatForBigquery
    extends DoFn<KV<String, List<CompletionCandidate>>, TableRow> {
        FormatForBigquery() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            ArrayList<TableRow> completions = new ArrayList<TableRow>();
            for (CompletionCandidate cc : (List)((KV)c.element()).getValue()) {
                completions.add(new TableRow().set("count", (Object)cc.getCount()).set("tag", (Object)cc.getValue()));
            }
            TableRow row = new TableRow().set("prefix", ((KV)c.element()).getKey()).set("tags", completions);
            c.output((Object)row);
        }

        static TableSchema getSchema() {
            ArrayList<TableFieldSchema> tagFields = new ArrayList<TableFieldSchema>();
            tagFields.add(new TableFieldSchema().setName("count").setType("INTEGER"));
            tagFields.add(new TableFieldSchema().setName("tag").setType("STRING"));
            ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
            fields.add(new TableFieldSchema().setName("prefix").setType("STRING"));
            fields.add(new TableFieldSchema().setName("tags").setType("RECORD").setMode("REPEATED").setFields(tagFields));
            return new TableSchema().setFields(fields);
        }
    }

    static class ExtractHashtags
    extends DoFn<String, String> {
        ExtractHashtags() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Matcher m = Pattern.compile("#\\S+").matcher((CharSequence)c.element());
            while (m.find()) {
                c.output((Object)m.group().substring(1));
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class CompletionCandidate
    implements Comparable<CompletionCandidate> {
        private long count;
        private String value;

        public CompletionCandidate(String value, long count) {
            this.value = value;
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public String getValue() {
            return this.value;
        }

        public CompletionCandidate() {
        }

        @Override
        public int compareTo(CompletionCandidate o) {
            if (this.count < o.count) {
                return -1;
            }
            if (this.count == o.count) {
                return this.value.compareTo(o.value);
            }
            return 1;
        }

        public boolean equals(Object other) {
            if (other instanceof CompletionCandidate) {
                CompletionCandidate that = (CompletionCandidate)other;
                return this.count == that.count && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.count).hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return "CompletionCandidate[" + this.value + ", " + this.count + "]";
        }
    }

    private static class AllPrefixes
    extends DoFn<CompletionCandidate, KV<String, CompletionCandidate>> {
        private final int minPrefix;
        private final int maxPrefix;

        public AllPrefixes(int minPrefix) {
            this(minPrefix, Integer.MAX_VALUE);
        }

        public AllPrefixes(int minPrefix, int maxPrefix) {
            this.minPrefix = minPrefix;
            this.maxPrefix = maxPrefix;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String word = ((CompletionCandidate)c.element()).value;
            for (int i = this.minPrefix; i <= Math.min(word.length(), this.maxPrefix); ++i) {
                c.output((Object)KV.of((Object)word.substring(0, i), (Object)c.element()));
            }
        }
    }

    private static class ComputeTopRecursive
    extends PTransform<PCollection<CompletionCandidate>, PCollectionList<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopRecursive(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollectionList<KV<String, List<CompletionCandidate>>> expand(PCollection<CompletionCandidate> input) {
            if (this.minPrefix > 10) {
                return (PCollectionList)((PCollection)input.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, this.minPrefix))).apply((PTransform)Partition.of((int)2, (Partition.PartitionFn)new KeySizePartitionFn()));
            }
            PCollectionList larger = (PCollectionList)input.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, this.minPrefix + 1));
            PCollection small = (PCollection)((PCollection)((PCollection)PCollectionList.of((PCollection)((PCollection)larger.get(1).apply((PTransform)ParDo.of((DoFn)new FlattenTops())))).and((PCollection)input.apply((PTransform)Filter.by((SerializableFunction)new SerializableFunction<CompletionCandidate, Boolean>(){

                public Boolean apply(CompletionCandidate c) {
                    return c.getValue().length() == ComputeTopRecursive.this.minPrefix;
                }
            }))).apply("FlattenSmall", (PTransform)Flatten.pCollections())).apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix, this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix));
            PCollection flattenLarger = (PCollection)larger.apply("FlattenLarge", (PTransform)Flatten.pCollections());
            return PCollectionList.of((PCollection)flattenLarger).and(small);
        }

        private static class FlattenTops
        extends DoFn<KV<String, List<CompletionCandidate>>, CompletionCandidate> {
            private FlattenTops() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                for (CompletionCandidate cc : (List)((KV)c.element()).getValue()) {
                    c.output((Object)cc);
                }
            }
        }

        private class KeySizePartitionFn
        implements Partition.PartitionFn<KV<String, List<CompletionCandidate>>> {
            private KeySizePartitionFn() {
            }

            public int partitionFor(KV<String, List<CompletionCandidate>> elem, int numPartitions) {
                return ((String)elem.getKey()).length() > ComputeTopRecursive.this.minPrefix ? 0 : 1;
            }
        }
    }

    private static class ComputeTopFlat
    extends PTransform<PCollection<CompletionCandidate>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopFlat(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollection<KV<String, List<CompletionCandidate>>> expand(PCollection<CompletionCandidate> input) {
            return (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix).withHotKeyFanout((SerializableFunction)new HotKeyFanout()));
        }

        private static class HotKeyFanout
        implements SerializableFunction<String, Integer> {
            private HotKeyFanout() {
            }

            public Integer apply(String input) {
                return (int)Math.pow(4.0, 5 - input.length());
            }
        }
    }

    public static class ComputeTopCompletions
    extends PTransform<PCollection<String>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final boolean recursive;

        protected ComputeTopCompletions(int candidatesPerPrefix, boolean recursive) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.recursive = recursive;
        }

        public static ComputeTopCompletions top(int candidatesPerPrefix, boolean recursive) {
            return new ComputeTopCompletions(candidatesPerPrefix, recursive);
        }

        public PCollection<KV<String, List<CompletionCandidate>>> expand(PCollection<String> input) {
            PCollection candidates = (PCollection)((PCollection)input.apply(Count.perElement())).apply("CreateCompletionCandidates", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Long>, CompletionCandidate>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)new CompletionCandidate((String)((KV)c.element()).getKey(), (Long)((KV)c.element()).getValue()));
                }
            }));
            if (this.recursive) {
                return (PCollection)((PCollectionList)candidates.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, 1))).apply((PTransform)Flatten.pCollections());
            }
            return (PCollection)candidates.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, 1));
        }
    }
}

