/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggingWordCount {
    static void runDebuggingWordCount(WordCountOptions options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection filteredWords = (PCollection)((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)new WordCount.CountWords())).apply((PTransform)ParDo.of((DoFn)new FilterTextFn(options.getFilterPattern())));
        List<KV> expectedResults = Arrays.asList(KV.of((Object)"Flourish", (Object)3L), KV.of((Object)"stomach", (Object)1L));
        PAssert.that((PCollection)filteredWords).containsInAnyOrder(expectedResults);
        p.run().waitUntilFinish();
    }

    public static void main(String[] args) {
        WordCountOptions options = (WordCountOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(WordCountOptions.class);
        DebuggingWordCount.runDebuggingWordCount(options);
    }

    public static interface WordCountOptions
    extends WordCount.WordCountOptions {
        @Description(value="Regex filter pattern to use in DebuggingWordCount. Only words matching this pattern will be counted.")
        @Default.String(value="Flourish|stomach")
        public String getFilterPattern();

        public void setFilterPattern(String var1);
    }

    public static class FilterTextFn
    extends DoFn<KV<String, Long>, KV<String, Long>> {
        private static final Logger LOG = LoggerFactory.getLogger(FilterTextFn.class);
        private final Pattern filter;
        private final Counter matchedWords = Metrics.counter(FilterTextFn.class, (String)"matchedWords");
        private final Counter unmatchedWords = Metrics.counter(FilterTextFn.class, (String)"unmatchedWords");

        public FilterTextFn(String pattern) {
            this.filter = Pattern.compile(pattern);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            if (this.filter.matcher((CharSequence)((KV)c.element()).getKey()).matches()) {
                LOG.debug("Matched: " + (String)((KV)c.element()).getKey());
                this.matchedWords.inc();
                c.output((Object)((KV)c.element()));
            } else {
                LOG.trace("Did not match: " + (String)((KV)c.element()).getKey());
                this.unmatchedWords.inc();
            }
        }
    }
}

