/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

public class SerializableFunctions {
    private static final SerializableFunction<FailsafeElement<String, String>, String> csvErrorConverter = (SerializableFunction & Serializable)failsafeElement -> {
        ArrayList<String> outputRow = new ArrayList<String>();
        String message = (String)failsafeElement.getOriginalPayload();
        String timestamp = Instant.now().toString();
        outputRow.add(timestamp);
        outputRow.add((String)MoreObjects.firstNonNull((Object)failsafeElement.getErrorMessage(), (Object)""));
        outputRow.add((String)MoreObjects.firstNonNull((Object)failsafeElement.getStacktrace(), (Object)""));
        if (failsafeElement.getOriginalPayload() != null) {
            outputRow.add(message);
        }
        return String.join((CharSequence)",", outputRow);
    };

    public static SerializableFunction<FailsafeElement<String, String>, String> getCsvErrorConverter() {
        return csvErrorConverter;
    }
}

