/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import java.util.Objects;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElementCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

@DefaultCoder(value=FailsafeElementCoder.class)
public class FailsafeElement<OriginalT, CurrentT> {
    private final OriginalT originalPayload;
    private final CurrentT payload;
    @Nullable
    private @org.checkerframework.checker.nullness.qual.Nullable String errorMessage = null;
    @Nullable
    private @org.checkerframework.checker.nullness.qual.Nullable String stacktrace = null;

    private FailsafeElement(OriginalT originalPayload, CurrentT payload) {
        this.originalPayload = originalPayload;
        this.payload = payload;
    }

    public static <OriginalT, CurrentT> FailsafeElement<OriginalT, CurrentT> of(OriginalT originalPayload, CurrentT currentPayload) {
        return new FailsafeElement<OriginalT, CurrentT>(originalPayload, currentPayload);
    }

    public static <OriginalT, CurrentT> FailsafeElement<OriginalT, CurrentT> of(FailsafeElement<OriginalT, CurrentT> other) {
        return new FailsafeElement<OriginalT, CurrentT>(other.originalPayload, other.payload).setErrorMessage(other.getErrorMessage()).setStacktrace(other.getStacktrace());
    }

    public OriginalT getOriginalPayload() {
        return this.originalPayload;
    }

    public CurrentT getPayload() {
        return this.payload;
    }

    public @org.checkerframework.checker.nullness.qual.Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public FailsafeElement<OriginalT, CurrentT> setErrorMessage(@org.checkerframework.checker.nullness.qual.Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public @org.checkerframework.checker.nullness.qual.Nullable String getStacktrace() {
        return this.stacktrace;
    }

    public FailsafeElement<OriginalT, CurrentT> setStacktrace(@org.checkerframework.checker.nullness.qual.Nullable String stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.originalPayload, this.payload, this.errorMessage, this.stacktrace);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("originalPayload", this.originalPayload).add("payload", this.payload).add("errorMessage", (Object)this.errorMessage).add("stacktrace", (Object)this.stacktrace).toString();
    }
}

