/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.utils;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.ExecutableFile;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallingSubProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CallingSubProcessUtils.class);
    static boolean initCompleted = false;
    private static final Set<String> downloadedFiles = Sets.newConcurrentHashSet();
    private static Map<String, Semaphore> semaphores = new ConcurrentHashMap<String, Semaphore>();

    private CallingSubProcessUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(SubProcessConfiguration configuration, String binaryName) throws Exception {
        if (!semaphores.containsKey(binaryName)) {
            CallingSubProcessUtils.initSemaphore(configuration.getConcurrency(), binaryName);
        }
        Set<String> set = downloadedFiles;
        synchronized (set) {
            if (!downloadedFiles.contains(binaryName)) {
                FileUtils.createDirectoriesOnWorker(configuration);
                LOG.info("Calling filesetup to move Executables to worker.");
                ExecutableFile executableFile = new ExecutableFile(configuration, binaryName);
                FileUtils.copyFileFromGCSToWorker(executableFile);
                downloadedFiles.add(binaryName);
            }
        }
    }

    public static synchronized void initSemaphore(Integer permits, String binaryName) {
        if (!semaphores.containsKey(binaryName)) {
            LOG.info(String.format(String.format("Initialized Semaphore for binary %s ", binaryName), new Object[0]));
            semaphores.put(binaryName, new Semaphore(permits));
        }
    }

    private static void aquireSemaphore(String binaryName) throws IllegalStateException {
        if (!semaphores.containsKey(binaryName)) {
            throw new IllegalStateException("Semaphore is NULL, check init logic in @Setup.");
        }
        try {
            semaphores.get(binaryName).acquire();
        }
        catch (InterruptedException ex) {
            LOG.error("Interupted during aquire", (Throwable)ex);
        }
    }

    private static void releaseSemaphore(String binaryName) throws IllegalStateException {
        if (!semaphores.containsKey(binaryName)) {
            throw new IllegalStateException("Semaphore is NULL, check init logic in @Setup.");
        }
        semaphores.get(binaryName).release();
    }

    public static class Permit
    implements AutoCloseable {
        private String binaryName;

        public Permit(String binaryName) {
            this.binaryName = binaryName;
            CallingSubProcessUtils.aquireSemaphore(binaryName);
        }

        @Override
        public void close() {
            CallingSubProcessUtils.releaseSemaphore(this.binaryName);
        }
    }
}

