/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets.transforms.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryMyData;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryReadFromQuery;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryReadFromTable;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryReadFromTableWithBigQueryStorageAPI;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQuerySchemaCreate;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryTableRowCreate;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryWriteToTable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQuerySamplesIT {
    private static final String PROJECT = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
    private static final BigQuery BIGQUERY = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(PROJECT)).build().getService();
    private static final String DATASET = "beam_bigquery_samples_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    @Rule
    public final transient TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public final transient TestPipeline readTablePipeline = TestPipeline.create();
    @Rule
    public final transient TestPipeline readQueryPipeline = TestPipeline.create();
    @Rule
    public final transient TestPipeline readBQStorageAPIPipeline = TestPipeline.create();
    @Rule
    public final TestName testName = new TestName();
    private static List<String> expected = Arrays.asList("string: UTF-8 strings are supported! \ud83c\udf31\ud83c\udf33\ud83c\udf0d", "int64: 432", "float64: 3.14159265", "numeric: 1234.56", "bool: true", "bytes: VVRGLTggYnl0ZSBzdHJpbmcg8J+MsfCfjLPwn4yN", "date: 2020-03-19", "datetime: 2020-03-19T20:41:25.123", "time: 20:41:25.123", "timestamp: 2020-03-20T03:41:42.123Z", "geography: POINT(30 10)", "array: [1, 2, 3, 4]", "struct: {string: Text \ud83c\udf31\ud83c\udf33\ud83c\udf0d, int64: 42}");

    @BeforeClass
    public static void beforeAll() throws Exception {
        BIGQUERY.create(DatasetInfo.newBuilder((String)PROJECT, (String)DATASET).build(), new BigQuery.DatasetOption[0]);
    }

    @AfterClass
    public static void afterAll() {
        BIGQUERY.delete(DatasetId.of((String)PROJECT, (String)DATASET), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    @Test
    public void testTableIO() throws Exception {
        String table = this.testName.getMethodName();
        TableSchema schema = BigQuerySchemaCreate.createSchema();
        PCollection rows = (PCollection)this.writePipeline.apply((PTransform)Create.of(Arrays.asList(BigQueryTableRowCreate.createTableRow())));
        BigQueryWriteToTable.writeToTable((String)PROJECT, (String)DATASET, (String)table, (TableSchema)schema, (PCollection)rows);
        this.writePipeline.run().waitUntilFinish();
        String query = String.format("SELECT * FROM `%s.%s.%s`", PROJECT, DATASET, table);
        List queryResults = StreamSupport.stream(BIGQUERY.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]).iterateAll().spliterator(), false).flatMap(values -> BigQuerySamplesIT.fieldValueListToStrings(values).stream()).collect(Collectors.toList());
        Assert.assertEquals(expected, queryResults);
        BigQuerySamplesIT.readAndCheck((PCollection<BigQueryMyData.MyData>)BigQueryReadFromTable.readFromTable((String)PROJECT, (String)DATASET, (String)table, (Pipeline)this.readTablePipeline));
        this.readTablePipeline.run().waitUntilFinish();
        BigQuerySamplesIT.readAndCheck((PCollection<BigQueryMyData.MyData>)BigQueryReadFromQuery.readFromQuery((String)PROJECT, (String)DATASET, (String)table, (Pipeline)this.readQueryPipeline));
        this.readQueryPipeline.run().waitUntilFinish();
        BigQuerySamplesIT.readAndCheck((PCollection<BigQueryMyData.MyData>)BigQueryReadFromTableWithBigQueryStorageAPI.readFromTableWithBigQueryStorageAPI((String)PROJECT, (String)DATASET, (String)table, (Pipeline)this.readBQStorageAPIPipeline));
        this.readBQStorageAPIPipeline.run().waitUntilFinish();
    }

    private static void readAndCheck(PCollection<BigQueryMyData.MyData> rows) {
        PCollection contents = (PCollection)rows.apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(BigQuerySamplesIT::myDataToStrings));
        PAssert.that((PCollection)contents).containsInAnyOrder(expected);
    }

    private static List<String> myDataToStrings(BigQueryMyData.MyData data) {
        return Arrays.asList(String.format("string: %s", data.myString), String.format("int64: %d", data.myInt64), String.format("float64: %.8f", data.myFloat64), String.format("numeric: %.2f", data.myNumeric.doubleValue()), String.format("bool: %s", data.myBoolean), String.format("bytes: %s", Base64.getEncoder().encodeToString(data.myBytes)), String.format("date: %s", data.myDate), String.format("datetime: %s", data.myDateTime), String.format("time: %s", data.myTime), String.format("timestamp: %s", data.myTimestamp), String.format("geography: %s", data.myGeography), String.format("array: %s", data.myArray), String.format("struct: {string: %s, int64: %s}", data.myStruct.stringValue, data.myStruct.int64Value));
    }

    private static List<String> fieldValueListToStrings(FieldValueList row) {
        BigQueryMyData.MyData data = new BigQueryMyData.MyData();
        data.myString = row.get("string_field").getStringValue();
        data.myInt64 = row.get("int64_field").getLongValue();
        data.myFloat64 = row.get("float64_field").getDoubleValue();
        data.myNumeric = new BigDecimal(row.get("numeric_field").getDoubleValue());
        data.myBoolean = row.get("bool_field").getBooleanValue();
        data.myBytes = Base64.getDecoder().decode(row.get("bytes_field").getStringValue());
        data.myDate = LocalDate.parse(row.get("date_field").getStringValue()).toString();
        data.myDateTime = LocalDateTime.parse(row.get("datetime_field").getStringValue()).toString();
        data.myTime = LocalTime.parse(row.get("time_field").getStringValue()).toString();
        data.myTimestamp = Instant.ofEpochMilli((long)(Double.parseDouble(row.get("timestamp_field").getStringValue()) * 1000.0)).toString();
        data.myGeography = row.get("geography_field").getStringValue();
        data.myArray = row.get("array_field").getRepeatedValue().stream().map(FieldValue::getLongValue).collect(Collectors.toList());
        FieldValueList structValues = row.get("struct_field").getRecordValue();
        data.myStruct = new BigQueryMyData.MyStruct();
        data.myStruct.stringValue = structValues.get(0).getStringValue();
        data.myStruct.int64Value = structValues.get(1).getLongValue();
        return BigQuerySamplesIT.myDataToStrings(data);
    }
}

